/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.client.californium.endpoint.CaliforniumClientEndpoint;
import org.eclipse.leshan.client.californium.endpoint.CaliforniumClientEndpointFactory;
import org.eclipse.leshan.client.californium.endpoint.ClientCoapMessageTranslator;
import org.eclipse.leshan.client.californium.endpoint.ClientProtocolProvider;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.californium.endpoint.coap.CoapClientProtocolProvider;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.endpoint.LwM2mClientEndpoint;
import org.eclipse.leshan.client.endpoint.LwM2mClientEndpointsProvider;
import org.eclipse.leshan.client.request.DownlinkRequestReceiver;
import org.eclipse.leshan.client.resource.LwM2mObjectTree;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.peer.PskIdentity;
import org.eclipse.leshan.core.peer.RpkIdentity;
import org.eclipse.leshan.core.peer.X509Identity;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumClientEndpointsProvider
implements LwM2mClientEndpointsProvider {
    private final Logger LOG = LoggerFactory.getLogger(CaliforniumClientEndpointsProvider.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
    protected boolean started = false;
    private final Configuration serverConfig;
    private final List<CaliforniumClientEndpointFactory> endpointsFactory;
    private final ClientCoapMessageTranslator messagetranslator = new ClientCoapMessageTranslator();
    private final ServerIdentityExtractor identityExtrator;
    private final IdentityHandlerProvider identityHandlerProvider;
    private LwM2mObjectTree objectTree;
    private final InetAddress clientAddress;
    private LwM2mServer currentServer;
    private CaliforniumClientEndpoint endpoint;
    private CoapServer coapServer;

    public CaliforniumClientEndpointsProvider() {
        this(new Builder(new ClientProtocolProvider[0]).generateDefaultValue());
    }

    protected CaliforniumClientEndpointsProvider(Builder builder) {
        this.serverConfig = builder.configuration;
        this.endpointsFactory = builder.endpointsFactory;
        this.clientAddress = builder.clientAddress;
        this.identityHandlerProvider = new IdentityHandlerProvider();
        this.identityExtrator = new ServerIdentityExtractor(){

            @Override
            public LwM2mServer extractIdentity(Exchange exchange, IpPeer foreignPeer) {
                CoapEndpoint currentCoapEndpoint = CaliforniumClientEndpointsProvider.this.endpoint.getCoapEndpoint();
                Endpoint coapEndpoint = exchange.getEndpoint();
                if (coapEndpoint != null && coapEndpoint.equals(currentCoapEndpoint) && currentCoapEndpoint.isStarted()) {
                    if (CaliforniumClientEndpointsProvider.this.endpoint.getProtocol().equals((Object)Protocol.COAP)) {
                        if (CaliforniumClientEndpointsProvider.this.currentServer.getTransportData() instanceof IpPeer) {
                            IpPeer currentIpServer = (IpPeer)CaliforniumClientEndpointsProvider.this.currentServer.getTransportData();
                            if (!currentIpServer.getSocketAddress().equals(foreignPeer.getSocketAddress())) {
                                return null;
                            }
                        } else {
                            throw new IllegalStateException(String.format("%s is not a LwM2mPeer supported by this class", CaliforniumClientEndpointsProvider.this.currentServer.getTransportData().getClass().getSimpleName()));
                        }
                    }
                    if (!(!(CaliforniumClientEndpointsProvider.this.currentServer.getTransportData().getIdentity() instanceof OscoreIdentity) || foreignPeer.getIdentity() instanceof OscoreIdentity && foreignPeer.getIdentity().equals(CaliforniumClientEndpointsProvider.this.currentServer.getTransportData().getIdentity()))) {
                        return null;
                    }
                    return CaliforniumClientEndpointsProvider.this.currentServer;
                }
                return null;
            }
        };
    }

    public void init(final LwM2mObjectTree objectTree, final DownlinkRequestReceiver requestReceiver, final ClientEndpointToolbox toolbox) {
        this.objectTree = objectTree;
        this.coapServer = new CoapServer(this.serverConfig, new int[0]){

            protected Resource createRoot() {
                return CaliforniumClientEndpointsProvider.this.messagetranslator.createRootResource(CaliforniumClientEndpointsProvider.this.coapServer, CaliforniumClientEndpointsProvider.this.identityHandlerProvider, CaliforniumClientEndpointsProvider.this.identityExtrator, requestReceiver, toolbox, objectTree);
            }
        };
        List<Resource> resources = this.messagetranslator.createResources(this.coapServer, this.identityHandlerProvider, this.identityExtrator, requestReceiver, toolbox, objectTree);
        this.coapServer.add(resources.toArray(new Resource[resources.size()]));
    }

    public LwM2mServer createEndpoint(ServerInfo serverInfo, boolean clientInitiatedOnly, List<Certificate> trustStore, ClientEndpointToolbox toolbox) {
        for (CaliforniumClientEndpointFactory endpointFactory : this.endpointsFactory) {
            CoapEndpoint coapEndpoint;
            if (!endpointFactory.getProtocol().getUriScheme().equals(serverInfo.getFullUri().getScheme()) || (coapEndpoint = endpointFactory.createCoapEndpoint(this.clientAddress, this.serverConfig, serverInfo, clientInitiatedOnly, trustStore, toolbox)) == null) continue;
            IdentityHandler identityHandler = endpointFactory.createIdentityHandler();
            this.identityHandlerProvider.addIdentityHandler((Endpoint)coapEndpoint, identityHandler);
            this.endpoint = new CaliforniumClientEndpoint(endpointFactory.getProtocol(), endpointFactory.getEndpointDescription(), coapEndpoint, this.messagetranslator, toolbox, identityHandler, endpointFactory.createConnectionController(), this.objectTree.getModel(), endpointFactory.createExceptionTranslator(), this.executor);
            this.coapServer.addEndpoint((Endpoint)coapEndpoint);
            this.currentServer = this.extractIdentity(serverInfo);
            if (this.started) {
                this.coapServer.start();
                try {
                    coapEndpoint.start();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to start endpoint", e);
                }
            }
            return this.currentServer;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LwM2mServer extractIdentity(ServerInfo serverInfo) {
        IpPeer transportData;
        if (serverInfo.isSecure()) {
            if (serverInfo.secureMode == SecurityMode.PSK) {
                transportData = new IpPeer(serverInfo.getAddress(), (LwM2mIdentity)new PskIdentity(serverInfo.pskId));
            } else if (serverInfo.secureMode == SecurityMode.RPK) {
                transportData = new IpPeer(serverInfo.getAddress(), (LwM2mIdentity)new RpkIdentity(serverInfo.serverPublicKey));
            } else {
                if (serverInfo.secureMode != SecurityMode.X509) throw new RuntimeException("Unable to create connector : unsupported security mode");
                transportData = new IpPeer(serverInfo.getAddress(), (LwM2mIdentity)new X509Identity("*"));
            }
        } else {
            transportData = serverInfo.useOscore ? new IpPeer(serverInfo.getAddress(), (LwM2mIdentity)new OscoreIdentity(serverInfo.oscoreSetting.getRecipientId())) : new IpPeer(serverInfo.getAddress());
        }
        if (!serverInfo.bootstrap) return new LwM2mServer((LwM2mPeer)transportData, Long.valueOf(serverInfo.serverId), serverInfo.serverUri);
        return new LwM2mServer((LwM2mPeer)transportData, serverInfo.serverUri);
    }

    public Collection<LwM2mServer> createEndpoints(Collection<? extends ServerInfo> serverInfo, boolean clientInitiatedOnly, List<Certificate> trustStore, ClientEndpointToolbox toolbox) {
        return null;
    }

    public void destroyEndpoints() {
        this.identityHandlerProvider.clear();
        for (Endpoint endpoint : this.coapServer.getEndpoints()) {
            this.coapServer.getEndpoints().remove(endpoint);
            endpoint.destroy();
        }
    }

    public CoapServer getCoapServer() {
        return this.coapServer;
    }

    public LwM2mClientEndpoint getEndpoint(LwM2mServer server) {
        if (this.currentServer != null && this.currentServer.equals((Object)server)) {
            return this.endpoint;
        }
        return null;
    }

    public List<LwM2mClientEndpoint> getEndpoints() {
        return Arrays.asList(this.endpoint);
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.coapServer.getEndpoints().isEmpty()) {
            return;
        }
        this.coapServer.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.coapServer.getEndpoints().isEmpty()) {
            return;
        }
        this.coapServer.stop();
    }

    public synchronized void destroy() {
        if (this.started) {
            this.started = false;
        }
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.warn("Destroying RequestSender was interrupted.", (Throwable)e);
        }
        this.coapServer.destroy();
    }

    public static class Builder {
        private final List<ClientProtocolProvider> protocolProviders = new ArrayList<ClientProtocolProvider>();
        private Configuration configuration;
        private final List<CaliforniumClientEndpointFactory> endpointsFactory;
        private InetAddress clientAddress;

        public Builder(ClientProtocolProvider ... protocolProviders) {
            if (protocolProviders.length == 0) {
                this.protocolProviders.add(new CoapClientProtocolProvider());
            } else {
                this.protocolProviders.addAll(Arrays.asList(protocolProviders));
            }
            this.endpointsFactory = new ArrayList<CaliforniumClientEndpointFactory>();
        }

        public Configuration createDefaultConfiguration() {
            HashSet<Configuration.ModuleDefinitionsProvider> moduleProviders = new HashSet<Configuration.ModuleDefinitionsProvider>();
            for (ClientProtocolProvider protocolProvider : this.protocolProviders) {
                moduleProviders.addAll(protocolProvider.getModuleDefinitionsProviders());
            }
            Configuration configuration = new Configuration(moduleProviders.toArray(new Configuration.ModuleDefinitionsProvider[moduleProviders.size()]));
            for (ClientProtocolProvider protocolProvider : this.protocolProviders) {
                protocolProvider.applyDefaultValue(configuration);
            }
            return configuration;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setClientAddress(InetAddress addr) {
            this.clientAddress = addr;
            return this;
        }

        protected Builder generateDefaultValue() {
            if (this.configuration == null) {
                this.configuration = this.createDefaultConfiguration();
            }
            if (this.clientAddress == null) {
                this.clientAddress = new InetSocketAddress(0).getAddress();
            }
            if (this.endpointsFactory.isEmpty()) {
                for (ClientProtocolProvider protocolProvider : this.protocolProviders) {
                    this.endpointsFactory.add(protocolProvider.createDefaultEndpointFactory());
                }
            }
            return this;
        }

        public CaliforniumClientEndpointsProvider build() {
            this.generateDefaultValue();
            return new CaliforniumClientEndpointsProvider(this);
        }
    }
}

