/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint.coap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.List;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.client.californium.CaliforniumConnectionController;
import org.eclipse.leshan.client.californium.endpoint.CaliforniumClientEndpointFactory;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.californium.DefaultExceptionTranslator;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.DefaultCoapIdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;

public class CoapClientEndpointFactory
implements CaliforniumClientEndpointFactory {
    protected final String loggingTagPrefix;

    public CoapClientEndpointFactory() {
        this("LWM2M Client");
    }

    public CoapClientEndpointFactory(String loggingTagPrefix) {
        this.loggingTagPrefix = loggingTagPrefix;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.COAP;
    }

    @Override
    public String getEndpointDescription() {
        return "CoAP over UDP endpoint based on Californium library";
    }

    protected String getLoggingTag(URI uri) {
        if (this.loggingTagPrefix != null) {
            return String.format("[%s-%s]", this.loggingTagPrefix, uri);
        }
        return String.format("[%s]", uri);
    }

    @Override
    public CoapEndpoint createCoapEndpoint(InetAddress clientAddress, Configuration defaultConfiguration, ServerInfo serverInfo, boolean clientInitiatedOnly, List<Certificate> trustStore, ClientEndpointToolbox toolbox) {
        return this.createEndpointBuilder(new InetSocketAddress(clientAddress, 0), serverInfo, defaultConfiguration).build();
    }

    protected CoapEndpoint.Builder createEndpointBuilder(InetSocketAddress address, ServerInfo serverInfo, Configuration coapConfig) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setConnector(this.createConnector(address, coapConfig));
        builder.setConfiguration(coapConfig);
        builder.setLoggingTag(this.getLoggingTag(EndpointUriUtil.createUri((String)this.getProtocol().getUriScheme(), (InetSocketAddress)address)));
        return builder;
    }

    protected Connector createConnector(InetSocketAddress address, Configuration coapConfig) {
        return new UDPConnector(address, coapConfig);
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new DefaultCoapIdentityHandler();
    }

    @Override
    public CaliforniumConnectionController createConnectionController() {
        return new CaliforniumConnectionController(){

            @Override
            public void forceReconnection(Endpoint endpoint, LwM2mServer server, boolean resume) {
            }
        };
    }

    @Override
    public ExceptionTranslator createExceptionTranslator() {
        return new DefaultExceptionTranslator();
    }
}

