/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint.coap;

import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.CoapStackFactory;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.oscore.OSCoreCoapStackFactory;
import org.eclipse.californium.oscore.OSCoreEndpointContextInfo;
import org.eclipse.leshan.client.californium.CaliforniumConnectionController;
import org.eclipse.leshan.client.californium.endpoint.coap.CoapClientEndpointFactory;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.oscore.cf.InMemoryOscoreContextDB;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreParameters;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreStore;
import org.eclipse.leshan.core.californium.oscore.cf.StaticOscoreStore;
import org.eclipse.leshan.core.oscore.InvalidOscoreSettingException;
import org.eclipse.leshan.core.oscore.OscoreValidator;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapOscoreClientEndpointFactory
extends CoapClientEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoapOscoreClientEndpointFactory.class);

    @Override
    public String getEndpointDescription() {
        return super.getEndpointDescription() + " with very experimental support of OSCORE";
    }

    @Override
    protected CoapEndpoint.Builder createEndpointBuilder(InetSocketAddress address, ServerInfo serverInfo, Configuration coapConfig) {
        CoapEndpoint.Builder builder = super.createEndpointBuilder(address, serverInfo, coapConfig);
        if (serverInfo.useOscore) {
            LOG.warn("Experimental OSCORE support is used for {}", (Object)serverInfo.getFullUri().toASCIIString());
            try {
                new OscoreValidator().validateOscoreSetting(serverInfo.oscoreSetting);
            }
            catch (InvalidOscoreSettingException e) {
                throw new RuntimeException(String.format("Unable to create endpoint for %s using OSCORE : Invalid %s.", serverInfo, serverInfo.oscoreSetting), e);
            }
            AlgorithmID hkdfAlg = null;
            try {
                hkdfAlg = AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)serverInfo.oscoreSetting.getHkdfAlgorithm().getValue()));
            }
            catch (CoseException e) {
                throw new RuntimeException(String.format("Unable to create endpoint for %s using OSCORE : Unable to decode OSCORE HKDF from %s.", serverInfo, serverInfo.oscoreSetting), e);
            }
            AlgorithmID aeadAlg = null;
            try {
                aeadAlg = AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)serverInfo.oscoreSetting.getAeadAlgorithm().getValue()));
            }
            catch (CoseException e) {
                throw new RuntimeException(String.format("Unable to create endpoint for %s using OSCORE : Unable to decode OSCORE AEAD from %s.", serverInfo, serverInfo.oscoreSetting), e);
            }
            byte[] masterSalt = serverInfo.oscoreSetting.getMasterSalt().length == 0 ? null : serverInfo.oscoreSetting.getMasterSalt();
            OscoreParameters oscoreParameters = new OscoreParameters(serverInfo.oscoreSetting.getSenderId(), serverInfo.oscoreSetting.getRecipientId(), serverInfo.oscoreSetting.getMasterSecret(), aeadAlg, hkdfAlg, masterSalt);
            InMemoryOscoreContextDB oscoreCtxDB = new InMemoryOscoreContextDB((OscoreStore)new StaticOscoreStore(oscoreParameters));
            builder.setCustomCoapStackArgument((Object)oscoreCtxDB).setCoapStackFactory((CoapStackFactory)new OSCoreCoapStackFactory());
        }
        LOG.warn("Experimental OSCORE feature is enabled.");
        return builder;
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new IdentityHandler(){

            public LwM2mPeer getIdentity(Message receivedMessage) {
                EndpointContext context = receivedMessage.getSourceContext();
                InetSocketAddress peerAddress = context.getPeerAddress();
                Principal senderIdentity = context.getPeerIdentity();
                if (senderIdentity == null) {
                    if (context.get(OSCoreEndpointContextInfo.OSCORE_RECIPIENT_ID) != null) {
                        String recipient = (String)context.get(OSCoreEndpointContextInfo.OSCORE_RECIPIENT_ID);
                        return new IpPeer(peerAddress, (LwM2mIdentity)new OscoreIdentity(Hex.decodeHex((char[])recipient.toCharArray())));
                    }
                    return new IpPeer(peerAddress);
                }
                return null;
            }

            public EndpointContext createEndpointContext(LwM2mPeer client, boolean allowConnectionInitiation) {
                if (client instanceof IpPeer) {
                    return new AddressEndpointContext(((IpPeer)client).getSocketAddress());
                }
                throw new IllegalStateException(String.format("Unsupported Peer : %s", client));
            }
        };
    }

    @Override
    public CaliforniumConnectionController createConnectionController() {
        return new CaliforniumConnectionController(){

            @Override
            public void forceReconnection(Endpoint endpoint, LwM2mServer server, boolean resume) {
            }
        };
    }
}

