/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint.coaps;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeTimeoutException;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedSinglePskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.leshan.client.californium.CaConstraintCertificateVerifier;
import org.eclipse.leshan.client.californium.CaliforniumConnectionController;
import org.eclipse.leshan.client.californium.DomainIssuerCertificateVerifier;
import org.eclipse.leshan.client.californium.ServiceCertificateConstraintCertificateVerifier;
import org.eclipse.leshan.client.californium.TrustAnchorAssertionCertificateVerifier;
import org.eclipse.leshan.client.californium.endpoint.coap.CoapClientEndpointFactory;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.CertificateUsage;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.californium.DefaultExceptionTranslator;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.PskIdentity;
import org.eclipse.leshan.core.peer.RpkIdentity;
import org.eclipse.leshan.core.peer.X509Identity;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.util.X509CertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapsClientEndpointFactory
extends CoapClientEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoapsClientEndpointFactory.class);
    protected final String loggingTagPrefix;

    public CoapsClientEndpointFactory() {
        this("LWM2M Client");
    }

    @Override
    public String getEndpointDescription() {
        return "CoAP over DTLS endpoint based on Californium/Scandium library";
    }

    public CoapsClientEndpointFactory(String loggingTagPrefix) {
        this.loggingTagPrefix = loggingTagPrefix;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.COAPS;
    }

    @Override
    protected String getLoggingTag(URI uri) {
        if (this.loggingTagPrefix != null) {
            return String.format("[%s-%s]", this.loggingTagPrefix, uri);
        }
        return String.format("[%s]", uri);
    }

    @Override
    public CoapEndpoint createCoapEndpoint(InetAddress clientAddress, Configuration defaultConfiguration, ServerInfo serverInfo, boolean clientInitiatedOnly, List<Certificate> trustStore, ClientEndpointToolbox toolbox) {
        DtlsConnectorConfig dtlsConfig;
        if (!serverInfo.isSecure()) {
            return null;
        }
        DtlsConnectorConfig.Builder rootConfigBuilder = this.createRootDtlsConnectorConfigBuilder(defaultConfiguration);
        DtlsConnectorConfig.Builder effectiveConfigBuilder = this.createEffectiveDtlsConnectorConfigBuilder(new InetSocketAddress(clientAddress, 0), serverInfo, rootConfigBuilder, defaultConfiguration, clientInitiatedOnly, trustStore);
        try {
            dtlsConfig = effectiveConfigBuilder.build();
        }
        catch (IllegalStateException e) {
            LOG.warn("Unable to create DTLS config to create endpont to connect to {}.", (Object)serverInfo.getFullUri(), (Object)e);
            return null;
        }
        CoapEndpoint endpoint = this.createEndpointBuilder(dtlsConfig, defaultConfiguration).build();
        return endpoint;
    }

    protected DtlsConnectorConfig.Builder createRootDtlsConnectorConfigBuilder(Configuration configuration) {
        return new DtlsConnectorConfig.Builder(configuration);
    }

    protected DtlsConnectorConfig.Builder createEffectiveDtlsConnectorConfigBuilder(InetSocketAddress addr, ServerInfo serverInfo, DtlsConnectorConfig.Builder rootDtlsConfigBuilder, Configuration coapConfig, boolean clientInitiatedOnly, List<Certificate> trustStore) {
        if (serverInfo.isSecure()) {
            X509Certificate certificate;
            SingleCertificateProvider singleCertificateProvider;
            DtlsConnectorConfig incompleteConfig = rootDtlsConfigBuilder.getIncompleteConfig();
            DtlsConnectorConfig.Builder effectiveBuilder = DtlsConnectorConfig.builder((DtlsConnectorConfig)incompleteConfig);
            effectiveBuilder.setAddress(addr);
            if (serverInfo.secureMode == SecurityMode.PSK) {
                AdvancedSinglePskStore staticPskStore = new AdvancedSinglePskStore(serverInfo.pskId, serverInfo.pskKey);
                effectiveBuilder.setAdvancedPskStore((AdvancedPskStore)staticPskStore);
                this.filterCipherSuites(effectiveBuilder, incompleteConfig.getSupportedCipherSuites(), true, false);
            } else if (serverInfo.secureMode == SecurityMode.RPK) {
                singleCertificateProvider = new SingleCertificateProvider(serverInfo.privateKey, serverInfo.publicKey);
                singleCertificateProvider.setVerifyKeyPair(false);
                effectiveBuilder.setCertificateIdentityProvider((CertificateProvider)singleCertificateProvider);
                PublicKey expectedKey = serverInfo.serverPublicKey;
                NewAdvancedCertificateVerifier rpkVerifier = new StaticNewAdvancedCertificateVerifier.Builder().setTrustedRPKs(new RawPublicKeyIdentity[]{new RawPublicKeyIdentity(expectedKey)}).build();
                effectiveBuilder.setAdvancedCertificateVerifier(rpkVerifier);
                this.filterCipherSuites(effectiveBuilder, incompleteConfig.getSupportedCipherSuites(), false, true);
            } else if (serverInfo.secureMode == SecurityMode.X509) {
                CertificateUsage certificateUsage;
                singleCertificateProvider = new SingleCertificateProvider(serverInfo.privateKey, new Certificate[]{serverInfo.clientCertificate}, new CertificateType[0]);
                singleCertificateProvider.setVerifyKeyPair(false);
                effectiveBuilder.setCertificateIdentityProvider((CertificateProvider)singleCertificateProvider);
                CertificateUsage certificateUsage2 = certificateUsage = serverInfo.certificateUsage != null ? serverInfo.certificateUsage : CertificateUsage.DOMAIN_ISSUER_CERTIFICATE;
                if (certificateUsage == CertificateUsage.CA_CONSTRAINT) {
                    X509Certificate[] trustedCertificates = null;
                    if (trustStore != null) {
                        trustedCertificates = CertPathUtil.toX509CertificatesList(trustStore).toArray(new X509Certificate[trustStore.size()]);
                    }
                    effectiveBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new CaConstraintCertificateVerifier(serverInfo.serverCertificate, trustedCertificates));
                } else if (certificateUsage == CertificateUsage.SERVICE_CERTIFICATE_CONSTRAINT) {
                    X509Certificate[] trustedCertificates = null;
                    if (trustStore != null) {
                        trustedCertificates = CertPathUtil.toX509CertificatesList(trustStore).toArray(new X509Certificate[trustStore.size()]);
                    }
                    effectiveBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new ServiceCertificateConstraintCertificateVerifier(serverInfo.serverCertificate, trustedCertificates));
                } else if (certificateUsage == CertificateUsage.TRUST_ANCHOR_ASSERTION) {
                    effectiveBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new TrustAnchorAssertionCertificateVerifier((X509Certificate)serverInfo.serverCertificate));
                } else if (certificateUsage == CertificateUsage.DOMAIN_ISSUER_CERTIFICATE) {
                    effectiveBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new DomainIssuerCertificateVerifier(serverInfo.serverCertificate));
                }
                this.filterCipherSuites(effectiveBuilder, incompleteConfig.getSupportedCipherSuites(), false, true);
            } else {
                throw new RuntimeException("Unable to create connector : unsupported security mode");
            }
            DtlsConfig.DtlsRole dtlsRole = (DtlsConfig.DtlsRole)incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_ROLE);
            if (dtlsRole == null) {
                if (serverInfo.bootstrap) {
                    effectiveBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                } else if (clientInitiatedOnly) {
                    effectiveBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                } else {
                    effectiveBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.BOTH);
                }
            }
            if (incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.BOTH && serverInfo.secureMode == SecurityMode.X509 && CertPathUtil.canBeUsedForAuthentication((X509Certificate)(certificate = (X509Certificate)serverInfo.clientCertificate), (boolean)true) && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)false)) {
                effectiveBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                LOG.warn("Client certificate does not allow Server Authentication usage.\nThis will prevent a LWM2M server to initiate DTLS connection to this client.\nSee : https://github.com/eclipse/leshan/wiki/Server-Failover#about-connections");
            }
            return effectiveBuilder;
        }
        return null;
    }

    private void filterCipherSuites(DtlsConnectorConfig.Builder dtlsConfigurationBuilder, List<CipherSuite> ciphers, boolean psk, boolean requireServerCertificateMessage) {
        if (ciphers == null) {
            return;
        }
        ArrayList<CipherSuite> filteredCiphers = new ArrayList<CipherSuite>();
        for (CipherSuite cipher : ciphers) {
            if (psk && cipher.isPskBased()) {
                filteredCiphers.add(cipher);
                continue;
            }
            if (!requireServerCertificateMessage || !cipher.requiresServerCertificateMessage()) continue;
            filteredCiphers.add(cipher);
        }
        dtlsConfigurationBuilder.set((BasicDefinition)DtlsConfig.DTLS_CIPHER_SUITES, filteredCiphers);
    }

    protected CoapEndpoint.Builder createEndpointBuilder(DtlsConnectorConfig dtlsConfig, Configuration coapConfig) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setConnector(this.createSecuredConnector(dtlsConfig));
        builder.setConfiguration(coapConfig);
        builder.setLoggingTag(this.getLoggingTag(EndpointUriUtil.createUri((String)this.getProtocol().getUriScheme(), (InetSocketAddress)dtlsConfig.getAddress())));
        EndpointContextMatcher securedContextMatcher = this.createSecuredContextMatcher();
        builder.setEndpointContextMatcher(securedContextMatcher);
        return builder;
    }

    protected EndpointContextMatcher createSecuredContextMatcher() {
        return new PrincipalEndpointContextMatcher(){

            protected boolean matchPrincipals(Principal requestedPrincipal, Principal availablePrincipal) {
                return true;
            }
        };
    }

    protected Connector createSecuredConnector(DtlsConnectorConfig dtlsConfig) {
        return new DTLSConnector(dtlsConfig);
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new IdentityHandler(){

            public LwM2mPeer getIdentity(Message receivedMessage) {
                EndpointContext context = receivedMessage.getSourceContext();
                InetSocketAddress peerAddress = context.getPeerAddress();
                Principal senderIdentity = context.getPeerIdentity();
                if (senderIdentity != null) {
                    if (senderIdentity instanceof PreSharedKeyIdentity) {
                        return new IpPeer(peerAddress, (LwM2mIdentity)new PskIdentity(((PreSharedKeyIdentity)senderIdentity).getIdentity()));
                    }
                    if (senderIdentity instanceof RawPublicKeyIdentity) {
                        PublicKey publicKey = ((RawPublicKeyIdentity)senderIdentity).getKey();
                        return new IpPeer(peerAddress, (LwM2mIdentity)new RpkIdentity(publicKey));
                    }
                    if (senderIdentity instanceof X500Principal || senderIdentity instanceof X509CertPath) {
                        String x509CommonName = X509CertUtil.extractCN((String)senderIdentity.getName());
                        return new IpPeer(peerAddress, (LwM2mIdentity)new X509Identity(x509CommonName));
                    }
                    throw new IllegalStateException(String.format("Unable to extract sender identity : unexpected type of Principal %s [%s]", senderIdentity.getClass(), senderIdentity.toString()));
                }
                return null;
            }

            public EndpointContext createEndpointContext(LwM2mPeer client, boolean allowConnectionInitiation) {
                Object peerIdentity = null;
                if (client.getIdentity() instanceof PskIdentity) {
                    peerIdentity = new PreSharedKeyIdentity(((PskIdentity)client.getIdentity()).getPskIdentity());
                } else if (client.getIdentity() instanceof RpkIdentity) {
                    peerIdentity = new RawPublicKeyIdentity(((RpkIdentity)client.getIdentity()).getPublicKey());
                } else if (client.getIdentity() instanceof X509Identity) {
                    peerIdentity = new X500Principal("CN=" + ((X509Identity)client.getIdentity()).getX509CommonName());
                } else {
                    throw new IllegalStateException(String.format("Unsupported Identity : %s", client.getIdentity()));
                }
                if (client instanceof IpPeer) {
                    IpPeer ipClient = (IpPeer)client;
                    if (peerIdentity != null && allowConnectionInitiation) {
                        return new MapBasedEndpointContext(ipClient.getSocketAddress(), (Principal)peerIdentity, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_HANDSHAKE_MODE, (Object)"auto"));
                    }
                    return new AddressEndpointContext(ipClient.getSocketAddress(), (Principal)peerIdentity);
                }
                throw new IllegalStateException(String.format("Unsupported peer : %s", client));
            }
        };
    }

    @Override
    public CaliforniumConnectionController createConnectionController() {
        return new CaliforniumConnectionController(){

            @Override
            public void forceReconnection(Endpoint endpoint, LwM2mServer server, boolean resume) {
                Connector connector = ((CoapEndpoint)endpoint).getConnector();
                if (connector instanceof DTLSConnector) {
                    if (resume) {
                        LOG.info("Clear DTLS session for resumption for server {}", (Object)server.getUri());
                        ((DTLSConnector)connector).forceResumeAllSessions();
                    } else {
                        LOG.info("Clear DTLS session for server {}", (Object)server.getUri());
                        ((DTLSConnector)connector).clearConnectionState();
                    }
                }
            }
        };
    }

    @Override
    public ExceptionTranslator createExceptionTranslator() {
        return new DefaultExceptionTranslator(){

            public Exception translate(Request coapRequest, Throwable error) {
                if (error instanceof DtlsHandshakeTimeoutException) {
                    return new TimeoutException(TimeoutException.Type.DTLS_HANDSHAKE_TIMEOUT, error, "Request %s timeout : dtls handshake timeout", new Object[]{coapRequest.getURI()});
                }
                return super.translate(coapRequest, error);
            }
        };
    }
}

