/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.peer.IpPeer;

public class LwM2mClientCoapResource
extends LwM2mCoapResource {
    protected final ServerIdentityExtractor serverIdentityExtractor;

    public LwM2mClientCoapResource(String name, IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor identityExtractor) {
        super(name, identityHandlerProvider);
        this.serverIdentityExtractor = identityExtractor;
    }

    protected LwM2mServer getServerOrRejectRequest(CoapExchange exchange, Message receivedMessage) {
        LwM2mServer server = this.extractIdentity(exchange.advanced(), receivedMessage);
        if (server != null) {
            return server;
        }
        exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "unknown server");
        return null;
    }

    protected LwM2mServer extractIdentity(Exchange exchange, Message receivedMessage) {
        IpPeer foreignPeer = this.getForeignPeerIdentity(exchange, receivedMessage);
        if (foreignPeer == null) {
            return null;
        }
        return this.serverIdentityExtractor.extractIdentity(exchange, foreignPeer);
    }
}

