/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObserveRelationFilter;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.node.LwM2mPath;

public class ObserveCompositeRelationFilter
implements ObserveRelationFilter {
    private final List<LwM2mPath> paths;

    public ObserveCompositeRelationFilter(LwM2mPath ... paths) {
        this.paths = Arrays.asList(paths);
    }

    public boolean accept(ObserveRelation relation) {
        Request request = this.getRequest(relation);
        if (!this.isValidObserveCompositeRequest(request)) {
            return false;
        }
        List<LwM2mPath> observationPaths = this.getObserveRequestPaths(request);
        if (observationPaths != null) {
            for (LwM2mPath observePath : observationPaths) {
                for (LwM2mPath path : this.paths) {
                    if (!path.startWith(observePath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isValidObserveCompositeRequest(Request request) {
        if (!request.getCode().equals((Object)CoAP.Code.FETCH)) {
            return false;
        }
        return request.getOptions().hasContentFormat();
    }

    private Request getRequest(ObserveRelation relation) {
        return relation.getExchange().getRequest();
    }

    private List<LwM2mPath> getObserveRequestPaths(Request request) {
        return ObserveUtil.getPathsFromContext((Map)request.getUserContext());
    }
}

