/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.bootstrap;

import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.request.DownlinkRequestReceiver;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.SendableResponse;

public class BootstrapResource
extends LwM2mClientCoapResource {
    protected DownlinkRequestReceiver requestReceiver;

    public BootstrapResource(IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor serverIdentityExtractor, DownlinkRequestReceiver requestReceiver) {
        super("bs", identityHandlerProvider, serverIdentityExtractor);
        this.requestReceiver = requestReceiver;
        this.setVisible(false);
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        exchange.accept();
        final SendableResponse sendableResponse = this.requestReceiver.requestReceived(server, (DownlinkRequest)new BootstrapFinishRequest((Object)coapRequest));
        Response coapResponse = new Response(ResponseCodeUtil.toCoapResponseCode((ResponseCode)((BootstrapFinishResponse)sendableResponse.getResponse()).getCode()));
        if (((BootstrapFinishResponse)sendableResponse.getResponse()).getCode().isError()) {
            coapResponse.setConfirmable(true);
            coapResponse.setPayload(((BootstrapFinishResponse)sendableResponse.getResponse()).getErrorMessage());
            coapResponse.getOptions().setContentFormat(0);
        }
        coapResponse.addMessageObserver((MessageObserver)new MessageObserverAdapter(){

            public void onAcknowledgement() {
                sendableResponse.sent();
            }
        });
        exchange.respond(coapResponse);
    }
}

