/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.leshan.client.californium.ObserveCompositeRelationFilter;
import org.eclipse.leshan.client.californium.RootResource;
import org.eclipse.leshan.client.californium.bootstrap.BootstrapResource;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.californium.object.ObjectResource;
import org.eclipse.leshan.client.californium.request.CoapRequestBuilder;
import org.eclipse.leshan.client.californium.request.LwM2mResponseBuilder;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.notification.NotificationManager;
import org.eclipse.leshan.client.request.DownlinkRequestReceiver;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.LwM2mObjectTree;
import org.eclipse.leshan.client.resource.listener.ObjectListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListenerAdapter;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.request.UplinkRequestVisitor;
import org.eclipse.leshan.core.response.LwM2mResponse;

public class ClientCoapMessageTranslator {
    public Request createCoapRequest(LwM2mServer server, UplinkRequest<? extends LwM2mResponse> lwm2mRequest, ClientEndpointToolbox toolbox, LwM2mModel model, IdentityHandler identityHandler) {
        LwM2mPeer lwm2mPeer = server.getTransportData();
        if (!(lwm2mPeer instanceof IpPeer)) {
            throw new IllegalStateException(String.format("%s is not a LwM2mPeer supported by this class", server.getClass().getSimpleName()));
        }
        CoapRequestBuilder builder = new CoapRequestBuilder((IpPeer)lwm2mPeer, toolbox.getEncoder(), model, toolbox.getLinkSerializer(), identityHandler);
        lwm2mRequest.accept((UplinkRequestVisitor)builder);
        return builder.getRequest();
    }

    public <T extends LwM2mResponse> T createLwM2mResponse(LwM2mServer server, UplinkRequest<T> lwm2mRequest, Request coapRequest, Response coapResponse, ClientEndpointToolbox toolbox) {
        LwM2mResponseBuilder builder = new LwM2mResponseBuilder(coapResponse);
        lwm2mRequest.accept(builder);
        return builder.getResponse();
    }

    public Resource createRootResource(CoapServer coapServer, IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor identityExtrator, DownlinkRequestReceiver requestReceiver, ClientEndpointToolbox toolbox, LwM2mObjectTree objectTree) {
        final RootResource rootResource = new RootResource(identityHandlerProvider, identityExtrator, coapServer, requestReceiver, toolbox);
        objectTree.addListener((ObjectsListener)new ObjectsListenerAdapter(){

            public void resourceChanged(LwM2mPath ... paths) {
                rootResource.changed(new ObserveCompositeRelationFilter(paths));
            }
        });
        return rootResource;
    }

    public List<Resource> createResources(final CoapServer coapServer, final IdentityHandlerProvider identityHandlerProvider, final ServerIdentityExtractor identityExtrator, final DownlinkRequestReceiver requestReceiver, final NotificationManager notificationManager, final ClientEndpointToolbox toolbox, LwM2mObjectTree objectTree) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add((Resource)new BootstrapResource(identityHandlerProvider, identityExtrator, requestReceiver));
        for (LwM2mObjectEnabler enabler : objectTree.getObjectEnablers().values()) {
            resources.add((Resource)this.createObjectResource(enabler, identityHandlerProvider, identityExtrator, requestReceiver, notificationManager, toolbox));
        }
        objectTree.addListener((ObjectsListener)new ObjectsListenerAdapter(){

            public void objectAdded(LwM2mObjectEnabler object) {
                CoapResource clientObject = ClientCoapMessageTranslator.this.createObjectResource(object, identityHandlerProvider, identityExtrator, requestReceiver, notificationManager, toolbox);
                coapServer.add(new Resource[]{clientObject});
            }

            public void objectRemoved(LwM2mObjectEnabler object) {
                Resource resource = coapServer.getRoot().getChild(Integer.toString(object.getId()));
                if (resource instanceof ObjectListener) {
                    object.removeListener((ObjectListener)resource);
                }
                coapServer.remove(resource);
            }
        });
        return resources;
    }

    public CoapResource createObjectResource(LwM2mObjectEnabler objectEnabler, IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor identityExtractor, DownlinkRequestReceiver requestReceiver, NotificationManager notificationManager, ClientEndpointToolbox toolbox) {
        ObjectResource objectResource = new ObjectResource(objectEnabler.getId(), identityHandlerProvider, identityExtractor, requestReceiver, notificationManager, toolbox);
        objectEnabler.addListener((ObjectListener)objectResource);
        return objectResource;
    }
}

