/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.object;

import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObserveRelationFilter;
import org.eclipse.leshan.core.node.LwM2mPath;

public class InstanceRemovedFilter
implements ObserveRelationFilter {
    protected final LwM2mPath[] objectInstancePaths;

    public InstanceRemovedFilter(int objectId, int[] instanceIds) {
        this.objectInstancePaths = new LwM2mPath[instanceIds.length];
        for (int i = 0; i < instanceIds.length; ++i) {
            this.objectInstancePaths[i] = new LwM2mPath(objectId, instanceIds[i]);
        }
    }

    public boolean accept(ObserveRelation relation) {
        String relationURI = "/" + relation.getExchange().getRequest().getOptions().getUriPathString();
        LwM2mPath relationPath = new LwM2mPath(relationURI);
        for (LwM2mPath objectInstancePath : this.objectInstancePaths) {
            if (!relationPath.startWith(objectInstancePath)) continue;
            return true;
        }
        return false;
    }
}

