/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.object;

import java.util.Collection;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceObserver;
import org.eclipse.californium.core.server.resources.ResourceObserverAdapter;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.californium.object.InstanceRemovedFilter;
import org.eclipse.leshan.client.californium.object.ResourceObserveFilter;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.notification.NotificationManager;
import org.eclipse.leshan.client.request.DownlinkRequestReceiver;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.NotificationSender;
import org.eclipse.leshan.client.resource.listener.ObjectListener;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.attributes.InvalidAttributeException;
import org.eclipse.leshan.core.link.lwm2m.attributes.InvalidAttributesException;
import org.eclipse.leshan.core.link.lwm2m.attributes.LwM2mAttributeSet;
import org.eclipse.leshan.core.node.InvalidLwM2mPathException;
import org.eclipse.leshan.core.node.LwM2mChildNode;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.InvalidRequestException;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectResource
extends LwM2mClientCoapResource
implements ObjectListener {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectResource.class);
    protected DownlinkRequestReceiver requestReceiver;
    protected ClientEndpointToolbox toolbox;
    protected NotificationManager notificationManager;

    public ObjectResource(int objectId, IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor serverIdentityExtractor, DownlinkRequestReceiver requestReceiver, final NotificationManager notificationManager, ClientEndpointToolbox toolbox) {
        super(Integer.toString(objectId), identityHandlerProvider, serverIdentityExtractor);
        this.requestReceiver = requestReceiver;
        this.notificationManager = notificationManager;
        this.toolbox = toolbox;
        this.setObservable(true);
        this.addObserver((ResourceObserver)new ResourceObserverAdapter(){

            public void removedObserveRelation(ObserveRelation relation) {
                Request request = relation.getExchange().getRequest();
                String URI2 = request.getOptions().getUriPathString();
                if (URI2 == null) {
                    return;
                }
                LwM2mServer extractIdentity = ObjectResource.this.extractIdentity(relation.getExchange(), (Message)request);
                ContentFormat requestedContentFormat = null;
                if (request.getOptions().hasAccept()) {
                    requestedContentFormat = ContentFormat.fromCode((int)request.getOptions().getAccept());
                }
                ObserveRequest observeRequest = new ObserveRequest(requestedContentFormat, URI2, (Object)request);
                notificationManager.clear(extractIdentity, observeRequest);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleGET(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        if (exchange.getRequestOptions().getAccept() == 40) {
            if (server.isLwm2mBootstrapServer()) {
                BootstrapDiscoverResponse response = (BootstrapDiscoverResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new BootstrapDiscoverRequest(URI2, (Object)coapRequest)).getResponse();
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                    return;
                }
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.toolbox.getLinkSerializer().serializeCoreLinkFormat((Link[])response.getObjectLinks()), 40);
                return;
            }
            DiscoverResponse response = (DiscoverResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new DiscoverRequest(URI2, (Object)coapRequest)).getResponse();
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.toolbox.getLinkSerializer().serializeCoreLinkFormat((Link[])response.getObjectLinks()), 40);
            return;
        }
        ContentFormat requestedContentFormat = null;
        if (exchange.getRequestOptions().hasAccept()) {
            requestedContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getAccept());
            if (!this.toolbox.getEncoder().isSupported(requestedContentFormat)) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
        }
        if (exchange.getRequestOptions().hasObserve()) {
            ObserveRequest observeRequest = new ObserveRequest(requestedContentFormat, URI2, (Object)coapRequest);
            boolean isObserveRelationEstablishement = coapRequest.isObserve() && (exchange.advanced().getRelation() == null || !exchange.advanced().getRelation().isEstablished());
            boolean isActiveObserveCancellation = coapRequest.isObserveCancel();
            if (!isObserveRelationEstablishement && !isActiveObserveCancellation) {
                this.notificationManager.notificationTriggered(server, observeRequest, this.createNotificationSender(exchange, server, observeRequest, requestedContentFormat));
                return;
            }
            ObserveResponse response = (ObserveResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)observeRequest).getResponse();
            if (response.getCode() != ResponseCode.CONTENT) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                return;
            }
            LwM2mPath path = this.getPath(URI2);
            LwM2mChildNode content = response.getContent();
            ContentFormat format = this.getContentFormat((DownlinkRequest<?>)observeRequest, requestedContentFormat);
            if (isObserveRelationEstablishement) {
                try {
                    this.notificationManager.initRelation(server, observeRequest, (LwM2mNode)content, this.createNotificationSender(exchange, server, observeRequest, requestedContentFormat));
                }
                catch (InvalidAttributesException e) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)ResponseCode.INTERNAL_SERVER_ERROR), "Invalid Attributes state : " + e.getMessage());
                }
            }
            exchange.respond(CoAP.ResponseCode.CONTENT, this.toolbox.getEncoder().encode((LwM2mNode)content, format, path, this.toolbox.getModel()), format.getCode());
            return;
        }
        if (server.isLwm2mBootstrapServer()) {
            BootstrapReadRequest readRequest = new BootstrapReadRequest(requestedContentFormat, URI2, (Object)coapRequest);
            BootstrapReadResponse response = (BootstrapReadResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)readRequest).getResponse();
            if (response.getCode() == ResponseCode.CONTENT) {
                LwM2mPath path = this.getPath(URI2);
                LwM2mChildNode content = response.getContent();
                ContentFormat format = this.getContentFormat((DownlinkRequest<?>)readRequest, requestedContentFormat);
                exchange.respond(CoAP.ResponseCode.CONTENT, this.toolbox.getEncoder().encode((LwM2mNode)content, format, path, this.toolbox.getModel()), format.getCode());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            return;
        }
        ReadRequest readRequest = new ReadRequest(requestedContentFormat, URI2, (Object)coapRequest);
        ReadResponse response = (ReadResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)readRequest).getResponse();
        if (response.getCode() == ResponseCode.CONTENT) {
            LwM2mPath path = this.getPath(URI2);
            LwM2mChildNode content = response.getContent();
            ContentFormat format = this.getContentFormat((DownlinkRequest<?>)readRequest, requestedContentFormat);
            exchange.respond(CoAP.ResponseCode.CONTENT, this.toolbox.getEncoder().encode((LwM2mNode)content, format, path, this.toolbox.getModel()), format.getCode());
            return;
        }
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }

    protected NotificationSender createNotificationSender(final CoapExchange exchange, final LwM2mServer server, final ObserveRequest observeRequest, final ContentFormat requestedContentFormat) {
        return new NotificationSender(){

            public boolean sendNotification(ObserveResponse response) {
                try {
                    if (exchange.advanced().getRelation() != null && !exchange.advanced().getRelation().isCanceled()) {
                        if (response.getCode() == ResponseCode.CONTENT) {
                            LwM2mPath path = observeRequest.getPath();
                            LwM2mChildNode content = response.getContent();
                            ContentFormat format = ObjectResource.this.getContentFormat((DownlinkRequest<?>)observeRequest, requestedContentFormat);
                            Response coapResponse = new Response(CoAP.ResponseCode.CONTENT);
                            coapResponse.setPayload(ObjectResource.this.toolbox.getEncoder().encode((LwM2mNode)content, format, path, ObjectResource.this.toolbox.getModel()));
                            coapResponse.getOptions().setContentFormat(format.getCode());
                            exchange.respond(coapResponse);
                            return true;
                        }
                        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                        return false;
                    }
                    return false;
                }
                catch (Exception e) {
                    LOG.error("Exception while sending notification [{}] for [{}] to {}", new Object[]{response, observeRequest, server, e});
                    exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "failure sending notification");
                    return false;
                }
            }
        };
    }

    protected ContentFormat getContentFormat(DownlinkRequest<?> request, ContentFormat requestedContentFormat) {
        if (requestedContentFormat != null) {
            return requestedContentFormat;
        }
        return ContentFormat.DEFAULT;
    }

    public void handlePUT(CoapExchange coapExchange) {
        Request coapRequest = coapExchange.advanced().getRequest();
        LwM2mServer identity = this.getServerOrRejectRequest(coapExchange, (Message)coapRequest);
        if (identity == null) {
            return;
        }
        String URI2 = coapExchange.getRequestOptions().getUriPathString();
        LwM2mAttributeSet attributes = null;
        if (coapRequest.getOptions().getURIQueryCount() != 0) {
            List uriQueries = coapRequest.getOptions().getUriQuery();
            try {
                attributes = new LwM2mAttributeSet(this.toolbox.getAttributeParser().parseQueryParams((Collection)uriQueries));
            }
            catch (InvalidAttributeException e) {
                this.handleInvalidRequest(coapExchange.advanced(), "Unable to parse Attributes", e);
            }
        }
        if (attributes != null) {
            WriteAttributesResponse response = (WriteAttributesResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new WriteAttributesRequest(URI2, attributes, (Object)coapRequest)).getResponse();
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
            return;
        }
        LwM2mPath path = this.getPath(URI2);
        if (!coapExchange.getRequestOptions().hasContentFormat()) {
            this.handleInvalidRequest(coapExchange, "Content Format is mandatory");
            return;
        }
        ContentFormat contentFormat = ContentFormat.fromCode((int)coapExchange.getRequestOptions().getContentFormat());
        if (!this.toolbox.getDecoder().isSupported(contentFormat)) {
            coapExchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        try {
            LwM2mNode lwM2mNode = this.toolbox.getDecoder().decode(coapExchange.getRequestPayload(), contentFormat, path, this.toolbox.getModel());
            if (identity.isLwm2mBootstrapServer()) {
                BootstrapWriteResponse response = (BootstrapWriteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new BootstrapWriteRequest(path, lwM2mNode, contentFormat, (Object)coapRequest)).getResponse();
                if (response.getCode().isError()) {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            } else {
                WriteResponse response = (WriteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new WriteRequest(WriteRequest.Mode.REPLACE, contentFormat, URI2, lwM2mNode, (Object)coapRequest)).getResponse();
                if (response.getCode().isError()) {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            return;
        }
        catch (CodecException e) {
            this.handleInvalidRequest(coapExchange.advanced(), "Unable to decode payload on WRITE", e);
            return;
        }
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer identity = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (identity == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        LwM2mPath path = this.getPath(URI2);
        if (path.isResource() && (!exchange.getRequestOptions().hasContentFormat() || ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat()) == ContentFormat.TEXT)) {
            byte[] payload = exchange.getRequestPayload();
            ExecuteResponse response = (ExecuteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new ExecuteRequest(URI2, payload != null ? new String(payload) : null, (Object)coapRequest)).getResponse();
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
            return;
        }
        if (!exchange.getRequestOptions().hasContentFormat()) {
            this.handleInvalidRequest(exchange, "Content Format is mandatory");
            return;
        }
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.toolbox.getDecoder().isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        if (path.isResource()) {
            try {
                LwM2mNode lwM2mNode = this.toolbox.getDecoder().decode(exchange.getRequestPayload(), contentFormat, path, this.toolbox.getModel());
                WriteResponse response = (WriteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, URI2, lwM2mNode, (Object)coapRequest)).getResponse();
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            catch (CodecException e) {
                this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on WRITE", e);
            }
            return;
        }
        if (path.isObjectInstance()) {
            try {
                LwM2mNode lwM2mNode = this.toolbox.getDecoder().decode(exchange.getRequestPayload(), contentFormat, path, this.toolbox.getModel());
                WriteResponse response = (WriteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, URI2, lwM2mNode, (Object)coapRequest)).getResponse();
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            catch (CodecException e) {
                this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on WRITE", e);
            }
            return;
        }
        try {
            LwM2mObject object = (LwM2mObject)this.toolbox.getDecoder().decode(exchange.getRequestPayload(), contentFormat, new LwM2mPath(path.getObjectId().intValue()), this.toolbox.getModel(), LwM2mObject.class);
            LwM2mObjectInstance newInstance = object.getInstance(-1);
            CreateRequest createRequest = object.getInstances().isEmpty() ? new CreateRequest(contentFormat, (Object)coapRequest, URI2, new LwM2mResource[0]) : (object.getInstances().size() == 1 && newInstance != null ? new CreateRequest(contentFormat, (Object)coapRequest, URI2, newInstance.getResources().values()) : new CreateRequest(contentFormat, (Object)coapRequest, URI2, object.getInstances().values().toArray(new LwM2mObjectInstance[object.getInstances().values().size()])));
            CreateResponse response = (CreateResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)createRequest).getResponse();
            if (response.getCode() == ResponseCode.CREATED) {
                if (response.getLocation() != null) {
                    exchange.setLocationPath(response.getLocation());
                }
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            return;
        }
        catch (CodecException e) {
            this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on CREATE", e);
            return;
        }
    }

    public void handleDELETE(CoapExchange coapExchange) {
        String URI2 = coapExchange.getRequestOptions().getUriPathString();
        Request coapRequest = coapExchange.advanced().getRequest();
        LwM2mServer identity = this.getServerOrRejectRequest(coapExchange, (Message)coapRequest);
        if (identity == null) {
            return;
        }
        if (identity.isLwm2mBootstrapServer()) {
            BootstrapDeleteResponse response = (BootstrapDeleteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new BootstrapDeleteRequest(URI2, (Object)coapRequest)).getResponse();
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
        } else {
            DeleteResponse response = (DeleteResponse)this.requestReceiver.requestReceived(identity, (DownlinkRequest)new DeleteRequest(URI2, (Object)coapRequest)).getResponse();
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
        }
    }

    public Resource getChild(String name) {
        return this;
    }

    public void resourceChanged(LwM2mPath ... paths) {
        this.changed(new ResourceObserveFilter(paths));
    }

    public void objectInstancesAdded(LwM2mObjectEnabler object, int ... instanceIds) {
    }

    public void objectInstancesRemoved(LwM2mObjectEnabler object, int ... instanceIds) {
        this.changed(new InstanceRemovedFilter(object.getId(), instanceIds));
    }

    protected LwM2mPath getPath(String URI2) throws InvalidRequestException {
        try {
            return new LwM2mPath(URI2);
        }
        catch (InvalidLwM2mPathException e) {
            throw new InvalidRequestException((Throwable)e, "Invalid path : %s", new Object[]{e.getMessage()});
        }
    }
}

