/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.request;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.LwM2mRequest;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.request.UplinkRequestVisitor;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.BootstrapResponse;
import org.eclipse.leshan.core.response.DeregisterResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.RegisterResponse;
import org.eclipse.leshan.core.response.SendResponse;
import org.eclipse.leshan.core.response.UpdateResponse;

public class LwM2mResponseBuilder<T extends LwM2mResponse>
implements UplinkRequestVisitor {
    protected final Response coapResponse;
    protected LwM2mResponse lwM2mresponse;

    public LwM2mResponseBuilder(Response coapResponse) {
        this.coapResponse = coapResponse;
    }

    public void visit(RegisterRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new RegisterResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString());
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CREATED) {
            this.lwM2mresponse = RegisterResponse.success((String)this.coapResponse.getOptions().getLocationString());
        } else {
            this.handleUnexpectedResponseCode((LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DeregisterRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new DeregisterResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString());
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = DeregisterResponse.success();
        } else {
            this.handleUnexpectedResponseCode((LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(UpdateRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new UpdateResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString());
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = UpdateResponse.success();
        } else {
            this.handleUnexpectedResponseCode((LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(SendRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new SendResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString());
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = SendResponse.success();
        } else {
            this.handleUnexpectedResponseCode((LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString());
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = BootstrapResponse.success();
        } else {
            this.handleUnexpectedResponseCode((LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public T getResponse() {
        return (T)this.lwM2mresponse;
    }

    protected void handleUnexpectedResponseCode(LwM2mRequest<?> request, Response coapResponse) {
        throw new InvalidResponseException("Server returned unexpected response code [%s] for [%s]", new Object[]{coapResponse.getCode(), request});
    }
}

