/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.request;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.californium.EndpointContextUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.request.UplinkRequestVisitor;

public class CoapRequestBuilder
implements UplinkRequestVisitor {
    protected Request coapRequest;
    protected final Identity server;
    protected final LwM2mEncoder encoder;
    protected final LwM2mModel model;

    public CoapRequestBuilder(Identity server, LwM2mEncoder encoder, LwM2mModel model) {
        this.server = server;
        this.encoder = encoder;
        this.model = model;
    }

    public void visit(BootstrapRequest request) {
        this.coapRequest = Request.newPost();
        this.buildRequestSettings();
        this.coapRequest.getOptions().addUriPath("bs");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.putAll(request.getAdditionalAttributes());
        attributes.put("ep", request.getEndpointName());
        if (request.getPreferredContentFormat() != null) {
            attributes.put("pct", Integer.toString(request.getPreferredContentFormat().getCode()));
        }
        for (Map.Entry attr : attributes.entrySet()) {
            this.coapRequest.getOptions().addUriQuery((String)attr.getKey() + "=" + (String)attr.getValue());
        }
    }

    public void visit(RegisterRequest request) {
        Boolean queueMode;
        EnumSet bindingMode;
        String lwVersion;
        String smsNumber;
        this.coapRequest = Request.newPost();
        this.buildRequestSettings();
        this.coapRequest.getOptions().setContentFormat(ContentFormat.LINK.getCode());
        this.coapRequest.getOptions().addUriPath("rd");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.putAll(request.getAdditionalAttributes());
        attributes.put("ep", request.getEndpointName());
        Long lifetime = request.getLifetime();
        if (lifetime != null) {
            attributes.put("lt", lifetime.toString());
        }
        if ((smsNumber = request.getSmsNumber()) != null) {
            attributes.put("sms", smsNumber);
        }
        if ((lwVersion = request.getLwVersion()) != null) {
            attributes.put("lwm2m", lwVersion);
        }
        if ((bindingMode = request.getBindingMode()) != null) {
            attributes.put("b", BindingMode.toString((EnumSet)bindingMode));
        }
        if ((queueMode = request.getQueueMode()) != null && queueMode.booleanValue()) {
            attributes.put("Q", null);
        }
        for (Map.Entry attr : attributes.entrySet()) {
            if (attr.getValue() != null) {
                this.coapRequest.getOptions().addUriQuery((String)attr.getKey() + "=" + (String)attr.getValue());
                continue;
            }
            this.coapRequest.getOptions().addUriQuery((String)attr.getKey());
        }
        Link[] objectLinks = request.getObjectLinks();
        if (objectLinks != null) {
            this.coapRequest.setPayload(Link.serialize((Link[])objectLinks));
        }
    }

    public void visit(UpdateRequest request) {
        Link[] linkObjects;
        EnumSet bindingMode;
        String smsNumber;
        this.coapRequest = Request.newPost();
        this.buildRequestSettings();
        this.coapRequest.getOptions().setUriPath(request.getRegistrationId());
        Long lifetime = request.getLifeTimeInSec();
        if (lifetime != null) {
            this.coapRequest.getOptions().addUriQuery("lt=" + lifetime);
        }
        if ((smsNumber = request.getSmsNumber()) != null) {
            this.coapRequest.getOptions().addUriQuery("sms=" + smsNumber);
        }
        if ((bindingMode = request.getBindingMode()) != null) {
            this.coapRequest.getOptions().addUriQuery("b=" + BindingMode.toString((EnumSet)bindingMode));
        }
        if ((linkObjects = request.getObjectLinks()) != null) {
            this.coapRequest.getOptions().setContentFormat(ContentFormat.LINK.getCode());
            this.coapRequest.setPayload(Link.serialize((Link[])linkObjects));
        }
    }

    public void visit(DeregisterRequest request) {
        this.coapRequest = Request.newDelete();
        this.buildRequestSettings();
        this.coapRequest.getOptions().setUriPath(request.getRegistrationId());
    }

    public void visit(SendRequest request) {
        this.coapRequest = Request.newPost();
        this.buildRequestSettings();
        this.coapRequest.getOptions().setUriPath("/dp");
        ContentFormat format = request.getFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encodeNodes(request.getNodes(), format, this.model));
    }

    public Request getRequest() {
        return this.coapRequest;
    }

    protected void buildRequestSettings() {
        EndpointContext context = EndpointContextUtil.extractContext((Identity)this.server, (boolean)true);
        this.coapRequest.setDestinationContext(context);
    }
}

