/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.client.EndpointsManager;
import org.eclipse.leshan.client.LwM2mClient;
import org.eclipse.leshan.client.RegistrationUpdateHandler;
import org.eclipse.leshan.client.bootstrap.BootstrapConsistencyChecker;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.RootResource;
import org.eclipse.leshan.client.californium.bootstrap.BootstrapResource;
import org.eclipse.leshan.client.californium.bootstrap.DefaultBootstrapConsistencyChecker;
import org.eclipse.leshan.client.californium.object.ObjectResource;
import org.eclipse.leshan.client.californium.request.CaliforniumLwM2mRequestSender;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory;
import org.eclipse.leshan.client.observer.LwM2mClientObserver;
import org.eclipse.leshan.client.observer.LwM2mClientObserverAdapter;
import org.eclipse.leshan.client.observer.LwM2mClientObserverDispatcher;
import org.eclipse.leshan.client.request.LwM2mRequestSender;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.LwM2mObjectTree;
import org.eclipse.leshan.client.resource.LwM2mRootEnabler;
import org.eclipse.leshan.client.resource.RootEnabler;
import org.eclipse.leshan.client.resource.listener.ObjectListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListenerAdapter;
import org.eclipse.leshan.client.send.NoDataException;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.link.LinkSerializer;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.response.SendResponse;
import org.eclipse.leshan.core.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanClient
implements LwM2mClient {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanClient.class);
    private final CoapAPI coapApi;
    private final CoapServer coapServer;
    private final CaliforniumLwM2mRequestSender requestSender;
    private final CaliforniumEndpointsManager endpointsManager;
    private LwM2mObjectTree objectTree;
    private final BootstrapHandler bootstrapHandler;
    private final LwM2mRootEnabler rootEnabler;
    private final LwM2mEncoder encoder;
    private final LwM2mDecoder decoder;
    private final RegistrationEngine engine;
    private final LwM2mClientObserverDispatcher observers;
    private final LinkSerializer linkSerializer;

    public LeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, Map<String, String> additionalAttributes, LwM2mEncoder encoder, LwM2mDecoder decoder, ScheduledExecutorService sharedExecutor, LinkSerializer linkSerializer) {
        this(endpoint, localAddress, objectEnablers, coapConfig, dtlsConfigBuilder, endpointFactory, engineFactory, additionalAttributes, null, encoder, decoder, sharedExecutor, linkSerializer);
    }

    public LeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, Map<String, String> additionalAttributes, Map<String, String> bsAdditionalAttributes, LwM2mEncoder encoder, LwM2mDecoder decoder, ScheduledExecutorService sharedExecutor, LinkSerializer linkSerializer) {
        this(endpoint, localAddress, objectEnablers, coapConfig, dtlsConfigBuilder, null, endpointFactory, engineFactory, (BootstrapConsistencyChecker)new DefaultBootstrapConsistencyChecker(), additionalAttributes, bsAdditionalAttributes, encoder, decoder, sharedExecutor, linkSerializer);
    }

    public LeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, List<Certificate> trustStore, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, BootstrapConsistencyChecker checker, Map<String, String> additionalAttributes, Map<String, String> bsAdditionalAttributes, LwM2mEncoder encoder, LwM2mDecoder decoder, ScheduledExecutorService sharedExecutor, LinkSerializer linkSerializer) {
        Validate.notNull((Object)endpoint);
        Validate.notEmpty(objectEnablers);
        Validate.notNull((Object)coapConfig);
        this.objectTree = this.createObjectTree(objectEnablers);
        this.rootEnabler = this.createRootEnabler(this.objectTree);
        this.decoder = decoder;
        this.encoder = encoder;
        this.linkSerializer = linkSerializer;
        this.observers = this.createClientObserverDispatcher();
        this.bootstrapHandler = this.createBoostrapHandler(this.objectTree, checker);
        this.endpointsManager = this.createEndpointsManager(localAddress, coapConfig, dtlsConfigBuilder, trustStore, endpointFactory);
        this.requestSender = this.createRequestSender(this.endpointsManager, sharedExecutor, encoder, this.objectTree.getModel());
        this.engine = engineFactory.createRegistratioEngine(endpoint, this.objectTree, (EndpointsManager)this.endpointsManager, (LwM2mRequestSender)this.requestSender, this.bootstrapHandler, (LwM2mClientObserver)this.observers, additionalAttributes, bsAdditionalAttributes, this.getSupportedContentFormat(decoder, encoder), sharedExecutor);
        this.coapServer = this.createCoapServer(coapConfig, sharedExecutor);
        this.coapServer.add(new Resource[]{this.createBootstrapResource(this.engine, this.endpointsManager, this.bootstrapHandler)});
        this.endpointsManager.setCoapServer(this.coapServer);
        this.linkObjectTreeToCoapServer(this.coapServer, this.engine, this.endpointsManager, this.objectTree, encoder, decoder);
        this.createRegistrationUpdateHandler(this.engine, this.endpointsManager, this.bootstrapHandler, this.objectTree);
        this.coapApi = new CoapAPI();
    }

    protected LwM2mRootEnabler createRootEnabler(LwM2mObjectTree tree) {
        return new RootEnabler(tree);
    }

    protected LwM2mObjectTree createObjectTree(List<? extends LwM2mObjectEnabler> objectEnablers) {
        return new LwM2mObjectTree((LwM2mClient)this, objectEnablers);
    }

    protected LwM2mClientObserverDispatcher createClientObserverDispatcher() {
        LwM2mClientObserverDispatcher observer = new LwM2mClientObserverDispatcher();
        observer.addObserver((LwM2mClientObserver)new LwM2mClientObserverAdapter(){

            public void onUnexpectedError(Throwable unexpectedError) {
                LeshanClient.this.destroy(false);
            }
        });
        return observer;
    }

    protected BootstrapHandler createBoostrapHandler(LwM2mObjectTree objectTree, BootstrapConsistencyChecker checker) {
        return new BootstrapHandler(objectTree.getObjectEnablers(), checker);
    }

    protected CoapServer createCoapServer(Configuration coapConfig, ScheduledExecutorService sharedExecutor) {
        CoapServer coapServer = new CoapServer(coapConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource(LeshanClient.this.engine, LeshanClient.this.endpointsManager, LeshanClient.this.bootstrapHandler, this, LeshanClient.this.rootEnabler, LeshanClient.this.encoder, LeshanClient.this.decoder, LeshanClient.this.linkSerializer);
            }
        };
        if (sharedExecutor != null) {
            coapServer.setExecutors(sharedExecutor, sharedExecutor, true);
        } else {
            ScheduledExecutorService executor = ExecutorsUtil.newScheduledThreadPool((int)((Integer)coapConfig.get((BasicDefinition)CoapConfig.PROTOCOL_STAGE_THREAD_COUNT)), (ThreadFactory)new NamedThreadFactory("CoapServer(main)#"));
            coapServer.setExecutors(executor, executor, false);
        }
        return coapServer;
    }

    protected void linkObjectTreeToCoapServer(final CoapServer coapServer, final RegistrationEngine registrationEngine, final CaliforniumEndpointsManager endpointsManager, LwM2mObjectTree objectTree, final LwM2mEncoder encoder, final LwM2mDecoder decoder) {
        for (LwM2mObjectEnabler enabler : objectTree.getObjectEnablers().values()) {
            CoapResource clientObject = this.createObjectResource(enabler, registrationEngine, endpointsManager, encoder, decoder);
            coapServer.add(new Resource[]{clientObject});
        }
        objectTree.addListener((ObjectsListener)new ObjectsListenerAdapter(){

            public void objectAdded(LwM2mObjectEnabler object) {
                CoapResource clientObject = LeshanClient.this.createObjectResource(object, registrationEngine, endpointsManager, encoder, decoder);
                coapServer.add(new Resource[]{clientObject});
            }

            public void objectRemoved(LwM2mObjectEnabler object) {
                Resource resource = coapServer.getRoot().getChild(Integer.toString(object.getId()));
                if (resource instanceof ObjectListener) {
                    object.removeListener((ObjectListener)resource);
                }
                coapServer.remove(resource);
            }
        });
    }

    protected CoapResource createObjectResource(LwM2mObjectEnabler enabler, RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, LwM2mEncoder encoder, LwM2mDecoder decoder) {
        return new ObjectResource(enabler, registrationEngine, endpointsManager, encoder, decoder, this.linkSerializer);
    }

    protected CoapResource createBootstrapResource(RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler) {
        return new BootstrapResource(registrationEngine, endpointsManager, bootstrapHandler);
    }

    protected CaliforniumEndpointsManager createEndpointsManager(InetSocketAddress localAddress, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, List<Certificate> trustStore, EndpointFactory endpointFactory) {
        return new CaliforniumEndpointsManager(localAddress, coapConfig, dtlsConfigBuilder, trustStore, endpointFactory);
    }

    protected CaliforniumLwM2mRequestSender createRequestSender(CaliforniumEndpointsManager endpointsManager, ScheduledExecutorService executor, LwM2mEncoder encoder, LwM2mModel model) {
        return new CaliforniumLwM2mRequestSender(endpointsManager, executor, encoder, model, this.linkSerializer);
    }

    protected RegistrationUpdateHandler createRegistrationUpdateHandler(RegistrationEngine engine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler, LwM2mObjectTree objectTree) {
        RegistrationUpdateHandler registrationUpdateHandler = new RegistrationUpdateHandler(engine, bootstrapHandler);
        registrationUpdateHandler.listen(objectTree);
        return registrationUpdateHandler;
    }

    protected Set<ContentFormat> getSupportedContentFormat(LwM2mDecoder decoder, LwM2mEncoder encoder) {
        TreeSet<ContentFormat> supportedContentFormat = new TreeSet<ContentFormat>();
        supportedContentFormat.addAll(decoder.getSupportedContentFormat());
        supportedContentFormat.addAll(encoder.getSupportedContentFormat());
        return supportedContentFormat;
    }

    public void start() {
        LOG.info("Starting Leshan client ...");
        this.endpointsManager.start();
        this.engine.start();
        this.objectTree.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("Leshan client[endpoint:{}] started.", (Object)this.engine.getEndpoint());
        }
    }

    public void stop(boolean deregister) {
        LOG.info("Stopping Leshan Client ...");
        this.engine.stop(deregister);
        this.endpointsManager.stop();
        this.objectTree.stop();
        LOG.info("Leshan client stopped.");
    }

    public void destroy(boolean deregister) {
        LOG.info("Destroying Leshan client ...");
        this.engine.destroy(deregister);
        this.endpointsManager.destroy();
        this.requestSender.destroy();
        this.objectTree.destroy();
        LOG.info("Leshan client destroyed.");
    }

    public LwM2mObjectTree getObjectTree() {
        return this.objectTree;
    }

    public void triggerRegistrationUpdate() {
        this.engine.triggerRegistrationUpdate();
    }

    public void triggerRegistrationUpdate(ServerIdentity server) {
        this.engine.triggerRegistrationUpdate(server);
    }

    public boolean triggerClientInitiatedBootstrap(boolean deregister) {
        return this.engine.triggerClientInitiatedBootstrap(deregister);
    }

    public SendResponse sendData(ServerIdentity server, ContentFormat format, List<String> paths, long timeoutInMs) throws InterruptedException {
        Validate.notNull((Object)server);
        Validate.notEmpty(paths);
        Map<LwM2mPath, LwM2mNode> collectedData = this.collectData(server, paths);
        return (SendResponse)this.requestSender.send(server, new SendRequest(format, collectedData, null), timeoutInMs);
    }

    public void sendData(ServerIdentity server, ContentFormat format, List<String> paths, long timeoutInMs, ResponseCallback<SendResponse> onResponse, ErrorCallback onError) {
        Validate.notNull((Object)server);
        Validate.notEmpty(paths);
        Validate.notNull(onResponse);
        Validate.notNull((Object)onError);
        Map<LwM2mPath, LwM2mNode> collectedData = this.collectData(server, paths);
        this.requestSender.send(server, new SendRequest(format, collectedData, null), timeoutInMs, onResponse, onError);
    }

    private Map<LwM2mPath, LwM2mNode> collectData(ServerIdentity server, List<String> paths) {
        ContentFormat format = ContentFormat.SENML_CBOR;
        ReadCompositeResponse response = this.rootEnabler.read(server, new ReadCompositeRequest(format, format, paths));
        if (response.isSuccess()) {
            return response.getContent();
        }
        throw new NoDataException("Unable to collect data for %s : %s / %s", new Object[]{paths, response.getCode(), response.getErrorMessage()});
    }

    public CoapAPI coap() {
        return this.coapApi;
    }

    public void addObserver(LwM2mClientObserver observer) {
        this.observers.addObserver(observer);
    }

    public void removeObserver(LwM2mClientObserver observer) {
        this.observers.removeObserver(observer);
    }

    public String getRegistrationId(ServerIdentity server) {
        return this.engine.getRegistrationId(server);
    }

    public Map<String, ServerIdentity> getRegisteredServers() {
        return this.engine.getRegisteredServers();
    }

    public InetSocketAddress getAddress(ServerIdentity server) {
        return this.endpointsManager.getEndpoint(server).getAddress();
    }

    public class CoapAPI {
        public CoapServer getServer() {
            return LeshanClient.this.coapServer;
        }

        public CoapEndpoint getEndpoint(ServerIdentity server) {
            return (CoapEndpoint)LeshanClient.this.endpointsManager.getEndpoint(server);
        }
    }
}

