/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.californium.elements.util.CertPathUtil;

public class X509Util {
    public static CertPath applyPKIXValidation(CertPath certPath, X509Certificate[] trustedCertificates) throws GeneralSecurityException {
        CertPath adaptedCertPath = X509Util.truncateToFirstTrustedCert(certPath, trustedCertificates);
        if (adaptedCertPath.getCertificates().isEmpty()) {
            throw new IllegalArgumentException("Invalid certificate path : certificate path is empty or end node certificate is directly trusted");
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustedCertificates) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        String algorithm = CertPathValidator.getDefaultType();
        CertPathValidator validator = CertPathValidator.getInstance(algorithm);
        PKIXParameters params = new PKIXParameters(trustAnchors);
        params.setRevocationEnabled(false);
        CertPathValidatorResult result = validator.validate(adaptedCertPath, params);
        X509Certificate trustedCertificate = ((PKIXCertPathValidatorResult)result).getTrustAnchor().getTrustedCert();
        return X509Util.add(adaptedCertPath, trustedCertificate);
    }

    public static CertPath truncateToFirstTrustedCert(CertPath certPath, X509Certificate[] trustedCertificates) throws CertificateEncodingException {
        List certificates = CertPathUtil.toX509CertificatesList(certPath.getCertificates());
        for (int index = 0; index < certificates.size(); ++index) {
            X509Certificate certificate = (X509Certificate)certificates.get(index);
            if (!X509Util.contains(certificate, trustedCertificates)) continue;
            return CertPathUtil.generateCertPath((List)certificates, (int)index);
        }
        return certPath;
    }

    public static CertPath add(CertPath certPath, X509Certificate certificate) {
        List certificates = CertPathUtil.toX509CertificatesList(certPath.getCertificates());
        certificates.add(certificate);
        return CertPathUtil.generateCertPath((List)certificates);
    }

    public static boolean contains(X509Certificate certificate, X509Certificate[] certificates) {
        for (X509Certificate trust : certificates) {
            if (!certificate.equals(trust)) continue;
            return true;
        }
        return false;
    }

    public static X509Certificate[] asX509Certificates(Certificate[] certificates) throws CertificateException {
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        for (Certificate cert : certificates) {
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateException(String.format("%s certificate format is not supported, Only X.509 certificate is supported", cert.getType()));
            }
            x509Certificates.add((X509Certificate)cert);
        }
        return x509Certificates.toArray(new X509Certificate[0]);
    }
}

