/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.leshan.core.californium.CoapResponseCallback;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.Destroyable;
import org.eclipse.leshan.server.Startable;
import org.eclipse.leshan.server.Stoppable;
import org.eclipse.leshan.server.californium.ConnectionCleaner;
import org.eclipse.leshan.server.californium.RootResource;
import org.eclipse.leshan.server.californium.observation.ObservationServiceImpl;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.californium.registration.RegisterResource;
import org.eclipse.leshan.server.californium.request.CaliforniumLwM2mRequestSender;
import org.eclipse.leshan.server.californium.request.CaliforniumQueueModeRequestSender;
import org.eclipse.leshan.server.californium.request.CoapRequestSender;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.observation.ObservationService;
import org.eclipse.leshan.server.queue.ClientAwakeTimeProvider;
import org.eclipse.leshan.server.queue.PresenceService;
import org.eclipse.leshan.server.queue.PresenceServiceImpl;
import org.eclipse.leshan.server.queue.PresenceStateListener;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationHandler;
import org.eclipse.leshan.server.registration.RegistrationIdProvider;
import org.eclipse.leshan.server.registration.RegistrationListener;
import org.eclipse.leshan.server.registration.RegistrationService;
import org.eclipse.leshan.server.registration.RegistrationServiceImpl;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.request.LwM2mRequestSender;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.EditableSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStore;
import org.eclipse.leshan.server.security.SecurityStoreListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanServer {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanServer.class);
    private static final long DEFAULT_TIMEOUT = 120000L;
    private final CoapAPI coapApi;
    private final CoapServer coapServer;
    private final CoapEndpoint unsecuredEndpoint;
    private final CoapEndpoint securedEndpoint;
    private final RegistrationServiceImpl registrationService;
    private final CaliforniumRegistrationStore registrationStore;
    private final ObservationServiceImpl observationService;
    private final SecurityStore securityStore;
    private final LwM2mModelProvider modelProvider;
    private final PresenceServiceImpl presenceService;
    private final LwM2mRequestSender requestSender;

    public LeshanServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, CaliforniumRegistrationStore registrationStore, SecurityStore securityStore, Authorizer authorizer, LwM2mModelProvider modelProvider, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, NetworkConfig coapConfig, boolean noQueueMode, ClientAwakeTimeProvider awakeTimeProvider, RegistrationIdProvider registrationIdProvider) {
        Validate.notNull((Object)registrationStore, (String)"registration store cannot be null");
        Validate.notNull((Object)authorizer, (String)"authorizer cannot be null");
        Validate.notNull((Object)modelProvider, (String)"modelProvider cannot be null");
        Validate.notNull((Object)encoder, (String)"encoder cannot be null");
        Validate.notNull((Object)decoder, (String)"decoder cannot be null");
        Validate.notNull((Object)coapConfig, (String)"coapConfig cannot be null");
        Validate.notNull((Object)registrationIdProvider, (String)"registrationIdProvider cannot be null");
        this.coapServer = this.createCoapServer(coapConfig);
        this.unsecuredEndpoint = unsecuredEndpoint;
        if (unsecuredEndpoint != null) {
            this.coapServer.addEndpoint((Endpoint)unsecuredEndpoint);
        }
        this.securedEndpoint = securedEndpoint;
        if (securedEndpoint != null) {
            this.coapServer.addEndpoint((Endpoint)securedEndpoint);
        }
        this.registrationStore = registrationStore;
        this.registrationService = this.createRegistrationService(registrationStore);
        this.securityStore = securityStore;
        this.modelProvider = modelProvider;
        this.observationService = this.createObservationService(registrationStore, modelProvider, decoder, unsecuredEndpoint, securedEndpoint);
        this.presenceService = noQueueMode ? null : this.createPresenceService((RegistrationService)this.registrationService, awakeTimeProvider);
        this.coapServer.add(new Resource[]{this.createRegisterResource(this.registrationService, authorizer, registrationIdProvider)});
        this.requestSender = this.createRequestSender((Endpoint)securedEndpoint, (Endpoint)unsecuredEndpoint, this.registrationService, this.observationService, this.modelProvider, encoder, decoder, this.presenceService);
        this.createConnectionCleaner(securityStore, securedEndpoint);
        this.coapApi = new CoapAPI();
    }

    protected CoapServer createCoapServer(NetworkConfig coapConfig) {
        return new CoapServer(coapConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource(this);
            }
        };
    }

    protected RegistrationServiceImpl createRegistrationService(RegistrationStore registrationStore) {
        return new RegistrationServiceImpl(registrationStore);
    }

    protected ObservationServiceImpl createObservationService(CaliforniumRegistrationStore registrationStore, LwM2mModelProvider modelProvider, LwM2mNodeDecoder decoder, CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint) {
        ObservationServiceImpl observationService = new ObservationServiceImpl(registrationStore, modelProvider, decoder);
        if (unsecuredEndpoint != null) {
            unsecuredEndpoint.addNotificationListener((NotificationListener)observationService);
            observationService.setNonSecureEndpoint((Endpoint)unsecuredEndpoint);
        }
        if (securedEndpoint != null) {
            securedEndpoint.addNotificationListener((NotificationListener)observationService);
            observationService.setSecureEndpoint((Endpoint)securedEndpoint);
        }
        return observationService;
    }

    protected PresenceServiceImpl createPresenceService(RegistrationService registrationService, ClientAwakeTimeProvider awakeTimeProvider) {
        PresenceServiceImpl presenceService = new PresenceServiceImpl(awakeTimeProvider);
        registrationService.addListener((RegistrationListener)new PresenceStateListener(presenceService));
        return presenceService;
    }

    protected CoapResource createRegisterResource(RegistrationServiceImpl registrationService, Authorizer authorizer, RegistrationIdProvider registrationIdProvider) {
        return new RegisterResource(new RegistrationHandler(registrationService, authorizer, registrationIdProvider));
    }

    protected LwM2mRequestSender createRequestSender(Endpoint securedEndpoint, Endpoint unsecuredEndpoint, RegistrationServiceImpl registrationService, ObservationServiceImpl observationService, LwM2mModelProvider modelProvider, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, PresenceServiceImpl presenceService) {
        CoapRequestSender requestSender = presenceService == null ? new CaliforniumLwM2mRequestSender(securedEndpoint, unsecuredEndpoint, observationService, modelProvider, encoder, decoder) : new CaliforniumQueueModeRequestSender(presenceService, new CaliforniumLwM2mRequestSender(securedEndpoint, unsecuredEndpoint, observationService, modelProvider, encoder, decoder));
        registrationService.addListener(new RegistrationListener((LwM2mRequestSender)requestSender){
            final /* synthetic */ LwM2mRequestSender val$requestSender;
            {
                this.val$requestSender = lwM2mRequestSender;
            }

            public void updated(RegistrationUpdate update, Registration updatedRegistration, Registration previousReg) {
                if (!update.getAddress().equals(previousReg.getAddress()) || update.getPort().intValue() != previousReg.getPort()) {
                    this.val$requestSender.cancelOngoingRequests(previousReg);
                }
            }

            public void unregistered(Registration registration, Collection<Observation> observations, boolean expired, Registration newReg) {
                this.val$requestSender.cancelOngoingRequests(registration);
            }

            public void registered(Registration registration, Registration previousReg, Collection<Observation> previousObsersations) {
            }
        });
        return requestSender;
    }

    protected void createConnectionCleaner(SecurityStore securityStore, CoapEndpoint securedEndpoint) {
        if (securedEndpoint != null && securedEndpoint.getConnector() instanceof DTLSConnector && securityStore instanceof EditableSecurityStore) {
            final ConnectionCleaner connectionCleaner = new ConnectionCleaner((DTLSConnector)securedEndpoint.getConnector());
            ((EditableSecurityStore)securityStore).setListener(new SecurityStoreListener(){

                public void securityInfoRemoved(boolean infosAreCompromised, SecurityInfo ... infos) {
                    if (infosAreCompromised) {
                        connectionCleaner.cleanConnectionFor(infos);
                    }
                }
            });
        }
    }

    public void start() {
        if (this.registrationStore instanceof Startable) {
            ((Startable)this.registrationStore).start();
        }
        if (this.securityStore instanceof Startable) {
            ((Startable)this.securityStore).start();
        }
        if (this.requestSender instanceof Startable) {
            ((Startable)this.requestSender).start();
        }
        this.coapServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("LWM2M server started at {} {}", (Object)(this.getUnsecuredAddress() == null ? "" : "coap://" + this.getUnsecuredAddress()), (Object)(this.getSecuredAddress() == null ? "" : "coaps://" + this.getSecuredAddress()));
        }
    }

    public void stop() {
        this.coapServer.stop();
        if (this.registrationStore instanceof Stoppable) {
            ((Stoppable)this.registrationStore).stop();
        }
        if (this.securityStore instanceof Stoppable) {
            ((Stoppable)this.securityStore).stop();
        }
        if (this.requestSender instanceof Stoppable) {
            ((Stoppable)this.requestSender).stop();
        }
        LOG.info("LWM2M server stopped.");
    }

    public void destroy() {
        this.coapServer.destroy();
        if (this.registrationStore instanceof Destroyable) {
            ((Destroyable)this.registrationStore).destroy();
        } else if (this.registrationStore instanceof Stoppable) {
            ((Stoppable)this.registrationStore).stop();
        }
        if (this.securityStore instanceof Destroyable) {
            ((Destroyable)this.securityStore).destroy();
        } else if (this.securityStore instanceof Stoppable) {
            ((Stoppable)this.securityStore).stop();
        }
        if (this.requestSender instanceof Destroyable) {
            ((Destroyable)this.requestSender).destroy();
        } else if (this.requestSender instanceof Stoppable) {
            ((Stoppable)this.requestSender).stop();
        }
        this.presenceService.destroy();
        LOG.info("LWM2M server destroyed.");
    }

    public RegistrationService getRegistrationService() {
        return this.registrationService;
    }

    public ObservationService getObservationService() {
        return this.observationService;
    }

    public PresenceService getPresenceService() {
        return this.presenceService;
    }

    public SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    public LwM2mModelProvider getModelProvider() {
        return this.modelProvider;
    }

    public <T extends LwM2mResponse> T send(Registration destination, DownlinkRequest<T> request) throws InterruptedException {
        return (T)this.requestSender.send(destination, request, 120000L);
    }

    public <T extends LwM2mResponse> T send(Registration destination, DownlinkRequest<T> request, long timeoutInMs) throws InterruptedException {
        return (T)this.requestSender.send(destination, request, timeoutInMs);
    }

    public <T extends LwM2mResponse> void send(Registration destination, DownlinkRequest<T> request, ResponseCallback<T> responseCallback, ErrorCallback errorCallback) {
        this.requestSender.send(destination, request, 120000L, responseCallback, errorCallback);
    }

    public <T extends LwM2mResponse> void send(Registration destination, DownlinkRequest<T> request, long timeoutInMs, ResponseCallback<T> responseCallback, ErrorCallback errorCallback) {
        this.requestSender.send(destination, request, timeoutInMs, responseCallback, errorCallback);
    }

    public InetSocketAddress getUnsecuredAddress() {
        if (this.unsecuredEndpoint != null) {
            return this.unsecuredEndpoint.getAddress();
        }
        return null;
    }

    public InetSocketAddress getSecuredAddress() {
        if (this.securedEndpoint != null) {
            return this.securedEndpoint.getAddress();
        }
        return null;
    }

    public CoapAPI coap() {
        return this.coapApi;
    }

    public class CoapAPI {
        public CoapServer getServer() {
            return LeshanServer.this.coapServer;
        }

        public CoapEndpoint getSecuredEndpoint() {
            return LeshanServer.this.securedEndpoint;
        }

        public CoapEndpoint getUnsecuredEndpoint() {
            return LeshanServer.this.unsecuredEndpoint;
        }

        public Response send(Registration destination, Request request) throws InterruptedException {
            if (!(LeshanServer.this.requestSender instanceof CoapRequestSender)) {
                throw new UnsupportedOperationException("This sender does not support to send CoAP request");
            }
            CoapRequestSender sender = (CoapRequestSender)LeshanServer.this.requestSender;
            return sender.sendCoapRequest(destination, request, 120000L);
        }

        public Response send(Registration destination, Request request, long timeoutInMs) throws InterruptedException {
            if (!(LeshanServer.this.requestSender instanceof CoapRequestSender)) {
                throw new UnsupportedOperationException("This sender does not support to send CoAP request");
            }
            CoapRequestSender sender = (CoapRequestSender)LeshanServer.this.requestSender;
            return sender.sendCoapRequest(destination, request, timeoutInMs);
        }

        public void send(Registration destination, Request request, CoapResponseCallback responseCallback, ErrorCallback errorCallback) {
            if (!(LeshanServer.this.requestSender instanceof CoapRequestSender)) {
                throw new UnsupportedOperationException("This sender does not support to send CoAP request");
            }
            CoapRequestSender sender = (CoapRequestSender)LeshanServer.this.requestSender;
            sender.sendCoapRequest(destination, request, 120000L, responseCallback, errorCallback);
        }

        public void send(Registration destination, Request request, long timeout, CoapResponseCallback responseCallback, ErrorCallback errorCallback) {
            if (!(LeshanServer.this.requestSender instanceof CoapRequestSender)) {
                throw new UnsupportedOperationException("This sender does not support to send CoAP request");
            }
            CoapRequestSender sender = (CoapRequestSender)LeshanServer.this.requestSender;
            sender.sendCoapRequest(destination, request, timeout, responseCallback, errorCallback);
        }
    }
}

