/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.server.californium.LeshanServer;
import org.eclipse.leshan.server.californium.LwM2mPskStore;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.californium.registration.InMemoryRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.model.StandardModelProvider;
import org.eclipse.leshan.server.queue.ClientAwakeTimeProvider;
import org.eclipse.leshan.server.queue.StaticClientAwakeTimeProvider;
import org.eclipse.leshan.server.registration.RandomStringRegistrationIdProvider;
import org.eclipse.leshan.server.registration.RegistrationIdProvider;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.DefaultAuthorizer;
import org.eclipse.leshan.server.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanServerBuilder.class);
    private CaliforniumRegistrationStore registrationStore;
    private SecurityStore securityStore;
    private LwM2mModelProvider modelProvider;
    private Authorizer authorizer;
    private ClientAwakeTimeProvider awakeTimeProvider;
    private RegistrationIdProvider registrationIdProvider;
    private InetSocketAddress localAddress;
    private InetSocketAddress localSecureAddress;
    private LwM2mNodeEncoder encoder;
    private LwM2mNodeDecoder decoder;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;
    private Certificate[] trustedCertificates;
    private NetworkConfig coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private EndpointFactory endpointFactory;
    private boolean noSecuredEndpoint;
    private boolean noUnsecuredEndpoint;
    private boolean noQueueMode = false;

    public LeshanServerBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanServerBuilder setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public LeshanServerBuilder setLocalSecureAddress(String hostname, int port) {
        this.localSecureAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanServerBuilder setLocalSecureAddress(InetSocketAddress localSecureAddress) {
        this.localSecureAddress = localSecureAddress;
        return this;
    }

    public LeshanServerBuilder setRegistrationStore(CaliforniumRegistrationStore registrationStore) {
        this.registrationStore = registrationStore;
        return this;
    }

    public LeshanServerBuilder setSecurityStore(SecurityStore securityStore) {
        this.securityStore = securityStore;
        return this;
    }

    public LeshanServerBuilder setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public LeshanServerBuilder setObjectModelProvider(LwM2mModelProvider objectModelProvider) {
        this.modelProvider = objectModelProvider;
        return this;
    }

    public LeshanServerBuilder setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public LeshanServerBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public <T extends X509Certificate> LeshanServerBuilder setCertificateChain(T[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public <T extends Certificate> LeshanServerBuilder setTrustedCertificates(T[] trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
        return this;
    }

    public LeshanServerBuilder setEncoder(LwM2mNodeEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanServerBuilder setDecoder(LwM2mNodeDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public LeshanServerBuilder setCoapConfig(NetworkConfig config) {
        this.coapConfig = config;
        return this;
    }

    public LeshanServerBuilder setDtlsConfig(DtlsConnectorConfig.Builder config) {
        this.dtlsConfigBuilder = config;
        return this;
    }

    public LeshanServerBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public LeshanServerBuilder disableUnsecuredEndpoint() {
        this.noUnsecuredEndpoint = true;
        return this;
    }

    public LeshanServerBuilder disableSecuredEndpoint() {
        this.noSecuredEndpoint = true;
        return this;
    }

    public LeshanServerBuilder disableQueueModeSupport() {
        this.noQueueMode = true;
        return this;
    }

    public LeshanServerBuilder setClientAwakeTimeProvider(ClientAwakeTimeProvider awakeTimeProvider) {
        this.awakeTimeProvider = awakeTimeProvider;
        return this;
    }

    public void setRegistrationIdProvider(RegistrationIdProvider registrationIdProvider) {
        this.registrationIdProvider = registrationIdProvider;
    }

    public static NetworkConfig createDefaultNetworkConfig() {
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.set("MID_TACKER", (Object)"NULL");
        return networkConfig;
    }

    public LeshanServer build() {
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(5683);
        }
        if (this.registrationStore == null) {
            this.registrationStore = new InMemoryRegistrationStore();
        }
        if (this.authorizer == null) {
            this.authorizer = new DefaultAuthorizer(this.securityStore);
        }
        if (this.modelProvider == null) {
            this.modelProvider = new StandardModelProvider();
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mNodeEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mNodeDecoder();
        }
        if (this.coapConfig == null) {
            this.coapConfig = LeshanServerBuilder.createDefaultNetworkConfig();
        }
        if (this.awakeTimeProvider == null) {
            int maxTransmitWait = this.coapConfig.getInt("MAX_TRANSMIT_WAIT");
            if (maxTransmitWait == 0) {
                LOG.warn("No value available for MAX_TRANSMIT_WAIT in CoAP NetworkConfig. Fallback with a default 93s value.");
                this.awakeTimeProvider = new StaticClientAwakeTimeProvider();
            } else {
                this.awakeTimeProvider = new StaticClientAwakeTimeProvider(maxTransmitWait);
            }
        }
        if (this.registrationIdProvider == null) {
            this.registrationIdProvider = new RandomStringRegistrationIdProvider();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M Server");
        }
        DtlsConnectorConfig dtlsConfig = null;
        if (!this.noSecuredEndpoint && this.shouldTryToCreateSecureEndpoint()) {
            DtlsConnectorConfig incompleteConfig;
            if (this.dtlsConfigBuilder == null) {
                this.dtlsConfigBuilder = new DtlsConnectorConfig.Builder();
            }
            if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getPskStore() != null) {
                LOG.warn("PskStore should be automatically set by Leshan. Using a custom implementation is not advised.");
            } else if (this.securityStore != null) {
                this.dtlsConfigBuilder.setPskStore((PskStore)new LwM2mPskStore(this.securityStore, this.registrationStore));
            }
            if (incompleteConfig.getAddress() == null) {
                if (this.localSecureAddress == null) {
                    this.localSecureAddress = new InetSocketAddress(5684);
                }
                this.dtlsConfigBuilder.setAddress(this.localSecureAddress);
            } else if (this.localSecureAddress != null && !this.localSecureAddress.equals(incompleteConfig.getAddress())) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for secure address: %s != %s", this.localSecureAddress, incompleteConfig.getAddress()));
            }
            if (incompleteConfig.getMaxConnections() == null) {
                this.dtlsConfigBuilder.setMaxConnections(this.coapConfig.getInt("MAX_ACTIVE_PEERS"));
            }
            if (incompleteConfig.getStaleConnectionThreshold() == null) {
                this.dtlsConfigBuilder.setStaleConnectionThreshold(this.coapConfig.getLong("MAX_PEER_INACTIVITY_PERIOD"));
            }
            if (this.trustedCertificates != null && incompleteConfig.getCertificateVerifier() == null) {
                if (incompleteConfig.getTrustStore() == null) {
                    this.dtlsConfigBuilder.setTrustStore(this.trustedCertificates);
                } else if (!Arrays.equals(this.trustedCertificates, incompleteConfig.getTrustStore())) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for trusted Certificates (trustStore) : \n%s != \n%s", Arrays.toString(this.trustedCertificates), Arrays.toString(incompleteConfig.getTrustStore())));
                }
            }
            if (this.privateKey != null) {
                if (incompleteConfig.getPrivateKey() != null && !incompleteConfig.getPrivateKey().equals(this.privateKey)) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for private key: %s != %s", this.privateKey, incompleteConfig.getPrivateKey()));
                }
                if (this.certificateChain == null && this.publicKey != null) {
                    if (incompleteConfig.getPublicKey() != null && !incompleteConfig.getPublicKey().equals(this.publicKey)) {
                        throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for public key: %s != %s", this.publicKey, incompleteConfig.getPublicKey()));
                    }
                    if (incompleteConfig.getRpkTrustStore() == null) {
                        this.dtlsConfigBuilder.setRpkTrustAll();
                    }
                    this.dtlsConfigBuilder.setIdentity(this.privateKey, this.publicKey);
                }
                if (this.certificateChain != null && this.certificateChain.length > 0) {
                    if (incompleteConfig.getCertificateChain() != null && !Arrays.asList(this.certificateChain).equals(incompleteConfig.getCertificateChain())) {
                        throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for certificate chain: %s != %s", Arrays.toString(this.certificateChain), incompleteConfig.getCertificateChain()));
                    }
                    if (incompleteConfig.getRpkTrustStore() == null) {
                        this.dtlsConfigBuilder.setRpkTrustAll();
                    }
                    this.dtlsConfigBuilder.setIdentity(this.privateKey, (Certificate[])this.certificateChain, new CertificateType[]{CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY});
                }
            }
            if (incompleteConfig.isSniEnabled() == null) {
                this.dtlsConfigBuilder.setSniEnabled(false);
            }
            if (incompleteConfig.getDefaultHandshakeMode() == null) {
                this.dtlsConfigBuilder.setDefaultHandshakeMode("none");
            }
            try {
                dtlsConfig = this.dtlsConfigBuilder.build();
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to create DTLS config and so secured endpoint.", (Throwable)e);
            }
        }
        CoapEndpoint unsecuredEndpoint = null;
        if (!this.noUnsecuredEndpoint) {
            unsecuredEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, (ObservationStore)this.registrationStore);
        }
        CoapEndpoint securedEndpoint = null;
        if (!this.noSecuredEndpoint && dtlsConfig != null) {
            securedEndpoint = this.endpointFactory.createSecuredEndpoint(dtlsConfig, this.coapConfig, (ObservationStore)this.registrationStore);
        }
        if (securedEndpoint == null && unsecuredEndpoint == null) {
            throw new IllegalStateException("All CoAP enpoints are deactivated, at least one endpoint should be activated");
        }
        return this.createServer(unsecuredEndpoint, securedEndpoint, this.registrationStore, this.securityStore, this.authorizer, this.modelProvider, this.encoder, this.decoder, this.coapConfig, this.noQueueMode, this.awakeTimeProvider, this.registrationIdProvider);
    }

    protected boolean shouldTryToCreateSecureEndpoint() {
        return this.dtlsConfigBuilder != null || this.certificateChain != null || this.privateKey != null || this.publicKey != null || this.securityStore != null || this.trustedCertificates != null;
    }

    protected LeshanServer createServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, CaliforniumRegistrationStore registrationStore, SecurityStore securityStore, Authorizer authorizer, LwM2mModelProvider modelProvider, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, NetworkConfig coapConfig, boolean noQueueMode, ClientAwakeTimeProvider awakeTimeProvider, RegistrationIdProvider registrationIdProvider) {
        return new LeshanServer(unsecuredEndpoint, securedEndpoint, registrationStore, securityStore, authorizer, modelProvider, encoder, decoder, coapConfig, noQueueMode, awakeTimeProvider, registrationIdProvider);
    }
}

