/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.response.BootstrapResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.bootstrap.BootstrapHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapResource
extends LwM2mCoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapResource.class);
    private static final String QUERY_PARAM_ENDPOINT = "ep=";
    private final BootstrapHandler bootstrapHandler;

    public BootstrapResource(BootstrapHandler handler) {
        super("bs");
        this.bootstrapHandler = handler;
    }

    public void handlePOST(CoapExchange exchange) {
        Identity clientIdentity;
        SendableResponse sendableResponse;
        BootstrapResponse response;
        Request request = exchange.advanced().getRequest();
        LOG.trace("POST received : {}", (Object)request);
        if (!CoAP.Type.CON.equals((Object)request.getType())) {
            this.handleInvalidRequest(exchange, "CON CoAP type expected");
            return;
        }
        String endpoint = null;
        for (String param : request.getOptions().getUriQuery()) {
            if (!param.startsWith(QUERY_PARAM_ENDPOINT)) continue;
            endpoint = param.substring(QUERY_PARAM_ENDPOINT.length());
            break;
        }
        if ((response = (BootstrapResponse)(sendableResponse = this.bootstrapHandler.bootstrap(clientIdentity = this.extractIdentity(request.getSourceContext()), new BootstrapRequest(endpoint))).getResponse()).isSuccess()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        }
        sendableResponse.sent();
    }
}

