/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.observation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.observation.ObservationListener;
import org.eclipse.leshan.server.observation.ObservationService;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationServiceImpl
implements ObservationService,
NotificationListener {
    private final Logger LOG = LoggerFactory.getLogger(ObservationServiceImpl.class);
    private final CaliforniumRegistrationStore registrationStore;
    private final LwM2mModelProvider modelProvider;
    private final LwM2mNodeDecoder decoder;
    private Endpoint secureEndpoint;
    private Endpoint nonSecureEndpoint;
    private final List<ObservationListener> listeners = new CopyOnWriteArrayList<ObservationListener>();

    public ObservationServiceImpl(CaliforniumRegistrationStore store, LwM2mModelProvider modelProvider, LwM2mNodeDecoder decoder) {
        this.registrationStore = store;
        this.modelProvider = modelProvider;
        this.decoder = decoder;
    }

    public void addObservation(Registration registration, Observation observation) {
        for (Observation existing : this.registrationStore.addObservation(registration.getId(), observation)) {
            this.cancel(existing);
        }
        for (ObservationListener listener : this.listeners) {
            listener.newObservation(observation, registration);
        }
    }

    public void setNonSecureEndpoint(Endpoint endpoint) {
        this.nonSecureEndpoint = endpoint;
    }

    public void setSecureEndpoint(Endpoint endpoint) {
        this.secureEndpoint = endpoint;
    }

    public int cancelObservations(Registration registration) {
        String registrationId = registration.getId();
        if (registrationId == null) {
            return 0;
        }
        Collection observations = this.registrationStore.removeObservations(registrationId);
        if (observations == null) {
            return 0;
        }
        for (Observation observation : observations) {
            this.cancel(observation);
        }
        return observations.size();
    }

    public int cancelObservations(Registration registration, String resourcepath) {
        if (registration == null || registration.getId() == null || resourcepath == null || resourcepath.isEmpty()) {
            return 0;
        }
        Set<Observation> observations = this.getObservations(registration.getId(), resourcepath);
        for (Observation observation : observations) {
            this.cancelObservation(observation);
        }
        return observations.size();
    }

    public void cancelObservation(Observation observation) {
        if (observation == null) {
            return;
        }
        this.registrationStore.removeObservation(observation.getRegistrationId(), observation.getId());
        this.cancel(observation);
    }

    private void cancel(Observation observation) {
        Token token = new Token(observation.getId());
        if (this.secureEndpoint != null) {
            this.secureEndpoint.cancelObservation(token);
        }
        if (this.nonSecureEndpoint != null) {
            this.nonSecureEndpoint.cancelObservation(token);
        }
        for (ObservationListener listener : this.listeners) {
            listener.cancelled(observation);
        }
    }

    public Set<Observation> getObservations(Registration registration) {
        return this.getObservations(registration.getId());
    }

    private Set<Observation> getObservations(String registrationId) {
        if (registrationId == null) {
            return Collections.emptySet();
        }
        return new HashSet<Observation>(this.registrationStore.getObservations(registrationId));
    }

    private Set<Observation> getObservations(String registrationId, String resourcePath) {
        if (registrationId == null || resourcePath == null) {
            return Collections.emptySet();
        }
        HashSet<Observation> result = new HashSet<Observation>();
        LwM2mPath lwPath = new LwM2mPath(resourcePath);
        for (Observation obs : this.getObservations(registrationId)) {
            if (!lwPath.equals((Object)obs.getPath())) continue;
            result.add(obs);
        }
        return result;
    }

    public ObservationStore getObservationStore() {
        return this.registrationStore;
    }

    public void addListener(ObservationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ObservationListener listener) {
        this.listeners.remove(listener);
    }

    public void onNotification(Request coapRequest, Response coapResponse) {
        this.LOG.trace("notification received for request {}: {}", (Object)coapRequest, (Object)coapResponse);
        if (this.listeners.isEmpty()) {
            return;
        }
        String regid = (String)coapRequest.getUserContext().get("leshan-regId");
        Observation observation = this.registrationStore.getObservation(regid, coapResponse.getToken().getBytes());
        if (observation == null) {
            this.LOG.error("Unexpected error: Unable to find observation with token {} for registration {}", (Object)coapResponse.getToken(), (Object)regid);
            return;
        }
        Registration registration = this.registrationStore.getRegistration(observation.getRegistrationId());
        if (registration == null) {
            this.LOG.error("Unexpected error: There is no registration with id {} for this observation {}", (Object)observation.getRegistrationId(), (Object)observation);
            return;
        }
        try {
            LwM2mModel model = this.modelProvider.getObjectModel(registration);
            ObserveResponse response = this.createObserveResponse(observation, model, coapResponse);
            for (ObservationListener listener : this.listeners) {
                listener.onResponse(observation, registration, response);
            }
        }
        catch (InvalidResponseException e) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(String.format("Invalid notification for observation [%s]", observation), (Throwable)e);
            }
            for (ObservationListener listener : this.listeners) {
                listener.onError(observation, registration, (Exception)((Object)e));
            }
        }
        catch (RuntimeException e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error(String.format("Unable to handle notification for observation [%s]", observation), (Throwable)e);
            }
            for (ObservationListener listener : this.listeners) {
                listener.onError(observation, registration, (Exception)e);
            }
        }
    }

    private ObserveResponse createObserveResponse(Observation observation, LwM2mModel model, Response coapResponse) {
        if (coapResponse.getCode() != CoAP.ResponseCode.CHANGED && coapResponse.getCode() != CoAP.ResponseCode.CONTENT) {
            throw new InvalidResponseException("Unexpected response code [%s] for %s", new Object[]{coapResponse.getCode(), observation});
        }
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        try {
            List timestampedNodes = this.decoder.decodeTimestampedData(coapResponse.getPayload(), contentFormat, observation.getPath(), model);
            if (timestampedNodes.size() == 1 && !((TimestampedLwM2mNode)timestampedNodes.get(0)).isTimestamped()) {
                return new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)coapResponse.getCode()), ((TimestampedLwM2mNode)timestampedNodes.get(0)).getNode(), null, observation, null, (Object)coapResponse);
            }
            return new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)coapResponse.getCode()), null, timestampedNodes, observation, null, (Object)coapResponse);
        }
        catch (CodecException e) {
            if (this.LOG.isDebugEnabled()) {
                byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
                this.LOG.debug(String.format("Unable to decode notification payload [%s] of observation [%s] ", Hex.encodeHexString((byte[])payload), observation), (Throwable)e);
            }
            throw new InvalidResponseException((Throwable)e, "Unable to decode notification payload  of observation [%s] ", new Object[]{observation});
        }
    }
}

