/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.LwM2mRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.CancelObservationResponse;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.californium.observation.ObserveUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mResponseBuilder<T extends LwM2mResponse>
implements DownlinkRequestVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mResponseBuilder.class);
    private LwM2mResponse lwM2mresponse;
    private final Request coapRequest;
    private final Response coapResponse;
    private final String clientEndpoint;
    private final LwM2mModel model;
    private final LwM2mNodeDecoder decoder;

    public LwM2mResponseBuilder(Request coapRequest, Response coapResponse, String clientEndpoint, LwM2mModel model, LwM2mNodeDecoder decoder) {
        this.coapRequest = coapRequest;
        this.coapResponse = coapResponse;
        this.clientEndpoint = clientEndpoint;
        this.model = model;
        this.decoder = decoder;
    }

    public void visit(ReadRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ReadResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new ReadResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DiscoverRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new DiscoverResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT) {
            Link[] links;
            if (40 != this.coapResponse.getOptions().getContentFormat()) {
                LOG.debug("Expected LWM2M Client [{}] to return application/link-format [{}] content but got [{}]", new Object[]{this.clientEndpoint, 40, this.coapResponse.getOptions().getContentFormat()});
                links = new Link[]{};
            } else {
                links = Link.parse((byte[])this.coapResponse.getPayload());
            }
            this.lwM2mresponse = new DiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new WriteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = new WriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteAttributesRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new WriteAttributesResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = new WriteAttributesResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ExecuteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ExecuteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = new ExecuteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CreateRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new CreateResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CREATED) {
            this.lwM2mresponse = new CreateResponse(ResponseCode.CREATED, this.coapResponse.getOptions().getLocationPathCount() == 0 ? null : this.coapResponse.getOptions().getLocationPathString(), null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DeleteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new DeleteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = new DeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ObserveRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT || this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            if (this.coapResponse.getOptions().hasObserve()) {
                Observation observation = ObserveUtil.createLwM2mObservation(this.coapRequest);
                this.lwM2mresponse = new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), content, null, observation, null, (Object)this.coapResponse);
            } else {
                this.lwM2mresponse = new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), content, null, null, null, (Object)this.coapResponse);
            }
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CancelObservationRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new CancelObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT || this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new CancelObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), content, null, null, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapWriteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDeleteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapFinishRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    private LwM2mNode decodeCoapResponse(LwM2mPath path, Response coapResponse, LwM2mRequest<?> request, String endpoint) {
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        try {
            return this.decoder.decode(coapResponse.getPayload(), contentFormat, path, this.model);
        }
        catch (CodecException e) {
            if (LOG.isDebugEnabled()) {
                byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
                LOG.debug(String.format("Unable to decode response payload of request [%s] from client [%s] [payload:%s]", request, endpoint, Hex.encodeHexString((byte[])payload)));
            }
            throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, endpoint});
        }
    }

    public T getResponse() {
        return (T)this.lwM2mresponse;
    }

    private void handleUnexpectedResponseCode(String clientEndpoint, LwM2mRequest<?> request, Response coapResponse) {
        throw new InvalidResponseException("Client [%s] returned unexpected response code [%s] for [%s]", new Object[]{clientEndpoint, coapResponse.getCode(), request});
    }
}

