/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.BridgeCertificateVerifier;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectLoader;
import org.eclipse.leshan.core.model.StaticModel;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapHandler;
import org.eclipse.leshan.server.bootstrap.BootstrapHandlerFactory;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapHandler;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.InMemoryBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.LwM2mBootstrapRequestSender;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.LwM2mAdvancedBootstrapPskStore;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanBootstrapServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanBootstrapServerBuilder.class);
    private InetSocketAddress localAddress;
    private InetSocketAddress localAddressSecure;
    private BootstrapConfigStore configStore;
    private BootstrapSecurityStore securityStore;
    private BootstrapSessionManager sessionManager;
    private BootstrapHandlerFactory bootstrapHandlerFactory;
    private LwM2mModel model;
    private NetworkConfig coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private LwM2mNodeEncoder encoder;
    private LwM2mNodeDecoder decoder;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;
    private Certificate[] trustedCertificates;
    private EndpointFactory endpointFactory;
    private boolean noSecuredEndpoint;
    private boolean noUnsecuredEndpoint;

    public LeshanBootstrapServerBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalSecureAddress(String hostname, int port) {
        this.localAddressSecure = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalSecureAddress(InetSocketAddress localSecureAddress) {
        this.localAddressSecure = localSecureAddress;
        return this;
    }

    public LeshanBootstrapServerBuilder setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public <T extends X509Certificate> LeshanBootstrapServerBuilder setCertificateChain(T[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public LeshanBootstrapServerBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public <T extends Certificate> LeshanBootstrapServerBuilder setTrustedCertificates(T[] trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
        return this;
    }

    public LeshanBootstrapServerBuilder setConfigStore(BootstrapConfigStore configStore) {
        this.configStore = configStore;
        return this;
    }

    public LeshanBootstrapServerBuilder setSecurityStore(BootstrapSecurityStore securityStore) {
        this.securityStore = securityStore;
        return this;
    }

    public LeshanBootstrapServerBuilder setSessionManager(BootstrapSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public LeshanBootstrapServerBuilder setBootstrapHandlerFactory(BootstrapHandlerFactory bootstrapHandlerFactory) {
        this.bootstrapHandlerFactory = bootstrapHandlerFactory;
        return this;
    }

    public LeshanBootstrapServerBuilder setModel(LwM2mModel model) {
        this.model = model;
        return this;
    }

    public LeshanBootstrapServerBuilder setEncoder(LwM2mNodeEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanBootstrapServerBuilder setDecoder(LwM2mNodeDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public LeshanBootstrapServerBuilder setCoapConfig(NetworkConfig coapConfig) {
        this.coapConfig = coapConfig;
        return this;
    }

    public LeshanBootstrapServerBuilder setDtlsConfig(DtlsConnectorConfig.Builder dtlsConfig) {
        this.dtlsConfigBuilder = dtlsConfig;
        return this;
    }

    public LeshanBootstrapServerBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public LeshanBootstrapServerBuilder disableUnsecuredEndpoint() {
        this.noUnsecuredEndpoint = true;
        return this;
    }

    public LeshanBootstrapServerBuilder disableSecuredEndpoint() {
        this.noSecuredEndpoint = true;
        return this;
    }

    public NetworkConfig createDefaultNetworkConfig() {
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.set("MID_TACKER", (Object)"NULL");
        return networkConfig;
    }

    public LeshanBootstrapServer build() {
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(5683);
        }
        if (this.configStore == null) {
            this.configStore = new InMemoryBootstrapConfigStore();
        }
        if (this.sessionManager == null) {
            this.sessionManager = new DefaultBootstrapSessionManager(this.securityStore);
        }
        if (this.bootstrapHandlerFactory == null) {
            this.bootstrapHandlerFactory = new BootstrapHandlerFactory(){

                public BootstrapHandler create(BootstrapConfigStore store, LwM2mBootstrapRequestSender sender, BootstrapSessionManager sessionManager) {
                    return new DefaultBootstrapHandler(store, sender, sessionManager);
                }
            };
        }
        if (this.model == null) {
            this.model = new StaticModel((Collection)ObjectLoader.loadDefault());
        }
        if (this.coapConfig == null) {
            this.coapConfig = this.createDefaultNetworkConfig();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M BS Server");
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mNodeEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mNodeDecoder();
        }
        DtlsConnectorConfig dtlsConfig = null;
        if (!this.noSecuredEndpoint && this.shouldTryToCreateSecureEndpoint()) {
            DtlsConnectorConfig incompleteConfig;
            if (this.dtlsConfigBuilder == null) {
                this.dtlsConfigBuilder = new DtlsConnectorConfig.Builder();
            }
            if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getAdvancedPskStore() != null) {
                LOG.warn("PskStore should be automatically set by Leshan. Using a custom implementation is not advised.");
            } else if (this.securityStore != null) {
                this.dtlsConfigBuilder.setAdvancedPskStore((AdvancedPskStore)new LwM2mAdvancedBootstrapPskStore(this.securityStore));
            }
            if (incompleteConfig.getAddress() == null) {
                if (this.localAddressSecure == null) {
                    this.localAddressSecure = new InetSocketAddress(5684);
                }
                this.dtlsConfigBuilder.setAddress(this.localAddressSecure);
            } else if (this.localAddressSecure != null && !this.localAddressSecure.equals(incompleteConfig.getAddress())) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for secure address: %s != %s", this.localAddressSecure, incompleteConfig.getAddress()));
            }
            if (incompleteConfig.getMaxConnections() == null) {
                this.dtlsConfigBuilder.setMaxConnections(this.coapConfig.getInt("MAX_ACTIVE_PEERS"));
            }
            if (incompleteConfig.getStaleConnectionThreshold() == null) {
                this.dtlsConfigBuilder.setStaleConnectionThreshold(this.coapConfig.getLong("MAX_PEER_INACTIVITY_PERIOD"));
            }
            if (this.privateKey != null) {
                if (incompleteConfig.getPrivateKey() != null && !incompleteConfig.getPrivateKey().equals(this.privateKey)) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for private key: %s != %s", this.privateKey, incompleteConfig.getPrivateKey()));
                }
                if (this.certificateChain == null && this.publicKey != null) {
                    if (incompleteConfig.getPublicKey() != null && !incompleteConfig.getPublicKey().equals(this.publicKey)) {
                        throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for public key: %s != %s", this.publicKey, incompleteConfig.getPublicKey()));
                    }
                    this.dtlsConfigBuilder.setIdentity(this.privateKey, this.publicKey);
                }
                if (this.certificateChain != null && this.certificateChain.length > 0) {
                    if (incompleteConfig.getCertificateChain() != null && !Arrays.asList(this.certificateChain).equals(incompleteConfig.getCertificateChain())) {
                        throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for certificate chain: %s != %s", Arrays.toString(this.certificateChain), incompleteConfig.getCertificateChain()));
                    }
                    this.dtlsConfigBuilder.setIdentity(this.privateKey, (Certificate[])this.certificateChain, new CertificateType[]{CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY});
                }
                if (incompleteConfig.getAdvancedCertificateVerifier() != null) {
                    if (this.trustedCertificates != null) {
                        throw new IllegalStateException("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder: if a AdvancedCertificateVerifier is set, trustedCertificates must not be set.");
                    }
                } else {
                    BridgeCertificateVerifier.Builder verifierBuilder = new BridgeCertificateVerifier.Builder();
                    if (incompleteConfig.getRpkTrustStore() != null) {
                        verifierBuilder.setTrustedRPKs(incompleteConfig.getRpkTrustStore());
                    } else {
                        verifierBuilder.setTrustAllRPKs();
                    }
                    if (incompleteConfig.getTrustStore() != null) {
                        if (this.trustedCertificates != null && !Arrays.equals(this.trustedCertificates, incompleteConfig.getTrustStore())) {
                            throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for trusted Certificates (trustStore) : \n%s != \n%s", Arrays.toString(this.trustedCertificates), Arrays.toString(incompleteConfig.getTrustStore())));
                        }
                        verifierBuilder.setTrustedCertificates((Certificate[])incompleteConfig.getTrustStore());
                    } else if (this.trustedCertificates != null) {
                        verifierBuilder.setTrustedCertificates(this.trustedCertificates);
                    }
                    if (incompleteConfig.getCertificateVerifier() != null) {
                        if (this.trustedCertificates != null) {
                            throw new IllegalStateException("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder: if a CertificateVerifier is set, trustedCertificates must not be set.");
                        }
                        verifierBuilder.setCertificateVerifier(incompleteConfig.getCertificateVerifier());
                    }
                    this.dtlsConfigBuilder.setAdvancedCertificateVerifier(verifierBuilder.build());
                }
            }
            if (incompleteConfig.isServerOnly() == null) {
                this.dtlsConfigBuilder.setServerOnly(true);
            }
            if (incompleteConfig.isSniEnabled() == null) {
                this.dtlsConfigBuilder.setSniEnabled(false);
            }
            try {
                dtlsConfig = this.dtlsConfigBuilder.build();
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to create DTLS config and so secured endpoint.", (Throwable)e);
            }
        }
        CoapEndpoint unsecuredEndpoint = null;
        if (!this.noUnsecuredEndpoint) {
            unsecuredEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, null);
        }
        CoapEndpoint securedEndpoint = null;
        if (!this.noSecuredEndpoint && dtlsConfig != null) {
            securedEndpoint = this.endpointFactory.createSecuredEndpoint(dtlsConfig, this.coapConfig, null);
        }
        if (securedEndpoint == null && unsecuredEndpoint == null) {
            throw new IllegalStateException("All CoAP enpoints are deactivated, at least one endpoint should be activated");
        }
        return this.createBootstrapServer(unsecuredEndpoint, securedEndpoint, this.configStore, this.securityStore, this.sessionManager, this.bootstrapHandlerFactory, this.model, this.coapConfig, this.encoder, this.decoder);
    }

    protected boolean shouldTryToCreateSecureEndpoint() {
        return this.dtlsConfigBuilder != null || this.certificateChain != null || this.privateKey != null || this.publicKey != null || this.securityStore != null || this.trustedCertificates != null;
    }

    protected LeshanBootstrapServer createBootstrapServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, BootstrapConfigStore bsStore, BootstrapSecurityStore bsSecurityStore, BootstrapSessionManager bsSessionManager, BootstrapHandlerFactory bsHandlerFactory, LwM2mModel model, NetworkConfig coapConfig, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder) {
        return new LeshanBootstrapServer(unsecuredEndpoint, securedEndpoint, bsStore, bsSecurityStore, bsSessionManager, bsHandlerFactory, model, coapConfig, encoder, decoder);
    }
}

