/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.observation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.ObserveRequest;

public class ObserveUtil {
    public static final String CTX_ENDPOINT = "leshan-endpoint";
    public static final String CTX_REGID = "leshan-regId";
    public static final String CTX_LWM2M_PATH = "leshan-path";

    public static org.eclipse.leshan.core.observation.Observation createLwM2mObservation(Request request) {
        String regId = null;
        String lwm2mPath = null;
        HashMap context = null;
        block10: for (Map.Entry ctx : request.getUserContext().entrySet()) {
            switch ((String)ctx.getKey()) {
                case "leshan-regId": {
                    regId = (String)ctx.getValue();
                    continue block10;
                }
                case "leshan-path": {
                    lwm2mPath = (String)ctx.getValue();
                    continue block10;
                }
                case "leshan-endpoint": {
                    continue block10;
                }
            }
            if (context == null) {
                context = new HashMap();
            }
            context.put(ctx.getKey(), ctx.getValue());
        }
        ContentFormat contentFormat = null;
        if (request.getOptions().hasAccept()) {
            contentFormat = ContentFormat.fromCode((int)request.getOptions().getAccept());
        }
        return new org.eclipse.leshan.core.observation.Observation(request.getToken().getBytes(), regId, new LwM2mPath(lwm2mPath), contentFormat, context);
    }

    public static Map<String, String> createCoapObserveRequestContext(String endpoint, String registrationId, ObserveRequest request) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(CTX_ENDPOINT, endpoint);
        context.put(CTX_REGID, registrationId);
        context.put(CTX_LWM2M_PATH, request.getPath().toString());
        for (Map.Entry ctx : request.getContext().entrySet()) {
            context.put((String)ctx.getKey(), (String)ctx.getValue());
        }
        return context;
    }

    public static String extractRegistrationId(Observation observation) {
        return (String)observation.getRequest().getUserContext().get(CTX_REGID);
    }

    public static String extractLwm2mPath(Observation observation) {
        return (String)observation.getRequest().getUserContext().get(CTX_LWM2M_PATH);
    }

    public static String extractEndpoint(Observation observation) {
        return (String)observation.getRequest().getUserContext().get(CTX_ENDPOINT);
    }

    public static String validateCoapObservation(Observation observation) {
        if (!observation.getRequest().getUserContext().containsKey(CTX_REGID)) {
            throw new IllegalStateException("missing registrationId info in the request context");
        }
        if (!observation.getRequest().getUserContext().containsKey(CTX_LWM2M_PATH)) {
            throw new IllegalStateException("missing lwm2m path info in the request context");
        }
        String endpoint = (String)observation.getRequest().getUserContext().get(CTX_ENDPOINT);
        if (endpoint == null) {
            throw new IllegalStateException("missing endpoint info in the request context");
        }
        return endpoint;
    }
}

