/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.registration;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.core.observe.ObservationStoreException;
import org.eclipse.californium.core.observe.ObservationUtil;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.server.Destroyable;
import org.eclipse.leshan.server.Startable;
import org.eclipse.leshan.server.Stoppable;
import org.eclipse.leshan.server.californium.observation.ObserveUtil;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.registration.Deregistration;
import org.eclipse.leshan.server.registration.ExpirationListener;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.registration.UpdatedRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRegistrationStore
implements CaliforniumRegistrationStore,
Startable,
Stoppable,
Destroyable {
    private final Logger LOG = LoggerFactory.getLogger(InMemoryRegistrationStore.class);
    private final Map<String, Registration> regsByEp = new HashMap<String, Registration>();
    private final Map<InetSocketAddress, Registration> regsByAddr = new HashMap<InetSocketAddress, Registration>();
    private final Map<String, Registration> regsByRegId = new HashMap<String, Registration>();
    private Map<Token, Observation> obsByToken = new HashMap<Token, Observation>();
    private Map<String, Set<Token>> tokensByRegId = new HashMap<String, Set<Token>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ExpirationListener expirationListener;
    private final ScheduledExecutorService schedExecutor;
    private ScheduledFuture<?> cleanerTask;
    private boolean started = false;
    private final long cleanPeriod;

    public InMemoryRegistrationStore() {
        this(2L);
    }

    public InMemoryRegistrationStore(long cleanPeriodInSec) {
        this(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(String.format("InMemoryRegistrationStore Cleaner (%ds)", cleanPeriodInSec))), cleanPeriodInSec);
    }

    public InMemoryRegistrationStore(ScheduledExecutorService schedExecutor, long cleanPeriodInSec) {
        this.schedExecutor = schedExecutor;
        this.cleanPeriod = cleanPeriodInSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deregistration addRegistration(Registration registration) {
        try {
            this.lock.writeLock().lock();
            Registration registrationRemoved = this.regsByEp.put(registration.getEndpoint(), registration);
            this.regsByRegId.put(registration.getId(), registration);
            this.regsByAddr.put(registration.getSocketAddress(), registration);
            if (registrationRemoved != null) {
                Collection<org.eclipse.leshan.core.observation.Observation> observationsRemoved = this.unsafeRemoveAllObservations(registrationRemoved.getId());
                if (!registrationRemoved.getSocketAddress().equals(registration.getSocketAddress())) {
                    this.removeFromMap(this.regsByAddr, registrationRemoved.getSocketAddress(), registrationRemoved);
                }
                if (!registrationRemoved.getId().equals(registration.getId())) {
                    this.removeFromMap(this.regsByRegId, registrationRemoved.getId(), registrationRemoved);
                }
                Deregistration deregistration = new Deregistration(registrationRemoved, observationsRemoved);
                return deregistration;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatedRegistration updateRegistration(RegistrationUpdate update) {
        try {
            this.lock.writeLock().lock();
            Registration registration = this.getRegistration(update.getRegistrationId());
            if (registration == null) {
                UpdatedRegistration updatedRegistration = null;
                return updatedRegistration;
            }
            Registration updatedRegistration = update.update(registration);
            this.regsByEp.put(updatedRegistration.getEndpoint(), updatedRegistration);
            this.regsByAddr.put(updatedRegistration.getSocketAddress(), updatedRegistration);
            if (!registration.getSocketAddress().equals(updatedRegistration.getSocketAddress())) {
                this.removeFromMap(this.regsByAddr, registration.getSocketAddress(), registration);
            }
            this.regsByRegId.put(updatedRegistration.getId(), updatedRegistration);
            UpdatedRegistration updatedRegistration2 = new UpdatedRegistration(registration, updatedRegistration);
            return updatedRegistration2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Registration getRegistration(String registrationId) {
        try {
            this.lock.readLock().lock();
            Registration registration = this.regsByRegId.get(registrationId);
            return registration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Registration getRegistrationByEndpoint(String endpoint) {
        try {
            this.lock.readLock().lock();
            Registration registration = this.regsByEp.get(endpoint);
            return registration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Registration getRegistrationByAdress(InetSocketAddress address) {
        try {
            this.lock.readLock().lock();
            Registration registration = this.regsByAddr.get(address);
            return registration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterator<Registration> getAllRegistrations() {
        try {
            this.lock.readLock().lock();
            Iterator<Registration> iterator = new ArrayList<Registration>(this.regsByEp.values()).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deregistration removeRegistration(String registrationId) {
        try {
            this.lock.writeLock().lock();
            Registration registration = this.getRegistration(registrationId);
            if (registration != null) {
                Collection<org.eclipse.leshan.core.observation.Observation> observationsRemoved = this.unsafeRemoveAllObservations(registration.getId());
                this.regsByEp.remove(registration.getEndpoint());
                this.removeFromMap(this.regsByAddr, registration.getSocketAddress(), registration);
                this.removeFromMap(this.regsByRegId, registration.getId(), registration);
                Deregistration deregistration = new Deregistration(registration, observationsRemoved);
                return deregistration;
            }
            Deregistration deregistration = null;
            return deregistration;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.eclipse.leshan.core.observation.Observation> addObservation(String registrationId, org.eclipse.leshan.core.observation.Observation observation) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> removed = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        try {
            this.lock.writeLock().lock();
            for (org.eclipse.leshan.core.observation.Observation obs : this.unsafeGetObservations(registrationId)) {
                if (!observation.getPath().equals((Object)obs.getPath()) || Arrays.equals(observation.getId(), obs.getId())) continue;
                this.unsafeRemoveObservation(new Token(obs.getId()));
                removed.add(obs);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.leshan.core.observation.Observation removeObservation(String registrationId, byte[] observationId) {
        try {
            this.lock.writeLock().lock();
            Token token = new Token(observationId);
            org.eclipse.leshan.core.observation.Observation observation = this.build(this.unsafeGetObservation(token));
            if (observation != null && registrationId.equals(observation.getRegistrationId())) {
                this.unsafeRemoveObservation(token);
                org.eclipse.leshan.core.observation.Observation observation2 = observation;
                return observation2;
            }
            org.eclipse.leshan.core.observation.Observation observation3 = null;
            return observation3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.leshan.core.observation.Observation getObservation(String registrationId, byte[] observationId) {
        try {
            this.lock.readLock().lock();
            org.eclipse.leshan.core.observation.Observation observation = this.build(this.unsafeGetObservation(new Token(observationId)));
            if (observation != null && registrationId.equals(observation.getRegistrationId())) {
                org.eclipse.leshan.core.observation.Observation observation2 = observation;
                return observation2;
            }
            org.eclipse.leshan.core.observation.Observation observation3 = null;
            return observation3;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<org.eclipse.leshan.core.observation.Observation> getObservations(String registrationId) {
        try {
            this.lock.readLock().lock();
            Collection<org.eclipse.leshan.core.observation.Observation> collection = this.unsafeGetObservations(registrationId);
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<org.eclipse.leshan.core.observation.Observation> removeObservations(String registrationId) {
        try {
            this.lock.writeLock().lock();
            Collection<org.eclipse.leshan.core.observation.Observation> collection = this.unsafeRemoveAllObservations(registrationId);
            return collection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Observation putIfAbsent(Token token, Observation obs) throws ObservationStoreException {
        return this.add(token, obs, true);
    }

    public Observation put(Token token, Observation obs) throws ObservationStoreException {
        return this.add(token, obs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Observation add(Token token, Observation obs, boolean ifAbsent) throws ObservationStoreException {
        Observation previousObservation = null;
        if (obs == null) return previousObservation;
        try {
            this.lock.writeLock().lock();
            this.validateObservation(obs);
            String registrationId = ObserveUtil.extractRegistrationId(obs);
            if (ifAbsent) {
                if (this.obsByToken.containsKey(token)) {
                    Observation observation = this.obsByToken.get(token);
                    return observation;
                }
                previousObservation = this.obsByToken.put(token, obs);
            } else {
                previousObservation = this.obsByToken.put(token, obs);
            }
            if (!this.tokensByRegId.containsKey(registrationId)) {
                this.tokensByRegId.put(registrationId, new HashSet());
            }
            this.tokensByRegId.get(registrationId).add(token);
            if (previousObservation == null) return previousObservation;
            this.LOG.warn("Token collision ? observation from request [{}] will be replaced by observation from request [{}] ", (Object)previousObservation.getRequest(), (Object)obs.getRequest());
            return previousObservation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Observation get(Token token) {
        try {
            this.lock.readLock().lock();
            Observation observation = this.unsafeGetObservation(token);
            return observation;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(Token token, EndpointContext ctx) {
        try {
            this.lock.writeLock().lock();
            Observation obs = this.obsByToken.get(token);
            if (obs != null) {
                this.obsByToken.put(token, new Observation(obs.getRequest(), ctx));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(Token token) {
        try {
            this.lock.writeLock().lock();
            this.unsafeRemoveObservation(token);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Observation unsafeGetObservation(Token token) {
        Observation obs = this.obsByToken.get(token);
        return ObservationUtil.shallowClone((Observation)obs);
    }

    private void unsafeRemoveObservation(Token observationId) {
        Observation removed = this.obsByToken.remove(observationId);
        if (removed != null) {
            String registrationId = ObserveUtil.extractRegistrationId(removed);
            Set<Token> tokens = this.tokensByRegId.get(registrationId);
            tokens.remove(observationId);
            if (tokens.isEmpty()) {
                this.tokensByRegId.remove(registrationId);
            }
        }
    }

    private Collection<org.eclipse.leshan.core.observation.Observation> unsafeRemoveAllObservations(String registrationId) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> removed = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        Set<Token> tokens = this.tokensByRegId.get(registrationId);
        if (tokens != null) {
            for (Token token : tokens) {
                org.eclipse.leshan.core.observation.Observation observationRemoved = this.build(this.obsByToken.remove(token));
                if (observationRemoved == null) continue;
                removed.add(observationRemoved);
            }
        }
        this.tokensByRegId.remove(registrationId);
        return removed;
    }

    private Collection<org.eclipse.leshan.core.observation.Observation> unsafeGetObservations(String registrationId) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> result = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        Set<Token> tokens = this.tokensByRegId.get(registrationId);
        if (tokens != null) {
            for (Token token : tokens) {
                org.eclipse.leshan.core.observation.Observation obs = this.build(this.unsafeGetObservation(token));
                if (obs == null) continue;
                result.add(obs);
            }
        }
        return result;
    }

    private org.eclipse.leshan.core.observation.Observation build(Observation cfObs) {
        if (cfObs == null) {
            return null;
        }
        return ObserveUtil.createLwM2mObservation(cfObs.getRequest());
    }

    private String validateObservation(Observation observation) throws ObservationStoreException {
        String endpoint = ObserveUtil.validateCoapObservation(observation);
        if (this.getRegistration(ObserveUtil.extractRegistrationId(observation)) == null) {
            throw new ObservationStoreException("no registration for this Id");
        }
        return endpoint;
    }

    public void setExpirationListener(ExpirationListener listener) {
        this.expirationListener = listener;
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.cleanerTask = this.schedExecutor.scheduleAtFixedRate(new Cleaner(), this.cleanPeriod, this.cleanPeriod, TimeUnit.SECONDS);
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (this.cleanerTask != null) {
                this.cleanerTask.cancel(false);
                this.cleanerTask = null;
            }
        }
    }

    public synchronized void destroy() {
        this.started = false;
        this.schedExecutor.shutdownNow();
        try {
            this.schedExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.warn("Destroying InMemoryRegistrationStore was interrupted.", (Throwable)e);
        }
    }

    protected <K, V> boolean removeFromMap(Map<K, V> map, K key, V value) {
        if (map.containsKey(key) && Objects.equals(map.get(key), value)) {
            map.remove(key);
            return true;
        }
        return false;
    }

    public void setExecutor(ScheduledExecutorService executor) {
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            try {
                ArrayList allRegs = new ArrayList();
                try {
                    InMemoryRegistrationStore.this.lock.readLock().lock();
                    allRegs.addAll(InMemoryRegistrationStore.this.regsByEp.values());
                }
                finally {
                    InMemoryRegistrationStore.this.lock.readLock().unlock();
                }
                for (Registration reg : allRegs) {
                    if (reg.isAlive()) continue;
                    Deregistration removedRegistration = InMemoryRegistrationStore.this.removeRegistration(reg.getId());
                    InMemoryRegistrationStore.this.expirationListener.registrationExpired(removedRegistration.getRegistration(), removedRegistration.getObservations());
                }
            }
            catch (Exception e) {
                InMemoryRegistrationStore.this.LOG.warn("Unexpected Exception while registration cleaning", (Throwable)e);
            }
        }
    }
}

