/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.registration;

import java.util.HashMap;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.response.DeregisterResponse;
import org.eclipse.leshan.core.response.RegisterResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.core.response.UpdateResponse;
import org.eclipse.leshan.server.registration.RegistrationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterResource
extends LwM2mCoapResource {
    private static final String QUERY_PARAM_ENDPOINT = "ep=";
    private static final String QUERY_PARAM_BINDING_MODE = "b=";
    private static final String QUERY_PARAM_LWM2M_VERSION = "lwm2m=";
    private static final String QUERY_PARAM_SMS = "sms=";
    private static final String QUERY_PARAM_LIFETIME = "lt=";
    private static final Logger LOG = LoggerFactory.getLogger(RegisterResource.class);
    public static final String RESOURCE_NAME = "rd";
    private final RegistrationHandler registrationHandler;

    public RegisterResource(RegistrationHandler registrationHandler) {
        super(RESOURCE_NAME);
        this.registrationHandler = registrationHandler;
        this.getAttributes().addResourceType("core.rd");
    }

    public void handlePOST(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        LOG.trace("POST received : {}", (Object)request);
        if (!CoAP.Type.CON.equals((Object)request.getType())) {
            this.handleInvalidRequest(exchange, "CON CoAP type expected");
            return;
        }
        List uri = exchange.getRequestOptions().getUriPath();
        if (uri == null || uri.size() == 0 || !RESOURCE_NAME.equals(uri.get(0))) {
            this.handleInvalidRequest(exchange, "Bad URI");
            return;
        }
        if (uri.size() == 1) {
            this.handleRegister(exchange, request);
            return;
        }
        if (uri.size() == 2) {
            this.handleUpdate(exchange, request, (String)uri.get(1));
            return;
        }
        this.handleInvalidRequest(exchange, "Bad URI");
    }

    public void handleDELETE(CoapExchange exchange) {
        LOG.trace("DELETE received : {}", (Object)exchange.advanced().getRequest());
        List uri = exchange.getRequestOptions().getUriPath();
        if (uri != null && uri.size() == 2 && RESOURCE_NAME.equals(uri.get(0))) {
            this.handleDeregister(exchange, (String)uri.get(1));
        } else {
            this.handleInvalidRequest(exchange, "Bad URI");
        }
    }

    protected void handleRegister(CoapExchange exchange, Request request) {
        Identity sender = this.extractIdentity(request.getSourceContext());
        String endpoint = null;
        Long lifetime = null;
        String smsNumber = null;
        String lwVersion = null;
        BindingMode binding = null;
        Link[] objectLinks = Link.parse((byte[])request.getPayload());
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_ENDPOINT)) {
                endpoint = param.substring(3);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_LIFETIME)) {
                lifetime = Long.valueOf(param.substring(3));
                continue;
            }
            if (param.startsWith(QUERY_PARAM_SMS)) {
                smsNumber = param.substring(4);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_LWM2M_VERSION)) {
                lwVersion = param.substring(6);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_BINDING_MODE)) {
                binding = BindingMode.valueOf((String)param.substring(2));
                continue;
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        RegisterRequest registerRequest = new RegisterRequest(endpoint, lifetime, lwVersion, binding, smsNumber, objectLinks, additionalParams);
        SendableResponse sendableResponse = this.registrationHandler.register(sender, registerRequest);
        RegisterResponse response = (RegisterResponse)sendableResponse.getResponse();
        if (response.getCode() == ResponseCode.CREATED) {
            exchange.setLocationPath("rd/" + response.getRegistrationID());
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        }
        sendableResponse.sent();
    }

    protected void handleUpdate(CoapExchange exchange, Request request, String registrationId) {
        UpdateRequest updateRequest;
        SendableResponse sendableResponse;
        UpdateResponse updateResponse;
        Identity sender = this.extractIdentity(request.getSourceContext());
        Long lifetime = null;
        String smsNumber = null;
        BindingMode binding = null;
        Link[] objectLinks = null;
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_LIFETIME)) {
                lifetime = Long.valueOf(param.substring(3));
                continue;
            }
            if (param.startsWith(QUERY_PARAM_SMS)) {
                smsNumber = param.substring(4);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_BINDING_MODE)) {
                binding = BindingMode.valueOf((String)param.substring(2));
                continue;
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        if (request.getPayload() != null && request.getPayload().length > 0) {
            objectLinks = Link.parse((byte[])request.getPayload());
        }
        if ((updateResponse = (UpdateResponse)(sendableResponse = this.registrationHandler.update(sender, updateRequest = new UpdateRequest(registrationId, lifetime, smsNumber, binding, objectLinks, additionalParams))).getResponse()).getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)updateResponse.getCode()), updateResponse.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)updateResponse.getCode()));
        }
        sendableResponse.sent();
    }

    protected void handleDeregister(CoapExchange exchange, String registrationId) {
        DeregisterRequest deregisterRequest;
        Identity sender = this.extractIdentity(exchange.advanced().getRequest().getSourceContext());
        SendableResponse sendableResponse = this.registrationHandler.deregister(sender, deregisterRequest = new DeregisterRequest(registrationId));
        DeregisterResponse deregisterResponse = (DeregisterResponse)sendableResponse.getResponse();
        if (deregisterResponse.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)deregisterResponse.getCode()), deregisterResponse.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)deregisterResponse.getCode()));
        }
        sendableResponse.sent();
    }

    public Resource getChild(String name) {
        return this;
    }
}

