/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.leshan.server.bootstrap.BootstrapFailureCause;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionAdapter;

public class OscoreBootstrapListener
extends BootstrapSessionAdapter {
    private final ConcurrentMap<InetSocketAddress, BootstrapSession> addrToSession = new ConcurrentHashMap<InetSocketAddress, BootstrapSession>();

    public void authorized(BootstrapSession session) {
        this.addrToSession.put(session.getIdentity().getPeerAddress(), session);
    }

    public void end(BootstrapSession session) {
        this.addrToSession.remove(session.getIdentity(), session);
    }

    public void failed(BootstrapSession session, BootstrapFailureCause cause) {
        this.addrToSession.remove(session.getIdentity(), session);
    }

    public BootstrapSession getSessionByAddr(InetSocketAddress addr) {
        return (BootstrapSession)this.addrToSession.get(addr);
    }
}

