/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.californium.CoapResponseCallback;
import org.eclipse.leshan.core.request.exception.ClientSleepingException;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.server.californium.request.CoapRequestSender;
import org.eclipse.leshan.server.queue.PresenceServiceImpl;
import org.eclipse.leshan.server.queue.QueueModeLwM2mRequestSender;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.request.LwM2mRequestSender;

public class CaliforniumQueueModeRequestSender
extends QueueModeLwM2mRequestSender
implements CoapRequestSender,
Destroyable {
    public CaliforniumQueueModeRequestSender(PresenceServiceImpl presenceService, LwM2mRequestSender delegatedSender) {
        super(presenceService, delegatedSender);
    }

    @Override
    public Response sendCoapRequest(Registration destination, Request coapRequest, long timeout) throws InterruptedException {
        if (!(this.delegatedSender instanceof CoapRequestSender)) {
            throw new UnsupportedOperationException("This sender does not support to send CoAP request");
        }
        CoapRequestSender sender = (CoapRequestSender)this.delegatedSender;
        if (!destination.usesQueueMode()) {
            return sender.sendCoapRequest(destination, coapRequest, timeout);
        }
        if (!this.presenceService.isClientAwake(destination)) {
            throw new ClientSleepingException("The destination client is sleeping, request cannot be sent.", new Object[0]);
        }
        Response response = sender.sendCoapRequest(destination, coapRequest, timeout);
        if (response != null) {
            this.presenceService.setAwake(destination);
        } else {
            this.presenceService.setSleeping(destination);
        }
        return response;
    }

    @Override
    public void sendCoapRequest(final Registration destination, Request coapRequest, long timeout, final CoapResponseCallback responseCallback, final ErrorCallback errorCallback) {
        if (!(this.delegatedSender instanceof CoapRequestSender)) {
            throw new UnsupportedOperationException("This sender does not support to send CoAP request");
        }
        CoapRequestSender sender = (CoapRequestSender)this.delegatedSender;
        if (!destination.usesQueueMode()) {
            sender.sendCoapRequest(destination, coapRequest, timeout, responseCallback, errorCallback);
            return;
        }
        if (!this.presenceService.isClientAwake(destination)) {
            throw new ClientSleepingException("The destination client is sleeping, request cannot be sent.", new Object[0]);
        }
        sender.sendCoapRequest(destination, coapRequest, timeout, new CoapResponseCallback(){

            public void onResponse(Response response) {
                CaliforniumQueueModeRequestSender.this.presenceService.setAwake(destination);
                responseCallback.onResponse(response);
            }
        }, new ErrorCallback(){

            public void onError(Exception e) {
                if (e instanceof TimeoutException) {
                    CaliforniumQueueModeRequestSender.this.presenceService.setSleeping(destination);
                }
                errorCallback.onError(e);
            }
        });
    }

    public void destroy() {
        if (this.delegatedSender instanceof Destroyable) {
            ((Destroyable)this.delegatedSender).destroy();
        }
    }
}

