/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.stack.ReliabilityLayerParameters;
import org.eclipse.leshan.server.request.LowerLayerConfig;

public class CoapRequestSetter
implements LowerLayerConfig {
    private final ReliabilityLayerParameters reliabilityLayerParameters;

    private CoapRequestSetter(ReliabilityLayerParameters reliabilityLayerParameters) {
        this.reliabilityLayerParameters = reliabilityLayerParameters;
    }

    public void apply(Object lowerRequest) {
        if (lowerRequest instanceof Request) {
            this.applySetting((Request)lowerRequest);
        }
    }

    protected void applySetting(Request coapRequest) {
        if (this.reliabilityLayerParameters != null) {
            coapRequest.setReliabilityLayerParameters(this.reliabilityLayerParameters);
        }
    }

    public static CoapRequestSetter reliabilitySetter(ReliabilityLayerParameters.Builder reliabilityParametersBuilder) {
        return CoapRequestSetter.builder().setReliabilityLayerParameters(reliabilityParametersBuilder.build()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ReliabilityLayerParameters reliabilityLayerParameters;

        private Builder() {
        }

        public Builder setReliabilityLayerParameters(ReliabilityLayerParameters reliabilityLayerParameters) {
            this.reliabilityLayerParameters = reliabilityLayerParameters;
            return this;
        }

        public CoapRequestSetter build() {
            return new CoapRequestSetter(this.reliabilityLayerParameters);
        }
    }
}

