/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.util.Collection;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationListener;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStoreListener;

public class OscoreContextCleaner
implements RegistrationListener,
SecurityStoreListener {
    private final OSCoreCtxDB oscoreCtxDB;

    public OscoreContextCleaner(OSCoreCtxDB oscoreCtxDB) {
        this.oscoreCtxDB = oscoreCtxDB;
    }

    public void registered(Registration registration, Registration previousReg, Collection<Observation> previousObsersations) {
    }

    public void updated(RegistrationUpdate update, Registration updatedReg, Registration previousReg) {
    }

    public void unregistered(Registration registration, Collection<Observation> observations, boolean expired, Registration newReg) {
        if (registration.getClientTransportData().getIdentity() instanceof OscoreIdentity) {
            this.removeContext(((OscoreIdentity)registration.getClientTransportData().getIdentity()).getRecipientId());
        }
    }

    public void securityInfoRemoved(boolean infosAreCompromised, SecurityInfo ... infos) {
        for (SecurityInfo securityInfo : infos) {
            if (!securityInfo.useOSCORE()) continue;
            this.removeContext(securityInfo.getOscoreSetting().getRecipientId());
        }
    }

    private void removeContext(byte[] rid) {
        OSCoreCtx context = this.oscoreCtxDB.getContext(rid);
        if (context != null) {
            this.oscoreCtxDB.removeContext(context);
        }
    }
}

