/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.server.bootstrap.BootstrapFailureCause;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionAdapter;

public class OscoreBootstrapListener
extends BootstrapSessionAdapter {
    private final ConcurrentMap<InetSocketAddress, BootstrapSession> addrToSession = new ConcurrentHashMap<InetSocketAddress, BootstrapSession>();

    public void authorized(BootstrapSession session) {
        LwM2mPeer client = session.getClientTransportData();
        if (client instanceof IpPeer) {
            this.addrToSession.put(((IpPeer)client).getSocketAddress(), session);
        }
    }

    public void end(BootstrapSession session) {
        LwM2mPeer client = session.getClientTransportData();
        if (client instanceof IpPeer) {
            this.addrToSession.remove(((IpPeer)client).getSocketAddress(), session);
        }
    }

    public void failed(BootstrapSession session, BootstrapFailureCause cause) {
        LwM2mPeer client = session.getClientTransportData();
        if (client instanceof IpPeer) {
            this.addrToSession.remove(((IpPeer)client).getSocketAddress(), session);
        }
    }

    public BootstrapSession getSessionByAddr(InetSocketAddress addr) {
        return (BootstrapSession)this.addrToSession.get(addr);
    }
}

