/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.endpoint.coap;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.leshan.core.californium.DefaultExceptionTranslator;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.DefaultCoapIdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.server.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.CaliforniumBootstrapServerEndpointFactory;
import org.eclipse.leshan.server.security.ServerSecurityInfo;

public class CoapBootstrapServerEndpointFactory
implements CaliforniumBootstrapServerEndpointFactory {
    protected final URI endpointUri;
    protected final String loggingTagPrefix;
    protected final Configuration configuration;
    protected final Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer;

    public static Protocol getSupportedProtocol() {
        return Protocol.COAP;
    }

    public static void applyDefaultValue(Configuration configuration) {
        configuration.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
    }

    public static List<Configuration.ModuleDefinitionsProvider> getModuleDefinitionsProviders() {
        return Arrays.asList(SystemConfig.DEFINITIONS, CoapConfig.DEFINITIONS, UdpConfig.DEFINITIONS);
    }

    public CoapBootstrapServerEndpointFactory(URI uri) {
        this(uri, null, null, null);
    }

    public CoapBootstrapServerEndpointFactory(URI uri, String loggingTagPrefix, Configuration configuration, Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer) {
        EndpointUriUtil.validateURI((URI)uri);
        this.endpointUri = uri;
        this.loggingTagPrefix = loggingTagPrefix == null ? "Bootstrap Server" : loggingTagPrefix;
        this.configuration = configuration;
        this.coapEndpointConfigInitializer = coapEndpointConfigInitializer;
    }

    @Override
    public Protocol getProtocol() {
        return CoapBootstrapServerEndpointFactory.getSupportedProtocol();
    }

    @Override
    public URI getUri() {
        return this.endpointUri;
    }

    @Override
    public String getEndpointDescription() {
        return "CoAP over UDP endpoint based on Californium library";
    }

    protected String getLoggingTag() {
        if (this.loggingTagPrefix != null) {
            return String.format("[%s-%s]", this.loggingTagPrefix, this.getUri().toString());
        }
        return String.format("[%s]", this.getUri().toString());
    }

    @Override
    public CoapEndpoint createCoapEndpoint(Configuration defaultConfiguration, ServerSecurityInfo serverSecurityInfo, LeshanBootstrapServer server) {
        Configuration configurationToUse = this.configuration == null ? defaultConfiguration : this.configuration;
        return this.createEndpointBuilder(EndpointUriUtil.getSocketAddr((URI)this.endpointUri), configurationToUse, server).build();
    }

    protected CoapEndpoint.Builder createEndpointBuilder(InetSocketAddress address, Configuration coapConfig, LeshanBootstrapServer server) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setConnector(this.createConnector(address, coapConfig));
        builder.setConfiguration(coapConfig);
        builder.setLoggingTag(this.getLoggingTag());
        if (this.coapEndpointConfigInitializer != null) {
            this.coapEndpointConfigInitializer.accept(builder);
        }
        return builder;
    }

    protected Connector createConnector(InetSocketAddress address, Configuration coapConfig) {
        return new UDPConnector(address, coapConfig);
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new DefaultCoapIdentityHandler();
    }

    @Override
    public ExceptionTranslator createExceptionTranslator() {
        return new DefaultExceptionTranslator();
    }
}

