/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.endpoint.coaps;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeTimeoutException;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.leshan.core.californium.DefaultExceptionTranslator;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.Lwm2mEndpointContextMatcher;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.PskIdentity;
import org.eclipse.leshan.core.peer.RpkIdentity;
import org.eclipse.leshan.core.peer.X509Identity;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.util.X509CertUtil;
import org.eclipse.leshan.server.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.LwM2mBootstrapPskStore;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.CaliforniumBootstrapServerEndpointFactory;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapsBootstrapServerEndpointFactory
implements CaliforniumBootstrapServerEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoapsBootstrapServerEndpointFactory.class);
    protected final URI endpointUri;
    protected final String loggingTagPrefix;
    protected final Configuration configuration;
    protected final Consumer<DtlsConnectorConfig.Builder> dtlsConnectorConfigInitializer;
    protected final Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer;

    public static Protocol getSupportedProtocol() {
        return Protocol.COAPS;
    }

    @Override
    public String getEndpointDescription() {
        return "CoAP over DTLS endpoint based on Californium/Scandium library";
    }

    public static void applyDefaultValue(Configuration configuration) {
        configuration.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
        configuration.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
    }

    public static List<Configuration.ModuleDefinitionsProvider> getModuleDefinitionsProviders() {
        return Arrays.asList(SystemConfig.DEFINITIONS, CoapConfig.DEFINITIONS, UdpConfig.DEFINITIONS, DtlsConfig.DEFINITIONS);
    }

    public CoapsBootstrapServerEndpointFactory(URI uri) {
        this(uri, null, null, null, null);
    }

    public CoapsBootstrapServerEndpointFactory(URI uri, String loggingTagPrefix, Configuration configuration, Consumer<DtlsConnectorConfig.Builder> dtlsConnectorConfigInitializer, Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer) {
        EndpointUriUtil.validateURI((URI)uri);
        this.endpointUri = uri;
        this.loggingTagPrefix = loggingTagPrefix == null ? "Bootstrap Server" : loggingTagPrefix;
        this.configuration = configuration;
        this.dtlsConnectorConfigInitializer = dtlsConnectorConfigInitializer;
        this.coapEndpointConfigInitializer = coapEndpointConfigInitializer;
    }

    @Override
    public Protocol getProtocol() {
        return CoapsBootstrapServerEndpointFactory.getSupportedProtocol();
    }

    @Override
    public URI getUri() {
        return this.endpointUri;
    }

    protected String getLoggingTag() {
        if (this.loggingTagPrefix != null) {
            return String.format("[%s-%s]", this.loggingTagPrefix, this.getUri().toString());
        }
        return String.format("[%s]", this.getUri().toString());
    }

    @Override
    public CoapEndpoint createCoapEndpoint(Configuration defaultConfiguration, ServerSecurityInfo serverSecurityInfo, LeshanBootstrapServer server) {
        DtlsConnectorConfig dtlsConfig;
        if (server.getSecurityStore() == null) {
            return null;
        }
        Configuration configurationToUse = this.configuration == null ? defaultConfiguration : this.configuration;
        DtlsConnectorConfig.Builder dtlsConfigBuilder = this.createDtlsConnectorConfigBuilder(configurationToUse);
        this.setUpDtlsConfig(dtlsConfigBuilder, EndpointUriUtil.getSocketAddr((URI)this.endpointUri), serverSecurityInfo, server);
        try {
            dtlsConfig = dtlsConfigBuilder.build();
        }
        catch (IllegalStateException e) {
            LOG.warn("Unable to create DTLS config for endpont {}.", (Object)this.endpointUri.toString(), (Object)e);
            return null;
        }
        CoapEndpoint endpoint = this.createEndpointBuilder(dtlsConfig, configurationToUse).build();
        return endpoint;
    }

    protected DtlsConnectorConfig.Builder createDtlsConnectorConfigBuilder(Configuration configuration) {
        DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder(configuration);
        if (this.dtlsConnectorConfigInitializer != null) {
            this.dtlsConnectorConfigInitializer.accept(builder);
        }
        return builder;
    }

    protected void setUpDtlsConfig(DtlsConnectorConfig.Builder dtlsConfigBuilder, InetSocketAddress address, ServerSecurityInfo serverSecurityInfo, LeshanBootstrapServer server) {
        List ciphers;
        DtlsConnectorConfig incompleteConfig = dtlsConfigBuilder.getIncompleteConfig();
        if (incompleteConfig.getAdvancedPskStore() != null) {
            LOG.warn("PskStore should be automatically set by Leshan. Using a custom implementation is not advised.");
        } else if (server.getSecurityStore() != null && ((ciphers = (List)incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_CIPHER_SUITES)) == null || CipherSuite.containsPskBasedCipherSuite((List)ciphers))) {
            dtlsConfigBuilder.setAdvancedPskStore((AdvancedPskStore)new LwM2mBootstrapPskStore(server.getSecurityStore()));
        }
        if (incompleteConfig.getAddress() == null) {
            dtlsConfigBuilder.setAddress(address);
        } else if (address != null && !address.equals(incompleteConfig.getAddress())) {
            throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for secure address: %s != %s", address, incompleteConfig.getAddress()));
        }
        if (incompleteConfig.getCertificateIdentityProvider() != null) {
            if (serverSecurityInfo.getPrivateKey() != null) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for private key", new Object[0]));
            }
            if (serverSecurityInfo.getPublicKey() != null) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for public key", new Object[0]));
            }
            if (serverSecurityInfo.getCertificateChain() != null) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for certificate chain", new Object[0]));
            }
        } else if (serverSecurityInfo.getPrivateKey() != null) {
            if (serverSecurityInfo.getCertificateChain() == null && serverSecurityInfo.getPublicKey() != null) {
                dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverSecurityInfo.getPrivateKey(), serverSecurityInfo.getPublicKey()));
            }
            if (serverSecurityInfo.getCertificateChain() != null && serverSecurityInfo.getCertificateChain().length > 0) {
                dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverSecurityInfo.getPrivateKey(), (Certificate[])serverSecurityInfo.getCertificateChain(), new CertificateType[]{CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY}));
            }
        }
        if (incompleteConfig.getAdvancedCertificateVerifier() != null) {
            if (serverSecurityInfo.getTrustedCertificates() != null) {
                throw new IllegalStateException("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder: if a AdvancedCertificateVerifier is set, trustedCertificates must not be set.");
            }
        } else if (incompleteConfig.getCertificateIdentityProvider() != null) {
            StaticNewAdvancedCertificateVerifier.Builder verifierBuilder = StaticNewAdvancedCertificateVerifier.builder();
            verifierBuilder.setTrustAllRPKs();
            if (serverSecurityInfo.getTrustedCertificates() != null) {
                verifierBuilder.setTrustedCertificates(serverSecurityInfo.getTrustedCertificates());
            }
            dtlsConfigBuilder.setAdvancedCertificateVerifier(verifierBuilder.build());
        }
    }

    protected CoapEndpoint.Builder createEndpointBuilder(DtlsConnectorConfig dtlsConfig, Configuration coapConfig) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setConnector(this.createConnector(dtlsConfig));
        builder.setConfiguration(coapConfig);
        builder.setLoggingTag(this.getLoggingTag());
        builder.setEndpointContextMatcher(this.createEndpointContextMatcher());
        if (this.coapEndpointConfigInitializer != null) {
            this.coapEndpointConfigInitializer.accept(builder);
        }
        return builder;
    }

    protected EndpointContextMatcher createEndpointContextMatcher() {
        return new Lwm2mEndpointContextMatcher();
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new IdentityHandler(){

            public LwM2mPeer getIdentity(Message receivedMessage) {
                EndpointContext context = receivedMessage.getSourceContext();
                InetSocketAddress peerAddress = context.getPeerAddress();
                Principal senderIdentity = context.getPeerIdentity();
                if (senderIdentity != null) {
                    if (senderIdentity instanceof PreSharedKeyIdentity) {
                        return new IpPeer(peerAddress, (LwM2mIdentity)new PskIdentity(((PreSharedKeyIdentity)senderIdentity).getIdentity()));
                    }
                    if (senderIdentity instanceof RawPublicKeyIdentity) {
                        PublicKey publicKey = ((RawPublicKeyIdentity)senderIdentity).getKey();
                        return new IpPeer(peerAddress, (LwM2mIdentity)new RpkIdentity(publicKey));
                    }
                    if (senderIdentity instanceof X500Principal || senderIdentity instanceof X509CertPath) {
                        String x509CommonName = X509CertUtil.extractCN((String)senderIdentity.getName());
                        return new IpPeer(peerAddress, (LwM2mIdentity)new X509Identity(x509CommonName));
                    }
                    throw new IllegalStateException(String.format("Unable to extract sender identity : unexpected type of Principal %s [%s]", senderIdentity.getClass(), senderIdentity.toString()));
                }
                return null;
            }

            public EndpointContext createEndpointContext(LwM2mPeer client, boolean allowConnectionInitiation) {
                Object peerIdentity = null;
                if (client.getIdentity() instanceof PskIdentity) {
                    peerIdentity = new PreSharedKeyIdentity(((PskIdentity)client.getIdentity()).getPskIdentity());
                } else if (client.getIdentity() instanceof RpkIdentity) {
                    peerIdentity = new RawPublicKeyIdentity(((RpkIdentity)client.getIdentity()).getPublicKey());
                } else if (client.getIdentity() instanceof X509Identity) {
                    peerIdentity = new X500Principal("CN=" + ((X509Identity)client.getIdentity()).getX509CommonName());
                } else {
                    throw new IllegalStateException(String.format("Unsupported Identity : %s", client.getIdentity()));
                }
                if (client instanceof IpPeer) {
                    IpPeer ipClient = (IpPeer)client;
                    if (peerIdentity != null && allowConnectionInitiation) {
                        return new MapBasedEndpointContext(ipClient.getSocketAddress(), (Principal)peerIdentity, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_HANDSHAKE_MODE, (Object)"auto"));
                    }
                    return new AddressEndpointContext(ipClient.getSocketAddress(), (Principal)peerIdentity);
                }
                throw new IllegalStateException(String.format("Unsupported peer : %s", client));
            }
        };
    }

    protected Connector createConnector(DtlsConnectorConfig dtlsConfig) {
        return new DTLSConnector(dtlsConfig);
    }

    @Override
    public ExceptionTranslator createExceptionTranslator() {
        return new DefaultExceptionTranslator(){

            public Exception translate(Request coapRequest, Throwable error) {
                if (error instanceof DtlsHandshakeTimeoutException) {
                    return new TimeoutException(TimeoutException.Type.DTLS_HANDSHAKE_TIMEOUT, error, "Request %s timeout : dtls handshake timeout", new Object[]{coapRequest.getURI()});
                }
                return super.translate(coapRequest, error);
            }
        };
    }
}

