/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.response.AbstractLwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.server.LeshanServer;
import org.eclipse.leshan.server.californium.RootResource;
import org.eclipse.leshan.server.californium.endpoint.CaliforniumServerEndpoint;
import org.eclipse.leshan.server.californium.endpoint.CaliforniumServerEndpointFactory;
import org.eclipse.leshan.server.californium.endpoint.ServerCoapMessageTranslator;
import org.eclipse.leshan.server.californium.endpoint.ServerProtocolProvider;
import org.eclipse.leshan.server.californium.endpoint.coap.CoapServerProtocolProvider;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpoint;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpointsProvider;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumServerEndpointsProvider
implements LwM2mServerEndpointsProvider {
    private final Logger LOG = LoggerFactory.getLogger(CaliforniumServerEndpointsProvider.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
    private final Configuration serverConfig;
    private final List<CaliforniumServerEndpointFactory> endpointsFactory;
    private final ServerCoapMessageTranslator messagetranslator = new ServerCoapMessageTranslator();
    private final List<CaliforniumServerEndpoint> endpoints;
    private CoapServer coapServer;

    public CaliforniumServerEndpointsProvider() {
        this(new Builder(new ServerProtocolProvider[0]).generateDefaultValue());
    }

    protected CaliforniumServerEndpointsProvider(Builder builder) {
        this.serverConfig = builder.serverConfiguration;
        this.endpointsFactory = builder.endpointsFactory;
        this.endpoints = new ArrayList<CaliforniumServerEndpoint>();
    }

    public CoapServer getCoapServer() {
        return this.coapServer;
    }

    public List<LwM2mServerEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public LwM2mServerEndpoint getEndpoint(URI uri) {
        for (CaliforniumServerEndpoint endpoint : this.endpoints) {
            if (!endpoint.getURI().equals(uri)) continue;
            return endpoint;
        }
        return null;
    }

    public void createEndpoints(UplinkRequestReceiver requestReceiver, final LwM2mNotificationReceiver notificatonReceiver, final ServerEndpointToolbox toolbox, ServerSecurityInfo serverSecurityInfo, final LeshanServer server) {
        this.coapServer = new CoapServer(this.serverConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource();
            }
        };
        IdentityHandlerProvider identityHandlerProvider = new IdentityHandlerProvider();
        for (CaliforniumServerEndpointFactory endpointFactory : this.endpointsFactory) {
            CoapEndpoint coapEndpoint = endpointFactory.createCoapEndpoint(this.serverConfig, serverSecurityInfo, notificatonReceiver, server);
            if (coapEndpoint == null) continue;
            final IdentityHandler identityHandler = endpointFactory.createIdentityHandler();
            identityHandlerProvider.addIdentityHandler((Endpoint)coapEndpoint, identityHandler);
            ExceptionTranslator exceptionTranslator = endpointFactory.createExceptionTranslator();
            CaliforniumServerEndpoint lwm2mEndpoint = new CaliforniumServerEndpoint(endpointFactory.getProtocol(), endpointFactory.getEndpointDescription(), coapEndpoint, this.messagetranslator, toolbox, notificatonReceiver, identityHandler, exceptionTranslator, this.executor);
            this.endpoints.add(lwm2mEndpoint);
            this.coapServer.addEndpoint((Endpoint)coapEndpoint);
            coapEndpoint.addNotificationListener(new NotificationListener(){

                public void onNotification(Request coapRequest, Response coapResponse) {
                    String regid = (String)coapRequest.getUserContext().get("leshan-regId");
                    Observation observation = server.getRegistrationStore().getObservation(regid, new ObservationIdentifier(coapResponse.getToken().getBytes()));
                    if (observation == null) {
                        CaliforniumServerEndpointsProvider.this.LOG.error("Unexpected error: Unable to find observation with token {} for registration {}", (Object)coapResponse.getToken(), (Object)regid);
                        return;
                    }
                    LwM2mPeer client = identityHandler.getIdentity((Message)coapResponse);
                    ClientProfile profile = toolbox.getProfileProvider().getProfile(client.getIdentity());
                    try {
                        AbstractLwM2mResponse response = CaliforniumServerEndpointsProvider.this.messagetranslator.createObservation(observation, coapResponse, toolbox, profile);
                        if (observation instanceof SingleObservation) {
                            notificatonReceiver.onNotification((SingleObservation)observation, client, profile, (ObserveResponse)response);
                        } else if (observation instanceof CompositeObservation) {
                            notificatonReceiver.onNotification((CompositeObservation)observation, client, profile, (ObserveCompositeResponse)response);
                        }
                    }
                    catch (Exception e) {
                        notificatonReceiver.onError(observation, client, profile, e);
                    }
                }
            });
        }
        List<Resource> resources = this.messagetranslator.createResources(requestReceiver, toolbox, identityHandlerProvider);
        this.coapServer.add(resources.toArray(new Resource[resources.size()]));
    }

    public void start() {
        this.coapServer.start();
    }

    public void stop() {
        this.coapServer.stop();
    }

    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.warn("Destroying RequestSender was interrupted.", (Throwable)e);
        }
        this.coapServer.destroy();
    }

    public static class Builder {
        private final List<ServerProtocolProvider> protocolProviders = new ArrayList<ServerProtocolProvider>();
        private Configuration serverConfiguration;
        private final List<CaliforniumServerEndpointFactory> endpointsFactory;

        public Builder(ServerProtocolProvider ... protocolProviders) {
            if (protocolProviders.length == 0) {
                this.protocolProviders.add(new CoapServerProtocolProvider());
            } else {
                this.protocolProviders.addAll(Arrays.asList(protocolProviders));
            }
            this.endpointsFactory = new ArrayList<CaliforniumServerEndpointFactory>();
        }

        public Configuration createDefaultConfiguration() {
            HashSet<Configuration.ModuleDefinitionsProvider> moduleProviders = new HashSet<Configuration.ModuleDefinitionsProvider>();
            for (ServerProtocolProvider protocolProvider : this.protocolProviders) {
                moduleProviders.addAll(protocolProvider.getModuleDefinitionsProviders());
            }
            Configuration configuration = new Configuration(moduleProviders.toArray(new Configuration.ModuleDefinitionsProvider[moduleProviders.size()]));
            for (ServerProtocolProvider protocolProvider : this.protocolProviders) {
                protocolProvider.applyDefaultValue(configuration);
            }
            return configuration;
        }

        public Builder setConfiguration(Configuration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public Builder setConfiguration(Consumer<Configuration> configurationSetter) {
            Configuration cfg = this.createDefaultConfiguration();
            configurationSetter.accept(cfg);
            this.serverConfiguration = cfg;
            return this;
        }

        public Builder addEndpoint(String uri) {
            return this.addEndpoint(EndpointUriUtil.createUri((String)uri));
        }

        public Builder addEndpoint(URI uri) {
            for (ServerProtocolProvider protocolProvider : this.protocolProviders) {
                if (!protocolProvider.getProtocol().getUriScheme().equals(uri.getScheme())) continue;
                this.endpointsFactory.add(protocolProvider.createDefaultEndpointFactory(uri));
            }
            return this;
        }

        public Builder addEndpoint(InetSocketAddress addr, Protocol protocol) {
            return this.addEndpoint(EndpointUriUtil.createUri((String)protocol.getUriScheme(), (InetSocketAddress)addr));
        }

        public Builder addEndpoint(CaliforniumServerEndpointFactory endpointFactory) {
            this.endpointsFactory.add(endpointFactory);
            return this;
        }

        protected Builder generateDefaultValue() {
            if (this.serverConfiguration == null) {
                this.serverConfiguration = this.createDefaultConfiguration();
            }
            if (this.endpointsFactory.isEmpty()) {
                for (ServerProtocolProvider protocolProvider : this.protocolProviders) {
                    this.endpointsFactory.add(protocolProvider.createDefaultEndpointFactory(protocolProvider.getDefaultUri(this.serverConfiguration)));
                }
            }
            return this;
        }

        public CaliforniumServerEndpointsProvider build() {
            this.generateDefaultValue();
            return new CaliforniumServerEndpointsProvider(this);
        }
    }
}

