/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.observation;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.server.californium.observation.ObservationSerDes;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.registration.RegistrationStore;

public class LwM2mObservationStore
implements ObservationStore {
    private final RegistrationStore registrationStore;
    private final LwM2mNotificationReceiver notificationListener;
    private final ObservationSerDes observationSerDes;

    public LwM2mObservationStore(RegistrationStore registrationStore, LwM2mNotificationReceiver notificationListener, ObservationSerDes observationSerDes) {
        this.registrationStore = registrationStore;
        this.notificationListener = notificationListener;
        this.observationSerDes = observationSerDes;
    }

    public Observation putIfAbsent(Token token, Observation obs) {
        org.eclipse.leshan.core.observation.Observation lwm2mObservation = this.buildLwM2mObservation(obs);
        Collection removed = this.registrationStore.addObservation(lwm2mObservation.getRegistrationId(), lwm2mObservation, true);
        Observation previousObservation = null;
        if (removed != null && !removed.isEmpty()) {
            for (org.eclipse.leshan.core.observation.Observation observation : removed) {
                if (!Arrays.equals(observation.getId().getBytes(), token.getBytes())) continue;
                previousObservation = this.buildCoapObservation(observation);
                break;
            }
        }
        for (org.eclipse.leshan.core.observation.Observation observation : removed) {
            this.notificationListener.cancelled(observation);
        }
        return previousObservation;
    }

    public Observation put(Token token, Observation obs) {
        org.eclipse.leshan.core.observation.Observation lwm2mObservation = this.buildLwM2mObservation(obs);
        Collection removed = this.registrationStore.addObservation(lwm2mObservation.getRegistrationId(), this.buildLwM2mObservation(obs), false);
        Observation previousObservation = null;
        if (removed != null && !removed.isEmpty()) {
            for (org.eclipse.leshan.core.observation.Observation observation : removed) {
                if (!Arrays.equals(observation.getId().getBytes(), token.getBytes())) continue;
                previousObservation = this.buildCoapObservation(observation);
                break;
            }
        }
        for (org.eclipse.leshan.core.observation.Observation observation : removed) {
            this.notificationListener.cancelled(observation);
        }
        return previousObservation;
    }

    public void remove(Token token) {
        org.eclipse.leshan.core.observation.Observation removedObservation;
        org.eclipse.leshan.core.observation.Observation observation = this.registrationStore.getObservation(new ObservationIdentifier(token.getBytes()));
        if (observation != null && (removedObservation = this.registrationStore.removeObservation(observation.getRegistrationId(), new ObservationIdentifier(token.getBytes()))) != null) {
            this.notificationListener.cancelled(removedObservation);
        }
    }

    public Observation get(Token token) {
        org.eclipse.leshan.core.observation.Observation observation = this.registrationStore.getObservation(new ObservationIdentifier(token.getBytes()));
        if (observation == null) {
            return null;
        }
        return this.buildCoapObservation(observation);
    }

    public void setContext(Token token, EndpointContext endpointContext) {
    }

    public void setExecutor(ScheduledExecutorService executor) {
    }

    public void start() {
    }

    public void stop() {
    }

    private org.eclipse.leshan.core.observation.Observation buildLwM2mObservation(Observation observation) {
        String obs = this.observationSerDes.serialize(observation);
        return ObserveUtil.createLwM2mObservation((Observation)observation, (String)obs);
    }

    private Observation buildCoapObservation(org.eclipse.leshan.core.observation.Observation observation) {
        String serializedObservation = ObserveUtil.extractSerializedObservation((org.eclipse.leshan.core.observation.Observation)observation);
        if (serializedObservation == null) {
            return null;
        }
        return this.observationSerDes.deserialize(serializedObservation);
    }
}

