/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.registration;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.LinkParseException;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.response.DeregisterResponse;
import org.eclipse.leshan.core.response.RegisterResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.core.response.UpdateResponse;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterResource
extends LwM2mCoapResource {
    private static final String QUERY_PARAM_ENDPOINT = "ep=";
    private static final String QUERY_PARAM_BINDING_MODE = "b=";
    private static final String QUERY_PARAM_LWM2M_VERSION = "lwm2m=";
    private static final String QUERY_PARAM_SMS = "sms=";
    private static final String QUERY_PARAM_LIFETIME = "lt=";
    private static final String QUERY_PARAM_QUEUEMMODE = "Q";
    private static final Logger LOG = LoggerFactory.getLogger(RegisterResource.class);
    public static final String RESOURCE_NAME = "rd";
    private final UplinkRequestReceiver receiver;
    private final LinkParser linkParser;

    public RegisterResource(UplinkRequestReceiver receiver, LinkParser linkParser, IdentityHandlerProvider identityHandlerProvider) {
        super(RESOURCE_NAME, identityHandlerProvider);
        this.receiver = receiver;
        this.linkParser = linkParser;
        this.getAttributes().addResourceType("core.rd");
    }

    public void handlePOST(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        LOG.trace("POST received : {}", (Object)request);
        if (!CoAP.Type.CON.equals((Object)request.getType())) {
            this.handleInvalidRequest(exchange, "CON CoAP type expected");
            return;
        }
        List uri = exchange.getRequestOptions().getUriPath();
        if (uri == null || uri.size() == 0 || !RESOURCE_NAME.equals(uri.get(0))) {
            this.handleInvalidRequest(exchange, "Bad URI");
            return;
        }
        if (uri.size() == 1) {
            this.handleRegister(exchange, request);
            return;
        }
        if (uri.size() == 2) {
            this.handleUpdate(exchange, request, (String)uri.get(1));
            return;
        }
        this.handleInvalidRequest(exchange, "Bad URI");
    }

    public void handleDELETE(CoapExchange exchange) {
        LOG.trace("DELETE received : {}", (Object)exchange.advanced().getRequest());
        List uri = exchange.getRequestOptions().getUriPath();
        if (uri != null && uri.size() == 2 && RESOURCE_NAME.equals(uri.get(0))) {
            this.handleDeregister(exchange, (String)uri.get(1));
        } else {
            this.handleInvalidRequest(exchange, "Bad URI");
        }
    }

    protected void handleRegister(CoapExchange exchange, Request request) {
        Link[] objectLinks;
        IpPeer sender = this.getForeignPeerIdentity(exchange.advanced(), (Message)request);
        String endpoint = null;
        Long lifetime = null;
        String smsNumber = null;
        String lwVersion = null;
        EnumSet binding = null;
        Boolean queueMode = null;
        try {
            objectLinks = this.linkParser.parseCoreLinkFormat(request.getPayload());
        }
        catch (LinkParseException e) {
            this.handleInvalidRequest(exchange.advanced(), e.getMessage() != null ? e.getMessage() : "Invalid Links", e);
            return;
        }
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_ENDPOINT)) {
                endpoint = param.substring(3);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_LIFETIME)) {
                lifetime = Long.valueOf(param.substring(3));
                continue;
            }
            if (param.startsWith(QUERY_PARAM_SMS)) {
                smsNumber = param.substring(4);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_LWM2M_VERSION)) {
                lwVersion = param.substring(6);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_BINDING_MODE)) {
                binding = BindingMode.parse((String)param.substring(2));
                continue;
            }
            if (param.equals(QUERY_PARAM_QUEUEMMODE)) {
                queueMode = true;
                continue;
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        Request coapRequest = exchange.advanced().getRequest();
        RegisterRequest registerRequest = new RegisterRequest(endpoint, lifetime, lwVersion, binding, queueMode, smsNumber, objectLinks, additionalParams, (Object)coapRequest);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)registerRequest, exchange.advanced().getEndpoint().getUri());
        RegisterResponse response = (RegisterResponse)sendableResponse.getResponse();
        if (response.getCode() == ResponseCode.CREATED) {
            exchange.setLocationPath("rd/" + response.getRegistrationID());
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        }
        sendableResponse.sent();
    }

    protected void handleUpdate(CoapExchange exchange, Request request, String registrationId) {
        Request coapRequest;
        UpdateRequest updateRequest;
        SendableResponse sendableResponse;
        UpdateResponse updateResponse;
        IpPeer sender = this.getForeignPeerIdentity(exchange.advanced(), (Message)request);
        Long lifetime = null;
        String smsNumber = null;
        EnumSet binding = null;
        Link[] objectLinks = null;
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_LIFETIME)) {
                lifetime = Long.valueOf(param.substring(3));
                continue;
            }
            if (param.startsWith(QUERY_PARAM_SMS)) {
                smsNumber = param.substring(4);
                continue;
            }
            if (param.startsWith(QUERY_PARAM_BINDING_MODE)) {
                binding = BindingMode.parse((String)param.substring(2));
                continue;
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        if (request.getPayload() != null && request.getPayload().length > 0) {
            try {
                objectLinks = this.linkParser.parseCoreLinkFormat(request.getPayload());
            }
            catch (LinkParseException e) {
                this.handleInvalidRequest(exchange.advanced(), e.getMessage() != null ? e.getMessage() : "Invalid Links", e);
                return;
            }
        }
        if ((updateResponse = (UpdateResponse)(sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)(updateRequest = new UpdateRequest(registrationId, lifetime, smsNumber, binding, objectLinks, additionalParams, (Object)(coapRequest = exchange.advanced().getRequest()))), exchange.advanced().getEndpoint().getUri())).getResponse()).getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)updateResponse.getCode()), updateResponse.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)updateResponse.getCode()));
        }
        sendableResponse.sent();
    }

    protected void handleDeregister(CoapExchange exchange, String registrationId) {
        DeregisterRequest deregisterRequest;
        Request coapRequest = exchange.advanced().getRequest();
        IpPeer sender = this.getForeignPeerIdentity(exchange.advanced(), (Message)coapRequest);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)(deregisterRequest = new DeregisterRequest(registrationId, (Object)coapRequest)), exchange.advanced().getEndpoint().getUri());
        DeregisterResponse deregisterResponse = (DeregisterResponse)sendableResponse.getResponse();
        if (deregisterResponse.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)deregisterResponse.getCode()), deregisterResponse.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)deregisterResponse.getCode()));
        }
        sendableResponse.sent();
    }

    public Resource getChild(String name) {
        return this;
    }
}

