/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.security.Principal;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Filter;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.leshan.core.security.certificate.util.X509CertUtil;
import org.eclipse.leshan.server.security.SecurityInfo;

public class ConnectionCleaner {
    private final DTLSConnector connector;

    public ConnectionCleaner(DTLSConnector connector) {
        this.connector = connector;
    }

    public void cleanConnectionFor(final SecurityInfo ... infos) {
        this.connector.startTerminateConnectionsForPrincipal((Filter)new Filter<Principal>(){

            public boolean accept(Principal principal) {
                if (principal != null) {
                    for (SecurityInfo info : infos) {
                        String x509CommonName;
                        if (info == null) continue;
                        if (info.usePSK() && principal instanceof PreSharedKeyIdentity) {
                            String identity = ((PreSharedKeyIdentity)principal).getIdentity();
                            if (!info.getPskIdentity().equals(identity)) continue;
                            return true;
                        }
                        if (info.useRPK() && principal instanceof RawPublicKeyIdentity) {
                            PublicKey publicKey = ((RawPublicKeyIdentity)principal).getKey();
                            if (!info.getRawPublicKey().equals(publicKey)) continue;
                            return true;
                        }
                        if ((!info.useX509Cert() || !(principal instanceof X500Principal)) && !(principal instanceof X509CertPath) || !(x509CommonName = X509CertUtil.extractCN((String)principal.getName())).equals(info.getEndpoint())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

