/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.util.HashMap;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.response.BootstrapResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.bootstrap.request.BootstrapUplinkRequestReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapResource
extends LwM2mCoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapResource.class);
    private static final String QUERY_PARAM_ENDPOINT = "ep=";
    private static final String QUERY_PARAM_PREFERRED_CONTENT_FORMAT = "pct=";
    private final BootstrapUplinkRequestReceiver receiver;

    public BootstrapResource(BootstrapUplinkRequestReceiver receiver, IdentityHandlerProvider identityHandlerProvider) {
        super("bs", identityHandlerProvider);
        this.receiver = receiver;
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest;
        Request request = exchange.advanced().getRequest();
        LOG.trace("POST received : {}", (Object)request);
        if (!CoAP.Type.CON.equals((Object)request.getType())) {
            this.handleInvalidRequest(exchange, "CON CoAP type expected");
            return;
        }
        String endpoint = null;
        ContentFormat preferredContentFomart = null;
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_ENDPOINT)) {
                endpoint = param.substring(QUERY_PARAM_ENDPOINT.length());
                continue;
            }
            if (param.startsWith(QUERY_PARAM_PREFERRED_CONTENT_FORMAT)) {
                try {
                    preferredContentFomart = ContentFormat.fromCode((String)param.substring(QUERY_PARAM_PREFERRED_CONTENT_FORMAT.length()));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.handleInvalidRequest(exchange.advanced(), "Invalid preferre content format (pct) query param : must be a number", e);
                    return;
                }
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        IpPeer clientIdentity = this.getForeignPeerIdentity(exchange.advanced(), (Message)request);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)clientIdentity, (UplinkRequest)new BootstrapRequest(endpoint, preferredContentFomart, additionalParams, (Object)(coapRequest = exchange.advanced().getRequest())), exchange.advanced().getEndpoint().getUri());
        BootstrapResponse response = (BootstrapResponse)sendableResponse.getResponse();
        if (response.isSuccess()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        }
        sendableResponse.sent();
    }
}

