/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreParameters;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreStore;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.californium.bootstrap.OscoreBootstrapListener;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mBootstrapOscoreStore
implements OscoreStore {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mBootstrapOscoreStore.class);
    private final BootstrapSecurityStore securityStore;
    private final OscoreBootstrapListener sessionHolder;

    public LwM2mBootstrapOscoreStore(BootstrapSecurityStore securityStore, OscoreBootstrapListener sessionHolder) {
        Validate.notNull((Object)securityStore);
        Validate.notNull((Object)((Object)sessionHolder));
        this.securityStore = securityStore;
        this.sessionHolder = sessionHolder;
    }

    public OscoreParameters getOscoreParameters(byte[] recipientID) {
        OscoreIdentity oscoreIdentity = new OscoreIdentity(recipientID);
        SecurityInfo securityInfo = this.securityStore.getByOscoreIdentity(oscoreIdentity);
        if (securityInfo == null || !securityInfo.useOSCORE()) {
            return null;
        }
        try {
            return new OscoreParameters(securityInfo.getOscoreSetting().getSenderId(), securityInfo.getOscoreSetting().getRecipientId(), securityInfo.getOscoreSetting().getMasterSecret(), AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)securityInfo.getOscoreSetting().getAeadAlgorithm().getValue())), AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)securityInfo.getOscoreSetting().getHkdfAlgorithm().getValue())), securityInfo.getOscoreSetting().getMasterSalt().length == 0 ? null : securityInfo.getOscoreSetting().getMasterSalt());
        }
        catch (CoseException e) {
            LOG.error("Unable to create OscoreParameters from OoscoreSetting %s", (Object)securityInfo.getOscoreSetting(), (Object)e);
            return null;
        }
    }

    public byte[] getRecipientId(String uri) {
        try {
            URI foreignPeerUri = new URI(uri);
            InetSocketAddress foreignPeerAddress = new InetSocketAddress(foreignPeerUri.getHost(), foreignPeerUri.getPort());
            BootstrapSession session = this.sessionHolder.getSessionByAddr(foreignPeerAddress);
            LwM2mIdentity identity = session.getClientTransportData().getIdentity();
            if (identity instanceof OscoreIdentity) {
                return ((OscoreIdentity)identity).getRecipientId();
            }
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException e) {
            LOG.error("Unable to extract InetScocketAddress from uri %s", (Object)uri, (Object)e);
            return null;
        }
        return null;
    }
}

