/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint;

import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.TimestampedLwM2mNodes;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.AbstractLwM2mResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.californium.registration.RegisterResource;
import org.eclipse.leshan.server.californium.request.CoapRequestBuilder;
import org.eclipse.leshan.server.californium.request.LwM2mResponseBuilder;
import org.eclipse.leshan.server.californium.send.SendResource;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCoapMessageTranslator {
    private final Logger LOG = LoggerFactory.getLogger(ServerCoapMessageTranslator.class);

    public Request createCoapRequest(ClientProfile clientProfile, DownlinkRequest<? extends LwM2mResponse> lwm2mRequest, ServerEndpointToolbox toolbox, IdentityHandler identityHandler) {
        CoapRequestBuilder builder = new CoapRequestBuilder(clientProfile.getTransportData(), clientProfile.getRootPath(), clientProfile.getRegistrationId(), clientProfile.getEndpoint(), clientProfile.getModel(), toolbox.getEncoder(), clientProfile.canInitiateConnection(), null, identityHandler);
        lwm2mRequest.accept((DownlinkRequestVisitor)builder);
        return builder.getRequest();
    }

    public <T extends LwM2mResponse> T createLwM2mResponse(ClientProfile clientProfile, DownlinkRequest<T> lwm2mRequest, Request coapRequest, Response coapResponse, ServerEndpointToolbox toolbox) {
        LwM2mResponseBuilder builder = new LwM2mResponseBuilder(coapRequest, coapResponse, clientProfile.getEndpoint(), clientProfile.getModel(), toolbox.getDecoder(), toolbox.getLinkParser());
        lwm2mRequest.accept(builder);
        return builder.getResponse();
    }

    public List<Resource> createResources(UplinkRequestReceiver receiver, ServerEndpointToolbox toolbox, IdentityHandlerProvider identityHandlerProvider) {
        return Arrays.asList(new Resource[]{new RegisterResource(receiver, (LinkParser)toolbox.getLinkParser(), identityHandlerProvider), new SendResource(receiver, toolbox.getDecoder(), toolbox.getProfileProvider(), identityHandlerProvider)});
    }

    public AbstractLwM2mResponse createObserveResponse(Observation observation, Response coapResponse, ServerEndpointToolbox toolbox, ClientProfile profile) {
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        try {
            ResponseCode responseCode = ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)coapResponse.getCode());
            if (observation instanceof SingleObservation) {
                SingleObservation singleObservation = (SingleObservation)observation;
                if (responseCode.isError()) {
                    return new ObserveResponse(responseCode, null, null, null, null, coapResponse.getPayloadString(), (Object)coapResponse);
                }
                List timestampedNodes = toolbox.getDecoder().decodeTimestampedData(coapResponse.getPayload(), contentFormat, singleObservation.getPath(), profile.getModel());
                if (timestampedNodes.size() == 1 && !((TimestampedLwM2mNode)timestampedNodes.get(0)).isTimestamped()) {
                    return new ObserveResponse(responseCode, ((TimestampedLwM2mNode)timestampedNodes.get(0)).getNode(), null, null, singleObservation, null, (Object)coapResponse);
                }
                return new ObserveResponse(responseCode, null, null, timestampedNodes, singleObservation, null, (Object)coapResponse);
            }
            if (observation instanceof CompositeObservation) {
                CompositeObservation compositeObservation = (CompositeObservation)observation;
                if (responseCode.isError()) {
                    return new ObserveCompositeResponse(responseCode, null, null, null, coapResponse.getPayloadString(), (Object)coapResponse);
                }
                TimestampedLwM2mNodes timestampedNodes = toolbox.getDecoder().decodeTimestampedNodes(coapResponse.getPayload(), contentFormat, compositeObservation.getPaths(), profile.getModel());
                if (timestampedNodes.getTimestamps().size() == 1 && timestampedNodes.getTimestamps().iterator().next() == null) {
                    return new ObserveCompositeResponse(responseCode, timestampedNodes.getNodes(), null, compositeObservation, null, (Object)coapResponse);
                }
                return new ObserveCompositeResponse(responseCode, null, timestampedNodes, compositeObservation, null, (Object)coapResponse);
            }
            throw new IllegalStateException("observation must be a CompositeObservation or a SingleObservation but was " + observation == null ? null : observation.getClass().getSimpleName());
        }
        catch (CodecException e) {
            if (this.LOG.isDebugEnabled()) {
                byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
                this.LOG.debug(String.format("Unable to decode notification payload [%s] of observation [%s] ", Hex.encodeHexString((byte[])payload), observation), (Throwable)e);
            }
            throw new InvalidResponseException((Throwable)e, "Unable to decode notification payload  of observation [%s] ", new Object[]{observation});
        }
    }
}

