/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint.coap;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.core.network.serialization.UdpDataSerializer;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.leshan.core.californium.DefaultExceptionTranslator;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.DefaultCoapIdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.server.LeshanServer;
import org.eclipse.leshan.server.californium.endpoint.CaliforniumServerEndpointFactory;
import org.eclipse.leshan.server.californium.observation.LwM2mObservationStore;
import org.eclipse.leshan.server.californium.observation.ObservationSerDes;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.security.ServerSecurityInfo;

public class CoapServerEndpointFactory
implements CaliforniumServerEndpointFactory {
    protected final URI endpointUri;
    protected final String loggingTagPrefix;
    protected final Configuration configuration;
    protected final Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer;

    public static Protocol getSupportedProtocol() {
        return Protocol.COAP;
    }

    public static void applyDefaultValue(Configuration configuration) {
        configuration.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
    }

    public static List<Configuration.ModuleDefinitionsProvider> getModuleDefinitionsProviders() {
        return Arrays.asList(SystemConfig.DEFINITIONS, CoapConfig.DEFINITIONS, UdpConfig.DEFINITIONS);
    }

    public CoapServerEndpointFactory(URI uri) {
        this(uri, null, null, null);
    }

    public CoapServerEndpointFactory(URI uri, String loggingTagPrefix, Configuration configuration, Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer) {
        EndpointUriUtil.validateURI((URI)uri);
        this.endpointUri = uri;
        this.loggingTagPrefix = loggingTagPrefix == null ? "LWM2M Server" : loggingTagPrefix;
        this.configuration = configuration;
        this.coapEndpointConfigInitializer = coapEndpointConfigInitializer;
    }

    @Override
    public Protocol getProtocol() {
        return CoapServerEndpointFactory.getSupportedProtocol();
    }

    @Override
    public String getEndpointDescription() {
        return "CoAP over UDP endpoint based on Californium library";
    }

    @Override
    public URI getUri() {
        return this.endpointUri;
    }

    protected String getLoggingTag() {
        if (this.loggingTagPrefix != null) {
            return String.format("[%s-%s]", this.loggingTagPrefix, this.getUri().toString());
        }
        return String.format("[%s]", this.getUri().toString());
    }

    @Override
    public CoapEndpoint createCoapEndpoint(Configuration defaultConfiguration, ServerSecurityInfo serverSecurityInfo, LwM2mNotificationReceiver notificationReceiver, LeshanServer server) {
        Configuration configurationToUse = this.configuration == null ? defaultConfiguration : this.configuration;
        return this.createEndpointBuilder(EndpointUriUtil.getSocketAddr((URI)this.endpointUri), configurationToUse, notificationReceiver, server).build();
    }

    protected CoapEndpoint.Builder createEndpointBuilder(InetSocketAddress address, Configuration coapConfig, LwM2mNotificationReceiver notificationReceiver, LeshanServer server) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setConnector(this.createConnector(address, coapConfig));
        builder.setConfiguration(coapConfig);
        builder.setLoggingTag(this.getLoggingTag());
        builder.setObservationStore((ObservationStore)new LwM2mObservationStore(server.getRegistrationStore(), notificationReceiver, new ObservationSerDes((DataParser)new UdpDataParser(), (DataSerializer)new UdpDataSerializer())));
        if (this.coapEndpointConfigInitializer != null) {
            this.coapEndpointConfigInitializer.accept(builder);
        }
        return builder;
    }

    protected Connector createConnector(InetSocketAddress address, Configuration coapConfig) {
        return new UDPConnector(address, coapConfig);
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new DefaultCoapIdentityHandler();
    }

    @Override
    public ExceptionTranslator createExceptionTranslator() {
        return new DefaultExceptionTranslator();
    }
}

