/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.observation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.californium.observation.EndpointContextSerDes;

public class ObservationSerDes {
    private final DataSerializer serializer;
    private final DataParser parser;

    public ObservationSerDes(DataParser parser, DataSerializer serializer) {
        this.parser = parser;
        this.serializer = serializer;
    }

    public String serialize(Observation obs) {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        o.put("request", Hex.encodeHexString((byte[])this.serializer.serializeRequest((Request)obs.getRequest()).bytes));
        if (obs.getContext() != null) {
            o.set("peer", (JsonNode)EndpointContextSerDes.serialize(obs.getContext()));
        } else {
            o.set("peer", (JsonNode)EndpointContextSerDes.serialize(obs.getRequest().getDestinationContext()));
        }
        if (obs.getRequest().getUserContext() != null) {
            ObjectNode ctxObject = JsonNodeFactory.instance.objectNode();
            for (Map.Entry e : obs.getRequest().getUserContext().entrySet()) {
                ctxObject.put((String)e.getKey(), (String)e.getValue());
            }
            o.set("context", (JsonNode)ctxObject);
        }
        return o.toString();
    }

    public Observation deserialize(String data) {
        try {
            JsonNode v = new ObjectMapper().readTree(data);
            EndpointContext endpointContext = EndpointContextSerDes.deserialize(v.get("peer"));
            byte[] req = Hex.decodeHex((char[])v.get("request").asText().toCharArray());
            Request request = (Request)this.parser.parseMessage(req);
            request.setDestinationContext(endpointContext);
            JsonNode ctxValue = v.get("context");
            if (ctxValue != null) {
                HashMap<String, String> context = new HashMap<String, String>();
                Iterator it = ctxValue.fieldNames();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    context.put(name, ctxValue.get(name).asText());
                }
                request.setUserContext(context);
            }
            return new Observation(request, endpointContext);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Unable to deserialize Observation %s", data), e);
        }
    }
}

