/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.link.LinkParseException;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLink;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLinkParser;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.LwM2mRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.CancelCompositeObservationResponse;
import org.eclipse.leshan.core.response.CancelObservationResponse;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mResponseBuilder<T extends LwM2mResponse>
implements DownlinkRequestVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mResponseBuilder.class);
    private LwM2mResponse lwM2mresponse;
    private final Request coapRequest;
    private final Response coapResponse;
    private final String clientEndpoint;
    private final LwM2mModel model;
    private final LwM2mDecoder decoder;
    private final LwM2mLinkParser linkParser;

    public LwM2mResponseBuilder(Request coapRequest, Response coapResponse, String clientEndpoint, LwM2mModel model, LwM2mDecoder decoder, LwM2mLinkParser linkParser) {
        this.coapRequest = coapRequest;
        this.coapResponse = coapResponse;
        this.clientEndpoint = clientEndpoint;
        this.model = model;
        this.decoder = decoder;
        this.linkParser = linkParser;
    }

    public void visit(ReadRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ReadResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new ReadResponse(ResponseCode.CONTENT, null, timestampedNode, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DiscoverRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new DiscoverResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mLink[] links;
            if (40 != this.coapResponse.getOptions().getContentFormat()) {
                throw new InvalidResponseException("Client [%s] returned unexpected content format [%s] for [%s]", new Object[]{this.clientEndpoint, this.coapResponse.getOptions().getContentFormat(), request});
            }
            try {
                String rootpath = null;
                links = this.linkParser.parseLwM2mLinkFromCoreLinkFormat(this.coapResponse.getPayload(), rootpath);
            }
            catch (LinkParseException e) {
                throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, this.clientEndpoint});
            }
            this.lwM2mresponse = new DiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new WriteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteAttributesRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new WriteAttributesResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteAttributesResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ExecuteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ExecuteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new ExecuteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CreateRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new CreateResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.CREATED) {
            this.lwM2mresponse = new CreateResponse(ResponseCode.CREATED, this.coapResponse.getOptions().getLocationPathCount() == 0 ? null : this.coapResponse.getOptions().getLocationPathString(), null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DeleteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new DeleteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = new DeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ObserveRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            SingleObservation observation = null;
            if (this.coapResponse.getOptions().hasObserve()) {
                if (this.coapRequest.getTokenBytes() == null) {
                    this.coapRequest.setToken(this.coapResponse.getTokenBytes());
                }
                observation = ObserveUtil.createLwM2mObservation((Request)this.coapRequest);
            }
            this.lwM2mresponse = new ObserveResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, timestampedNode, null, observation, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CancelObservationRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new CancelObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new CancelObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, timestampedNode, null, null, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ReadCompositeRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ReadCompositeResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new ReadCompositeResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ObserveCompositeRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new ObserveCompositeResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            CompositeObservation observation = null;
            if (this.coapResponse.getOptions().hasObserve()) {
                observation = ObserveUtil.createLwM2mCompositeObservation((Request)this.coapRequest);
            }
            this.lwM2mresponse = new ObserveCompositeResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), content, null, observation, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CancelCompositeObservationRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new CancelCompositeObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new CancelCompositeObservationResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), content, null, null, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteCompositeRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new WriteCompositeResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteCompositeResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDiscoverRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapDiscoverResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mLink[] links;
            if (40 != this.coapResponse.getOptions().getContentFormat()) {
                throw new InvalidResponseException("Client [%s] returned unexpected content format [%s] for [%s]", new Object[]{this.clientEndpoint, this.coapResponse.getOptions().getContentFormat(), request});
            }
            try {
                links = this.linkParser.parseLwM2mLinkFromCoreLinkFormat(this.coapResponse.getPayload(), null);
            }
            catch (LinkParseException e) {
                throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, this.clientEndpoint});
            }
            this.lwM2mresponse = new BootstrapDiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapWriteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapReadRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapReadResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new BootstrapReadResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDeleteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapFinishRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    private boolean isResponseCodeContent() {
        return this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT;
    }

    private boolean isResponseCodeChanged() {
        return this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED;
    }

    private LwM2mNode decodeCoapResponse(LwM2mPath path, Response coapResponse, LwM2mRequest<?> request, String endpoint) {
        try {
            return this.decoder.decode(coapResponse.getPayload(), this.getContentFormat(coapResponse), path, this.model);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private Map<LwM2mPath, LwM2mNode> decodeCompositeCoapResponse(List<LwM2mPath> paths, Response coapResponse, LwM2mRequest<?> request, String endpoint) {
        try {
            return this.decoder.decodeNodes(coapResponse.getPayload(), this.getContentFormat(coapResponse), paths, this.model);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private TimestampedLwM2mNode decodeCoapTimestampedResponse(LwM2mPath path, Response coapResponse, LwM2mRequest<?> request, String endpoint) {
        List timestampedNodes = null;
        try {
            timestampedNodes = this.decoder.decodeTimestampedData(coapResponse.getPayload(), this.getContentFormat(coapResponse), path, this.model);
            if (timestampedNodes.size() != 1) {
                throw new InvalidResponseException("Unable to decode response payload of request [%s] from client [%s] : should receive only 1 timestamped node but received %s", new Object[]{request, endpoint, timestampedNodes.size()});
            }
            return (TimestampedLwM2mNode)timestampedNodes.get(0);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private ContentFormat getContentFormat(Response coapResponse) {
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        return contentFormat;
    }

    private void handleCodecException(CodecException e, LwM2mRequest<?> request, Response coapResponse, String endpoint) {
        if (LOG.isDebugEnabled()) {
            byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
            LOG.debug(String.format("Unable to decode response payload of request [%s] from client [%s] [payload:%s]", request, endpoint, Hex.encodeHexString((byte[])payload)));
        }
        throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, endpoint});
    }

    public T getResponse() {
        return (T)this.lwM2mresponse;
    }

    private void handleUnexpectedResponseCode(String clientEndpoint, LwM2mRequest<?> request, Response coapResponse) {
        throw new InvalidResponseException("Client [%s] returned unexpected response code [%s] for [%s]", new Object[]{clientEndpoint, coapResponse.getCode(), request});
    }
}

