/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.Startable;
import org.eclipse.leshan.core.Stoppable;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.bootstrap.BootstrapHandler;
import org.eclipse.leshan.server.bootstrap.BootstrapHandlerFactory;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionDispatcher;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionListener;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.LwM2mBootstrapRequestSender;
import org.eclipse.leshan.server.californium.RootResource;
import org.eclipse.leshan.server.californium.bootstrap.BootstrapResource;
import org.eclipse.leshan.server.californium.bootstrap.CaliforniumLwM2mBootstrapRequestSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanBootstrapServer {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanBootstrapServer.class);
    private final CoapAPI coapApi;
    private final CoapServer coapServer;
    private final CoapEndpoint unsecuredEndpoint;
    private final CoapEndpoint securedEndpoint;
    private final BootstrapSessionDispatcher dispatcher = new BootstrapSessionDispatcher();
    private final LwM2mBootstrapRequestSender requestSender;
    private final LinkParser linkParser;

    public LeshanBootstrapServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, BootstrapSessionManager bsSessionManager, BootstrapHandlerFactory bsHandlerFactory, Configuration coapConfig, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkParser linkParser) {
        this.linkParser = linkParser;
        Validate.notNull((Object)bsSessionManager, (String)"session manager must not be null");
        Validate.notNull((Object)bsHandlerFactory, (String)"BootstrapHandler factory must not be null");
        Validate.notNull((Object)coapConfig, (String)"coapConfig must not be null");
        this.coapApi = new CoapAPI();
        this.coapServer = this.createCoapServer(coapConfig);
        this.unsecuredEndpoint = unsecuredEndpoint;
        if (unsecuredEndpoint != null) {
            this.coapServer.addEndpoint((Endpoint)unsecuredEndpoint);
        }
        this.securedEndpoint = securedEndpoint;
        if (securedEndpoint != null) {
            this.coapServer.addEndpoint((Endpoint)securedEndpoint);
        }
        this.requestSender = this.createRequestSender((Endpoint)securedEndpoint, (Endpoint)unsecuredEndpoint, encoder, decoder);
        CoapResource bsResource = this.createBootstrapResource(bsHandlerFactory.create(this.requestSender, bsSessionManager, (BootstrapSessionListener)this.dispatcher));
        this.coapServer.add(new Resource[]{bsResource});
    }

    protected CoapServer createCoapServer(Configuration coapConfig) {
        return new CoapServer(coapConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource();
            }
        };
    }

    protected LwM2mBootstrapRequestSender createRequestSender(Endpoint securedEndpoint, Endpoint unsecuredEndpoint, LwM2mEncoder encoder, LwM2mDecoder decoder) {
        return new CaliforniumLwM2mBootstrapRequestSender(securedEndpoint, unsecuredEndpoint, encoder, decoder, this.linkParser);
    }

    protected CoapResource createBootstrapResource(BootstrapHandler handler) {
        return new BootstrapResource(handler);
    }

    public void start() {
        if (this.requestSender instanceof Startable) {
            ((Startable)this.requestSender).start();
        }
        this.coapServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("Bootstrap server started at {} {}", (Object)(this.getUnsecuredAddress() == null ? "" : "coap://" + this.getUnsecuredAddress()), (Object)(this.getSecuredAddress() == null ? "" : "coaps://" + this.getSecuredAddress()));
        }
    }

    public void stop() {
        this.coapServer.stop();
        if (this.requestSender instanceof Stoppable) {
            ((Stoppable)this.requestSender).stop();
        }
        LOG.info("Bootstrap server stopped.");
    }

    public void destroy() {
        this.coapServer.destroy();
        if (this.requestSender instanceof Destroyable) {
            ((Destroyable)this.requestSender).destroy();
        } else if (this.requestSender instanceof Stoppable) {
            ((Stoppable)this.requestSender).stop();
        }
        LOG.info("Bootstrap server destroyed.");
    }

    public InetSocketAddress getUnsecuredAddress() {
        if (this.unsecuredEndpoint != null) {
            return this.unsecuredEndpoint.getAddress();
        }
        return null;
    }

    public InetSocketAddress getSecuredAddress() {
        if (this.securedEndpoint != null) {
            return this.securedEndpoint.getAddress();
        }
        return null;
    }

    public void addListener(BootstrapSessionListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(BootstrapSessionListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public CoapAPI coap() {
        return this.coapApi;
    }

    public class CoapAPI {
        public CoapServer getServer() {
            return LeshanBootstrapServer.this.coapServer;
        }

        public CoapEndpoint getSecuredEndpoint() {
            return LeshanBootstrapServer.this.securedEndpoint;
        }

        public CoapEndpoint getUnsecuredEndpoint() {
            return LeshanBootstrapServer.this.unsecuredEndpoint;
        }
    }
}

