/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.util.Arrays;
import java.util.Random;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

public class RedisLock {
    private static final Random RND = new Random();

    public static byte[] acquire(Jedis j, byte[] lockKey) {
        long start = System.currentTimeMillis();
        byte[] randomLockValue = new byte[10];
        RND.nextBytes(randomLockValue);
        while (!"OK".equals(j.set(lockKey, randomLockValue, SetParams.setParams().nx().px(500L)))) {
            if (System.currentTimeMillis() - start > 5000L) {
                throw new IllegalStateException("Could not acquire a lock from redis");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return randomLockValue;
    }

    public static void release(Jedis j, byte[] lockKey, byte[] lockValue) {
        if (lockValue != null && Arrays.equals(j.get(lockKey), lockValue)) {
            j.del(lockKey);
        }
    }
}

