/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.core.observe.ObservationStoreException;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.Destroyable;
import org.eclipse.leshan.server.Startable;
import org.eclipse.leshan.server.Stoppable;
import org.eclipse.leshan.server.californium.observation.ObserveUtil;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.redis.RedisLock;
import org.eclipse.leshan.server.redis.serialization.ObservationSerDes;
import org.eclipse.leshan.server.redis.serialization.RegistrationSerDes;
import org.eclipse.leshan.server.registration.Deregistration;
import org.eclipse.leshan.server.registration.ExpirationListener;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.registration.UpdatedRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.util.Pool;

public class RedisRegistrationStore
implements CaliforniumRegistrationStore,
Startable,
Stoppable,
Destroyable {
    public static final long DEFAULT_CLEAN_PERIOD = 60L;
    public static final int DEFAULT_CLEAN_LIMIT = 500;
    public static final long DEFAULT_GRACE_PERIOD = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisRegistrationStore.class);
    private static final String REG_EP = "REG:EP:";
    private static final String REG_EP_REGID_IDX = "EP:REGID:";
    private static final String REG_EP_ADDR_IDX = "EP:ADDR:";
    private static final String LOCK_EP = "LOCK:EP:";
    private static final byte[] OBS_TKN = "OBS:TKN:".getBytes(StandardCharsets.UTF_8);
    private static final String OBS_TKNS_REGID_IDX = "TKNS:REGID:";
    private static final byte[] EXP_EP = "EXP:EP".getBytes(StandardCharsets.UTF_8);
    private final Pool<Jedis> pool;
    private ExpirationListener expirationListener;
    private final ScheduledExecutorService schedExecutor;
    private ScheduledFuture<?> cleanerTask;
    private boolean started = false;
    private final long cleanPeriod;
    private final int cleanLimit;
    private final long gracePeriod;

    public RedisRegistrationStore(Pool<Jedis> p) {
        this(p, 60L, 0L, 500);
    }

    public RedisRegistrationStore(Pool<Jedis> p, long cleanPeriodInSec, long lifetimeGracePeriodInSec, int cleanLimit) {
        this(p, Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(String.format("RedisRegistrationStore Cleaner (%ds)", cleanPeriodInSec))), cleanPeriodInSec, lifetimeGracePeriodInSec, cleanLimit);
    }

    public RedisRegistrationStore(Pool<Jedis> p, ScheduledExecutorService schedExecutor, long cleanPeriodInSec, long lifetimeGracePeriodInSec, int cleanLimit) {
        this.pool = p;
        this.schedExecutor = schedExecutor;
        this.cleanPeriod = cleanPeriodInSec;
        this.cleanLimit = cleanLimit;
        this.gracePeriod = lifetimeGracePeriodInSec;
    }

    private byte[] toKey(byte[] prefix, byte[] key) {
        byte[] result = new byte[prefix.length + key.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(key, 0, result, prefix.length, key.length);
        return result;
    }

    private byte[] toKey(String prefix, String registrationID) {
        return (prefix + registrationID).getBytes();
    }

    private byte[] toLockKey(String endpoint) {
        return this.toKey(LOCK_EP, endpoint);
    }

    private byte[] toLockKey(byte[] endpoint) {
        return this.toKey(LOCK_EP.getBytes(StandardCharsets.UTF_8), endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deregistration addRegistration(Registration registration) {
        Throwable throwable = null;
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] lockKey;
            byte[] lockValue;
            block21: {
                Deregistration deregistration;
                lockValue = null;
                lockKey = this.toLockKey(registration.getEndpoint());
                try {
                    lockValue = RedisLock.acquire(j, lockKey);
                    byte[] k = this.toEndpointKey(registration.getEndpoint());
                    byte[] old = j.getSet(k, this.serializeReg(registration));
                    byte[] regid_idx = this.toRegIdKey(registration.getId());
                    j.set(regid_idx, registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
                    byte[] addr_idx = this.toRegAddrKey(registration.getSocketAddress());
                    j.set(addr_idx, registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
                    this.addOrUpdateExpiration(j, registration);
                    if (old == null) break block21;
                    Registration oldRegistration = this.deserializeReg(old);
                    if (!registration.getId().equals(oldRegistration.getId())) {
                        j.del(this.toRegIdKey(oldRegistration.getId()));
                    }
                    if (!oldRegistration.getSocketAddress().equals(registration.getSocketAddress())) {
                        this.removeAddrIndex(j, oldRegistration);
                    }
                    Collection<org.eclipse.leshan.core.observation.Observation> obsRemoved = this.unsafeRemoveAllObservations(j, oldRegistration.getId());
                    deregistration = new Deregistration(oldRegistration, obsRemoved);
                }
                catch (Throwable throwable2) {
                    try {
                        RedisLock.release(j, lockKey, lockValue);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                RedisLock.release(j, lockKey, lockValue);
                return deregistration;
            }
            Deregistration deregistration = null;
            RedisLock.release(j, lockKey, lockValue);
            return deregistration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatedRegistration updateRegistration(RegistrationUpdate update) {
        Throwable throwable = null;
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data;
            byte[] lockKey;
            byte[] lockValue;
            block24: {
                UpdatedRegistration updatedRegistration;
                byte[] ep = j.get(this.toRegIdKey(update.getRegistrationId()));
                if (ep == null) {
                    UpdatedRegistration updatedRegistration2 = null;
                    return updatedRegistration2;
                }
                lockValue = null;
                lockKey = this.toLockKey(ep);
                try {
                    lockValue = RedisLock.acquire(j, lockKey);
                    data = j.get(this.toEndpointKey(ep));
                    if (data != null) break block24;
                    updatedRegistration = null;
                }
                catch (Throwable throwable2) {
                    try {
                        RedisLock.release(j, lockKey, lockValue);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                RedisLock.release(j, lockKey, lockValue);
                return updatedRegistration;
            }
            Registration r = this.deserializeReg(data);
            Registration updatedRegistration = update.update(r);
            j.set(this.toEndpointKey(updatedRegistration.getEndpoint()), this.serializeReg(updatedRegistration));
            this.addOrUpdateExpiration(j, updatedRegistration);
            byte[] addr_idx = this.toRegAddrKey(updatedRegistration.getSocketAddress());
            j.set(addr_idx, updatedRegistration.getEndpoint().getBytes(StandardCharsets.UTF_8));
            if (!r.getSocketAddress().equals(updatedRegistration.getSocketAddress())) {
                this.removeAddrIndex(j, r);
            }
            UpdatedRegistration updatedRegistration3 = new UpdatedRegistration(r, updatedRegistration);
            RedisLock.release(j, lockKey, lockValue);
            return updatedRegistration3;
        }
    }

    public Registration getRegistration(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Registration registration = this.getRegistration(j, registrationId);
            return registration;
        }
    }

    public Registration getRegistrationByEndpoint(String endpoint) {
        Validate.notNull((Object)endpoint);
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get(this.toEndpointKey(endpoint));
            if (data == null) {
                Registration registration = null;
                return registration;
            }
            Registration registration = this.deserializeReg(data);
            return registration;
        }
    }

    public Registration getRegistrationByAdress(InetSocketAddress address) {
        Validate.notNull((Object)address);
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] ep = j.get(this.toRegAddrKey(address));
            if (ep == null) {
                Registration registration = null;
                return registration;
            }
            byte[] data = j.get(this.toEndpointKey(ep));
            if (data == null) {
                Registration registration = null;
                return registration;
            }
            Registration registration = this.deserializeReg(data);
            return registration;
        }
    }

    public Iterator<Registration> getAllRegistrations() {
        return new RedisIterator(this.pool, new ScanParams().match("REG:EP:*").count(Integer.valueOf(100)));
    }

    public Deregistration removeRegistration(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Deregistration deregistration = this.removeRegistration(j, registrationId, false);
            return deregistration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deregistration removeRegistration(Jedis j, String registrationId, boolean removeOnlyIfNotAlive) {
        byte[] ep = j.get(this.toRegIdKey(registrationId));
        if (ep == null) {
            return null;
        }
        byte[] lockValue = null;
        byte[] lockKey = this.toLockKey(ep);
        try {
            long nbRemoved;
            lockValue = RedisLock.acquire(j, lockKey);
            byte[] data = j.get(this.toEndpointKey(ep));
            if (data == null) {
                Deregistration deregistration = null;
                return deregistration;
            }
            Registration r = this.deserializeReg(data);
            if (!(removeOnlyIfNotAlive && r.isAlive(this.gracePeriod) || (nbRemoved = j.del(this.toRegIdKey(r.getId())).longValue()) <= 0L)) {
                j.del(this.toEndpointKey(r.getEndpoint()));
                Collection<org.eclipse.leshan.core.observation.Observation> obsRemoved = this.unsafeRemoveAllObservations(j, r.getId());
                this.removeAddrIndex(j, r);
                this.removeExpiration(j, r);
                Deregistration deregistration = new Deregistration(r, obsRemoved);
                return deregistration;
            }
            Deregistration deregistration = null;
            return deregistration;
        }
        finally {
            RedisLock.release(j, lockKey, lockValue);
        }
    }

    private void removeAddrIndex(Jedis j, Registration registration) {
        byte[] regAddrKey = this.toRegAddrKey(registration.getSocketAddress());
        j.watch((byte[][])new byte[][]{regAddrKey});
        byte[] epFromAddr = j.get(regAddrKey);
        if (Arrays.equals(epFromAddr, registration.getEndpoint().getBytes(StandardCharsets.UTF_8))) {
            Transaction transaction = j.multi();
            transaction.del(regAddrKey);
            transaction.exec();
        } else {
            j.unwatch();
        }
    }

    private void addOrUpdateExpiration(Jedis j, Registration registration) {
        j.zadd(EXP_EP, (double)registration.getExpirationTimeStamp(this.gracePeriod), registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
    }

    private void removeExpiration(Jedis j, Registration registration) {
        j.zrem(EXP_EP, (byte[][])new byte[][]{registration.getEndpoint().getBytes(StandardCharsets.UTF_8)});
    }

    private byte[] toRegIdKey(String registrationId) {
        return this.toKey(REG_EP_REGID_IDX, registrationId);
    }

    private byte[] toRegAddrKey(InetSocketAddress addr) {
        return this.toKey(REG_EP_ADDR_IDX, addr.getAddress().toString() + ":" + addr.getPort());
    }

    private byte[] toEndpointKey(String endpoint) {
        return this.toKey(REG_EP, endpoint);
    }

    private byte[] toEndpointKey(byte[] endpoint) {
        return this.toKey(REG_EP.getBytes(StandardCharsets.UTF_8), endpoint);
    }

    private byte[] serializeReg(Registration registration) {
        return RegistrationSerDes.bSerialize(registration);
    }

    private Registration deserializeReg(byte[] data) {
        return RegistrationSerDes.deserialize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.eclipse.leshan.core.observation.Observation> addObservation(String registrationId, org.eclipse.leshan.core.observation.Observation observation) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> removed = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] ep = j.get(this.toRegIdKey(registrationId));
            if (ep == null) {
                Collection<org.eclipse.leshan.core.observation.Observation> collection = null;
                return collection;
            }
            byte[] lockValue = null;
            byte[] lockKey = this.toLockKey(ep);
            try {
                lockValue = RedisLock.acquire(j, lockKey);
                for (org.eclipse.leshan.core.observation.Observation obs : this.getObservations(j, registrationId)) {
                    if (!observation.getPath().equals((Object)obs.getPath()) || Arrays.equals(observation.getId(), obs.getId())) continue;
                    removed.add(obs);
                    this.unsafeRemoveObservation(j, registrationId, obs.getId());
                }
            }
            finally {
                RedisLock.release(j, lockKey, lockValue);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.leshan.core.observation.Observation removeObservation(String registrationId, byte[] observationId) {
        Throwable throwable = null;
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] lockKey;
            byte[] lockValue;
            block23: {
                org.eclipse.leshan.core.observation.Observation observation;
                byte[] ep = j.get(this.toRegIdKey(registrationId));
                if (ep == null) {
                    org.eclipse.leshan.core.observation.Observation observation2 = null;
                    return observation2;
                }
                lockValue = null;
                lockKey = this.toLockKey(ep);
                try {
                    lockValue = RedisLock.acquire(j, lockKey);
                    org.eclipse.leshan.core.observation.Observation observation3 = this.build(this.get(new Token(observationId)));
                    if (observation3 == null || !registrationId.equals(observation3.getRegistrationId())) break block23;
                    this.unsafeRemoveObservation(j, registrationId, observationId);
                    observation = observation3;
                }
                catch (Throwable throwable2) {
                    try {
                        RedisLock.release(j, lockKey, lockValue);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                RedisLock.release(j, lockKey, lockValue);
                return observation;
            }
            org.eclipse.leshan.core.observation.Observation observation = null;
            RedisLock.release(j, lockKey, lockValue);
            return observation;
        }
    }

    public org.eclipse.leshan.core.observation.Observation getObservation(String registrationId, byte[] observationId) {
        return this.build(this.get(new Token(observationId)));
    }

    public Collection<org.eclipse.leshan.core.observation.Observation> getObservations(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Collection<org.eclipse.leshan.core.observation.Observation> collection = this.getObservations(j, registrationId);
            return collection;
        }
    }

    private Collection<org.eclipse.leshan.core.observation.Observation> getObservations(Jedis j, String registrationId) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> result = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        for (byte[] token : j.lrange(this.toKey(OBS_TKNS_REGID_IDX, registrationId), 0L, -1L)) {
            byte[] obs = j.get(this.toKey(OBS_TKN, token));
            if (obs == null) continue;
            result.add(this.build(this.deserializeObs(obs)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.eclipse.leshan.core.observation.Observation> removeObservations(String registrationId) {
        Throwable throwable = null;
        try (Jedis j = (Jedis)this.pool.getResource();){
            Collection<org.eclipse.leshan.core.observation.Observation> collection;
            Registration registration = this.getRegistration(j, registrationId);
            if (registration == null) {
                List<org.eclipse.leshan.core.observation.Observation> list = Collections.emptyList();
                return list;
            }
            String endpoint = registration.getEndpoint();
            byte[] lockValue = null;
            byte[] lockKey = this.toKey(LOCK_EP, endpoint);
            try {
                lockValue = RedisLock.acquire(j, lockKey);
                collection = this.unsafeRemoveAllObservations(j, registrationId);
            }
            catch (Throwable throwable2) {
                try {
                    RedisLock.release(j, lockKey, lockValue);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            RedisLock.release(j, lockKey, lockValue);
            return collection;
        }
    }

    public Observation putIfAbsent(Token token, Observation obs) throws ObservationStoreException {
        return this.add(token, obs, true);
    }

    public Observation put(Token token, Observation obs) throws ObservationStoreException {
        return this.add(token, obs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Observation add(Token token, Observation obs, boolean ifAbsent) throws ObservationStoreException {
        String endpoint = ObserveUtil.validateCoapObservation((Observation)obs);
        Observation previousObservation = null;
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] lockValue = null;
            byte[] lockKey = this.toKey(LOCK_EP, endpoint);
            try {
                lockValue = RedisLock.acquire(j, lockKey);
                String registrationId = ObserveUtil.extractRegistrationId((Observation)obs);
                if (!j.exists(this.toRegIdKey(registrationId)).booleanValue()) {
                    throw new ObservationStoreException("no registration for this Id");
                }
                byte[] key = this.toKey(OBS_TKN, obs.getRequest().getToken().getBytes());
                byte[] serializeObs = this.serializeObs(obs);
                byte[] previousValue = null;
                if (ifAbsent) {
                    previousValue = j.get(key);
                    if (previousValue != null && previousValue.length != 0) {
                        Observation observation = this.deserializeObs(previousValue);
                        return observation;
                    }
                    j.set(key, serializeObs);
                } else {
                    previousValue = j.getSet(key, serializeObs);
                }
                j.lpush(this.toKey(OBS_TKNS_REGID_IDX, registrationId), (byte[][])new byte[][]{obs.getRequest().getToken().getBytes()});
                if (previousValue == null) return previousObservation;
                if (previousValue.length == 0) return previousObservation;
                previousObservation = this.deserializeObs(previousValue);
                LOG.warn("Token collision ? observation from request [{}] will be replaced by observation from request [{}] ", (Object)previousObservation.getRequest(), (Object)obs.getRequest());
                return previousObservation;
            }
            finally {
                RedisLock.release(j, lockKey, lockValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Token token) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] tokenKey = this.toKey(OBS_TKN, token.getBytes());
            byte[] serializedObs = j.get(tokenKey);
            if (serializedObs == null) {
                return;
            }
            Observation obs = this.deserializeObs(serializedObs);
            String registrationId = ObserveUtil.extractRegistrationId((Observation)obs);
            Registration registration = this.getRegistration(j, registrationId);
            if (registration == null) {
                LOG.warn("Unable to remove observation {}, registration {} does not exist anymore", (Object)obs.getRequest(), (Object)registrationId);
                return;
            }
            String endpoint = registration.getEndpoint();
            byte[] lockValue = null;
            byte[] lockKey = this.toKey(LOCK_EP, endpoint);
            try {
                lockValue = RedisLock.acquire(j, lockKey);
                this.unsafeRemoveObservation(j, registrationId, token.getBytes());
            }
            finally {
                RedisLock.release(j, lockKey, lockValue);
            }
        }
    }

    public Observation get(Token token) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] obs = j.get(this.toKey(OBS_TKN, token.getBytes()));
            if (obs == null) {
                Observation observation = null;
                return observation;
            }
            Observation observation = this.deserializeObs(obs);
            return observation;
        }
    }

    private Registration getRegistration(Jedis j, String registrationId) {
        byte[] ep = j.get(this.toRegIdKey(registrationId));
        if (ep == null) {
            return null;
        }
        byte[] data = j.get(this.toEndpointKey(ep));
        if (data == null) {
            return null;
        }
        return this.deserializeReg(data);
    }

    private void unsafeRemoveObservation(Jedis j, String registrationId, byte[] observationId) {
        if (j.del(this.toKey(OBS_TKN, observationId)) > 0L) {
            j.lrem(this.toKey(OBS_TKNS_REGID_IDX, registrationId), 0L, observationId);
        }
    }

    private Collection<org.eclipse.leshan.core.observation.Observation> unsafeRemoveAllObservations(Jedis j, String registrationId) {
        ArrayList<org.eclipse.leshan.core.observation.Observation> removed = new ArrayList<org.eclipse.leshan.core.observation.Observation>();
        byte[] regIdKey = this.toKey(OBS_TKNS_REGID_IDX, registrationId);
        for (byte[] token : j.lrange(regIdKey, 0L, -1L)) {
            byte[] obs = j.get(this.toKey(OBS_TKN, token));
            if (obs != null) {
                removed.add(this.build(this.deserializeObs(obs)));
            }
            j.del(this.toKey(OBS_TKN, token));
        }
        j.del(regIdKey);
        return removed;
    }

    public void setContext(Token token, EndpointContext correlationContext) {
    }

    private byte[] serializeObs(Observation obs) {
        return ObservationSerDes.serialize(obs);
    }

    private Observation deserializeObs(byte[] data) {
        return ObservationSerDes.deserialize(data);
    }

    private org.eclipse.leshan.core.observation.Observation build(Observation cfObs) {
        if (cfObs == null) {
            return null;
        }
        return ObserveUtil.createLwM2mObservation((Request)cfObs.getRequest());
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.cleanerTask = this.schedExecutor.scheduleAtFixedRate(new Cleaner(), this.cleanPeriod, this.cleanPeriod, TimeUnit.SECONDS);
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (this.cleanerTask != null) {
                this.cleanerTask.cancel(false);
                this.cleanerTask = null;
            }
        }
    }

    public synchronized void destroy() {
        this.started = false;
        this.schedExecutor.shutdownNow();
        try {
            this.schedExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Destroying RedisRegistrationStore was interrupted.", (Throwable)e);
        }
    }

    public void setExpirationListener(ExpirationListener listener) {
        this.expirationListener = listener;
    }

    public void setExecutor(ScheduledExecutorService executor) {
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            try (Jedis j = (Jedis)RedisRegistrationStore.this.pool.getResource();){
                Set endpointsExpired = j.zrangeByScore(EXP_EP, Double.NEGATIVE_INFINITY, (double)System.currentTimeMillis(), 0, RedisRegistrationStore.this.cleanLimit);
                for (byte[] endpoint : endpointsExpired) {
                    Deregistration dereg;
                    Registration r = RedisRegistrationStore.this.deserializeReg(j.get(RedisRegistrationStore.this.toEndpointKey(endpoint)));
                    if (r.isAlive(RedisRegistrationStore.this.gracePeriod) || (dereg = RedisRegistrationStore.this.removeRegistration(j, r.getId(), true)) == null) continue;
                    RedisRegistrationStore.this.expirationListener.registrationExpired(dereg.getRegistration(), dereg.getObservations());
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected Exception while registration cleaning", (Throwable)e);
            }
        }
    }

    protected class RedisIterator
    implements Iterator<Registration> {
        private Pool<Jedis> pool;
        private ScanParams scanParams;
        private String cursor;
        private List<Registration> scanResult;

        public RedisIterator(Pool<Jedis> p, ScanParams scanParams) {
            this.pool = p;
            this.scanParams = scanParams;
            this.scanNext("0");
        }

        private void scanNext(String cursor) {
            try (Jedis j = (Jedis)this.pool.getResource();){
                ScanResult sr;
                do {
                    sr = j.scan(cursor.getBytes(), this.scanParams);
                    this.scanResult = new ArrayList<Registration>();
                    if (sr.getResult() == null || sr.getResult().isEmpty()) continue;
                    for (byte[] value : j.mget((byte[][])sr.getResult().toArray((T[])new byte[0][]))) {
                        this.scanResult.add(RedisRegistrationStore.this.deserializeReg(value));
                    }
                } while (!"0".equals(cursor = sr.getCursor()) && this.scanResult.isEmpty());
                this.cursor = cursor;
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.scanResult.isEmpty()) {
                return true;
            }
            if ("0".equals(this.cursor)) {
                return false;
            }
            this.scanNext(this.cursor);
            return !this.scanResult.isEmpty();
        }

        @Override
        public Registration next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.scanResult.remove(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

