/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.server.redis.serialization.IdentitySerDes;
import org.eclipse.leshan.server.registration.Registration;

public class RegistrationSerDes {
    public static JsonObject jSerialize(Registration r) {
        JsonObject o = Json.object();
        o.add("regDate", r.getRegistrationDate().getTime());
        o.add("identity", (JsonValue)IdentitySerDes.serialize(r.getIdentity()));
        o.add("lt", r.getLifeTimeInSec().longValue());
        if (r.getSmsNumber() != null) {
            o.add("sms", r.getSmsNumber());
        }
        o.add("ver", r.getLwM2mVersion());
        o.add("bnd", r.getBindingMode().name());
        o.add("ep", r.getEndpoint());
        o.add("regId", r.getId());
        JsonArray links = new JsonArray();
        for (Link l : r.getObjectLinks()) {
            JsonObject ol = Json.object();
            ol.add("url", l.getUrl());
            JsonObject at = Json.object();
            for (Map.Entry e : l.getAttributes().entrySet()) {
                if (e.getValue() == null) {
                    at.add((String)e.getKey(), Json.NULL);
                    continue;
                }
                at.add((String)e.getKey(), ((String)e.getValue()).toString());
            }
            ol.add("at", (JsonValue)at);
            links.add((JsonValue)ol);
        }
        o.add("objLink", (JsonValue)links);
        JsonObject addAttr = Json.object();
        for (Map.Entry e : r.getAdditionalRegistrationAttributes().entrySet()) {
            addAttr.add((String)e.getKey(), (String)e.getValue());
        }
        o.add("addAttr", (JsonValue)addAttr);
        o.add("root", r.getRootPath());
        o.add("lastUp", r.getLastUpdate().getTime());
        return o;
    }

    public static String sSerialize(Registration r) {
        return RegistrationSerDes.jSerialize(r).toString();
    }

    public static byte[] bSerialize(Registration r) {
        return RegistrationSerDes.jSerialize(r).toString().getBytes();
    }

    public static Registration deserialize(JsonObject jObj) {
        Registration.Builder b = new Registration.Builder(jObj.getString("regId", null), jObj.getString("ep", null), IdentitySerDes.deserialize(jObj.get("identity").asObject()));
        b.bindingMode(BindingMode.valueOf((String)jObj.getString("bnd", null)));
        b.lastUpdate(new Date(jObj.getLong("lastUp", 0L)));
        b.lifeTimeInSec(Long.valueOf(jObj.getLong("lt", 0L)));
        b.lwM2mVersion(jObj.getString("ver", "1.0"));
        b.registrationDate(new Date(jObj.getLong("regDate", 0L)));
        if (jObj.get("sms") != null) {
            b.smsNumber(jObj.getString("sms", ""));
        }
        JsonArray links = (JsonArray)jObj.get("objLink");
        Link[] linkObjs = new Link[links.size()];
        for (int i = 0; i < links.size(); ++i) {
            Link o;
            JsonObject ol = (JsonObject)links.get(i);
            HashMap<String, String> attMap = new HashMap<String, String>();
            JsonObject att = (JsonObject)ol.get("at");
            for (String k : att.names()) {
                JsonValue jsonValue = att.get(k);
                if (jsonValue.isNull()) {
                    attMap.put(k, null);
                    continue;
                }
                if (jsonValue.isNumber()) {
                    attMap.put(k, Integer.toString(jsonValue.asInt()));
                    continue;
                }
                attMap.put(k, jsonValue.asString());
            }
            linkObjs[i] = o = new Link(ol.getString("url", null), attMap);
        }
        b.objectLinks(linkObjs);
        HashMap<String, String> addAttr = new HashMap<String, String>();
        JsonObject o = (JsonObject)jObj.get("addAttr");
        for (String k : o.names()) {
            addAttr.put(k, o.getString(k, ""));
        }
        b.additionalRegistrationAttributes(addAttr);
        return b.build();
    }

    public static Registration deserialize(byte[] data) {
        return RegistrationSerDes.deserialize((JsonObject)Json.parse((String)new String(data)));
    }
}

