/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.SetParams;

@Deprecated
public class RedisLock {
    private static final Logger LOG = LoggerFactory.getLogger(RedisLock.class);
    private static final Random RND = new Random();
    private static final int LOCK_EXP = 500;

    public static byte[] acquire(Jedis j, byte[] lockKey) {
        long start = System.currentTimeMillis();
        byte[] randomLockValue = new byte[10];
        RND.nextBytes(randomLockValue);
        while (!"OK".equals(j.set(lockKey, randomLockValue, SetParams.setParams().nx().px(500L)))) {
            if (System.currentTimeMillis() - start > 5000L) {
                throw new IllegalStateException("Could not acquire a lock from redis");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return randomLockValue;
    }

    public static void release(Jedis j, byte[] lockKey, byte[] lockValue) {
        if (lockValue != null) {
            j.watch((byte[][])new byte[][]{lockKey});
            byte[] prevousLockValue = j.get(lockKey);
            if (Arrays.equals(prevousLockValue, lockValue)) {
                boolean succeed;
                Transaction transaction = j.multi();
                transaction.del(lockKey);
                boolean bl = succeed = transaction.exec() != null;
                if (!succeed) {
                    LOG.warn("Failed to release lock for key {}/{}, meaning the key probably expired because of acquiring the lock for too long (more than {}ms)", new Object[]{new String(lockKey), Hex.encodeHexString((byte[])lockValue), 500});
                }
            } else {
                LOG.warn("Nothing to release for key {}/{}, meaning the key probably expired because of acquiring the lock for too long (more than {}ms)", new Object[]{new String(lockKey), Hex.encodeHexString((byte[])lockValue), 500});
                j.unwatch();
            }
        } else {
            LOG.warn("Trying to release a lock for {} with a null value", (Object)new String(lockKey));
        }
    }
}

