/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.InetSocketAddress;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.PskIdentity;
import org.eclipse.leshan.core.peer.RpkIdentity;
import org.eclipse.leshan.core.peer.SocketIdentity;
import org.eclipse.leshan.core.peer.X509Identity;
import org.eclipse.leshan.core.util.Hex;

public class LwM2mIdentitySerDes {
    protected static final String KEY_ADDRESS = "address";
    protected static final String KEY_PORT = "port";
    protected static final String KEY_ID = "pskid";
    protected static final String KEY_CN = "cn";
    protected static final String KEY_RPK = "rpk";
    protected static final String KEY_LWM2MIDENTITY_TYPE = "type";
    protected static final String LWM2MIDENTITY_TYPE_UNSECURE = "unsecure";
    protected static final String LWM2MIDENTITY_TYPE_PSK = "psk";
    protected static final String LWM2MIDENTITY_TYPE_X509 = "x509";
    protected static final String LWM2MIDENTITY_TYPE_RPK = "rpk";

    public JsonNode serialize(LwM2mIdentity identity) {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        if (identity.getClass() == SocketIdentity.class) {
            o.put(KEY_LWM2MIDENTITY_TYPE, LWM2MIDENTITY_TYPE_UNSECURE);
            o.put(KEY_ADDRESS, ((SocketIdentity)identity).getSocketAddress().getHostString());
            o.put(KEY_PORT, ((SocketIdentity)identity).getSocketAddress().getPort());
        } else if (identity.getClass() == PskIdentity.class) {
            o.put(KEY_LWM2MIDENTITY_TYPE, LWM2MIDENTITY_TYPE_PSK);
            o.put(KEY_ID, ((PskIdentity)identity).getPskIdentity());
        } else if (identity.getClass() == RpkIdentity.class) {
            o.put(KEY_LWM2MIDENTITY_TYPE, "rpk");
            PublicKey publicKey = ((RpkIdentity)identity).getPublicKey();
            o.put("rpk", Hex.encodeHexString((byte[])publicKey.getEncoded()));
        } else if (identity.getClass() == X509Identity.class) {
            o.put(KEY_LWM2MIDENTITY_TYPE, LWM2MIDENTITY_TYPE_X509);
            o.put(KEY_CN, ((X509Identity)identity).getX509CommonName());
        } else {
            throw new IllegalStateException(String.format("Can not serialize %s", identity.getClass().getSimpleName()));
        }
        return o;
    }

    public LwM2mIdentity deserialize(JsonNode jObj) {
        if (jObj.get(KEY_LWM2MIDENTITY_TYPE).asText().equals(LWM2MIDENTITY_TYPE_UNSECURE)) {
            JsonNode jaddress = jObj.get(KEY_ADDRESS);
            JsonNode jport = jObj.get(KEY_PORT);
            if (jaddress != null && jport != null) {
                return new SocketIdentity(new InetSocketAddress(jaddress.asText(), jport.asInt()));
            }
            throw new IllegalStateException(String.format("Can not deserialize %s", jObj.toPrettyString()));
        }
        if (jObj.get(KEY_LWM2MIDENTITY_TYPE).asText().equals(LWM2MIDENTITY_TYPE_PSK)) {
            JsonNode jpsk = jObj.get(KEY_ID);
            if (jpsk != null) {
                return new PskIdentity(jpsk.asText());
            }
            throw new IllegalStateException(String.format("Can not deserialize %s", jObj.toPrettyString()));
        }
        if (jObj.get(KEY_LWM2MIDENTITY_TYPE).asText().equals("rpk")) {
            JsonNode jrpk = jObj.get("rpk");
            if (jrpk != null) {
                try {
                    byte[] rpk = Hex.decodeHex((char[])jrpk.asText().toCharArray());
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(rpk);
                    PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(spec);
                    return new RpkIdentity(publicKey);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalStateException("Invalid security info content", e);
                }
            }
            throw new IllegalStateException(String.format("Can not deserialize %s", jObj.toPrettyString()));
        }
        if (jObj.get(KEY_LWM2MIDENTITY_TYPE).asText().equals(LWM2MIDENTITY_TYPE_X509)) {
            JsonNode jcn = jObj.get(KEY_CN);
            if (jcn != null) {
                return new X509Identity(jcn.asText());
            }
            throw new IllegalStateException(String.format("Can not deserialize %s", jObj.toPrettyString()));
        }
        throw new IllegalStateException(String.format("Can not deserialize %s", jObj.toPrettyString()));
    }
}

