/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.InetSocketAddress;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.server.redis.serialization.LwM2mIdentitySerDes;

public class LwM2mPeerSerDes {
    protected static final String KEY_IDENTITY = "identity";
    protected static final String KEY_LWM2MPEER_TYPE = "type";
    protected static final String LWM2MPEER_TYPE_IP = "ip";
    protected static final String KEY_ADDRESS = "address";
    protected static final String KEY_PORT = "port";
    private final LwM2mIdentitySerDes identitySerDes = new LwM2mIdentitySerDes();

    public JsonNode serialize(LwM2mPeer peer) {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        if (peer.getClass() != IpPeer.class) {
            throw new IllegalStateException(String.format("Can not serialize %s", peer.getClass().getSimpleName()));
        }
        IpPeer ipPeer = (IpPeer)peer;
        o.put(KEY_ADDRESS, ipPeer.getSocketAddress().getHostString());
        o.put(KEY_PORT, ipPeer.getSocketAddress().getPort());
        o.put(KEY_LWM2MPEER_TYPE, LWM2MPEER_TYPE_IP);
        o.set(KEY_IDENTITY, this.identitySerDes.serialize(peer.getIdentity()));
        return o;
    }

    public LwM2mPeer deserialize(JsonNode jObj) throws IllegalStateException {
        if (jObj.get(KEY_LWM2MPEER_TYPE).asText().equals(LWM2MPEER_TYPE_IP)) {
            String address = jObj.get(KEY_ADDRESS).asText();
            int port = jObj.get(KEY_PORT).asInt();
            return new IpPeer(new InetSocketAddress(address, port), this.identitySerDes.deserialize(jObj.get(KEY_IDENTITY)));
        }
        throw new IllegalStateException(String.format("Invalid type of LWM2M Peer :  %s is not supported", jObj.get(KEY_LWM2MPEER_TYPE)));
    }
}

