/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.attributes.Attribute;
import org.eclipse.leshan.core.link.attributes.AttributeParser;
import org.eclipse.leshan.core.link.attributes.Attributes;
import org.eclipse.leshan.core.link.attributes.DefaultAttributeParser;
import org.eclipse.leshan.core.link.attributes.InvalidAttributeException;
import org.eclipse.leshan.core.link.lwm2m.MixedLwM2mLink;
import org.eclipse.leshan.core.link.lwm2m.attributes.LwM2mAttributes;
import org.eclipse.leshan.core.link.lwm2m.attributes.MixedLwM2mAttributeSet;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.server.redis.serialization.LwM2mPeerSerDes;
import org.eclipse.leshan.server.registration.Registration;

public class RegistrationSerDes {
    private final AttributeParser attributeParser;
    private final LwM2mPeerSerDes peerSerDes;

    public RegistrationSerDes(LwM2mPeerSerDes peerSerDes) {
        ArrayList suppportedAttributes = new ArrayList();
        suppportedAttributes.addAll(Attributes.ALL);
        suppportedAttributes.addAll(LwM2mAttributes.ALL);
        this.attributeParser = new DefaultAttributeParser(suppportedAttributes);
        this.peerSerDes = peerSerDes;
    }

    public RegistrationSerDes() {
        this.attributeParser = new DefaultAttributeParser();
        this.peerSerDes = new LwM2mPeerSerDes();
    }

    public RegistrationSerDes(AttributeParser attributeParser, LwM2mPeerSerDes peerSerDes) {
        this.attributeParser = attributeParser;
        this.peerSerDes = peerSerDes;
    }

    public JsonNode jSerialize(Registration r) {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        o.put("regDate", r.getRegistrationDate().getTime());
        o.set("transportdata", this.peerSerDes.serialize(r.getClientTransportData()));
        o.put("lt", r.getLifeTimeInSec());
        if (r.getSmsNumber() != null) {
            o.put("sms", r.getSmsNumber());
        }
        o.put("ver", r.getLwM2mVersion().toString());
        o.put("bnd", BindingMode.toString((EnumSet)r.getBindingMode()));
        if (r.getQueueMode() != null) {
            o.put("qm", r.getQueueMode());
        }
        o.put("ep", r.getEndpoint());
        o.put("regId", r.getId());
        o.put("epUri", r.getLastEndpointUsed().toString());
        ArrayNode links = JsonNodeFactory.instance.arrayNode();
        for (Link l : r.getObjectLinks()) {
            ObjectNode ol = JsonNodeFactory.instance.objectNode();
            ol.put("url", l.getUriReference());
            ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
            for (Attribute a : l.getAttributes()) {
                if (a.hasValue()) {
                    objectNode.put(a.getName(), a.getCoreLinkValue());
                    continue;
                }
                objectNode.set(a.getName(), null);
            }
            ol.set("at", (JsonNode)objectNode);
            links.add((JsonNode)ol);
        }
        o.set("objLink", (JsonNode)links);
        ObjectNode addAttr = JsonNodeFactory.instance.objectNode();
        for (Map.Entry e : r.getAdditionalRegistrationAttributes().entrySet()) {
            addAttr.put((String)e.getKey(), (String)e.getValue());
        }
        o.set("addAttr", (JsonNode)addAttr);
        o.put("root", r.getRootPath());
        o.put("lastUp", r.getLastUpdate().getTime());
        Set supportedContentFormat = r.getSupportedContentFormats();
        ArrayNode ct = JsonNodeFactory.instance.arrayNode();
        for (Object contentFormat : supportedContentFormat) {
            ct.add(contentFormat.getCode());
        }
        o.set("ct", (JsonNode)ct);
        ObjectNode so = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : r.getSupportedObject().entrySet()) {
            so.put(((Integer)entry.getKey()).toString(), ((LwM2m.Version)entry.getValue()).toString());
        }
        o.set("suppObjs", (JsonNode)so);
        ArrayNode ai = JsonNodeFactory.instance.arrayNode();
        for (LwM2mPath instance : r.getAvailableInstances()) {
            ai.add(instance.toString());
        }
        o.set("objInstances", (JsonNode)ai);
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry appData : r.getApplicationData().entrySet()) {
            objectNode.put((String)appData.getKey(), (String)appData.getValue());
        }
        o.set("appdata", (JsonNode)objectNode);
        return o;
    }

    public String sSerialize(Registration r) {
        return this.jSerialize(r).toString();
    }

    public byte[] bSerialize(Registration r) {
        return this.jSerialize(r).toString().getBytes();
    }

    public Registration deserialize(JsonNode jObj) {
        URI lastEndpointUsed;
        try {
            lastEndpointUsed = new URI(jObj.get("epUri").asText());
        }
        catch (URISyntaxException e1) {
            throw new IllegalStateException(String.format("Unable to deserialize last endpoint used URI %s of registration %s/%s", jObj.get("epUri").asText(), jObj.get("regId").asText(), jObj.get("ep").asText()));
        }
        Registration.Builder b = new Registration.Builder(jObj.get("regId").asText(), jObj.get("ep").asText(), this.peerSerDes.deserialize(jObj.get("transportdata")), lastEndpointUsed);
        b.bindingMode(BindingMode.parse((String)jObj.get("bnd").asText()));
        if (jObj.get("qm") != null) {
            b.queueMode(Boolean.valueOf(jObj.get("qm").asBoolean()));
        }
        b.lastUpdate(new Date(jObj.get("lastUp").asLong(0L)));
        b.lifeTimeInSec(Long.valueOf(jObj.get("lt").asLong(0L)));
        String versionAsString = jObj.get("ver").asText();
        LwM2m.LwM2mVersion lwm2mVersion = versionAsString == null ? LwM2m.LwM2mVersion.getDefault() : LwM2m.LwM2mVersion.get((String)versionAsString);
        b.lwM2mVersion(lwm2mVersion);
        b.registrationDate(new Date(jObj.get("regDate").asLong(0L)));
        if (jObj.get("sms") != null) {
            b.smsNumber(jObj.get("sms").asText(""));
        }
        String rootPath = jObj.get("root").asText("/");
        b.rootPath(rootPath);
        ArrayNode links = (ArrayNode)jObj.get("objLink");
        Link[] linkObjs = new Link[links.size()];
        for (int i = 0; i < links.size(); ++i) {
            Link o;
            ObjectNode ol = (ObjectNode)links.get(i);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            JsonNode att = ol.get("at");
            Iterator it = att.fieldNames();
            while (it.hasNext()) {
                String k = (String)it.next();
                JsonNode jsonValue = att.get(k);
                String attValue = jsonValue.isNull() ? null : (jsonValue.isNumber() ? Integer.toString(jsonValue.asInt()) : jsonValue.asText());
                try {
                    atts.add(this.attributeParser.parseCoreLinkValue(k, attValue));
                }
                catch (InvalidAttributeException e) {
                    throw new IllegalStateException(String.format("Unable to deserialize attribute value from links of registraiton %s/%s", jObj.get("regId").asText(), jObj.get("ep").asText()));
                }
            }
            String path = ol.get("url").asText();
            if (path.startsWith(rootPath)) {
                LwM2mPath lwm2mPath = LwM2mPath.parse((String)path, (String)rootPath);
                o = new MixedLwM2mLink(rootPath, lwm2mPath, new MixedLwM2mAttributeSet(atts));
            } else {
                o = new Link(path, atts);
            }
            linkObjs[i] = o;
        }
        b.objectLinks(linkObjs);
        HashMap<String, String> addAttr = new HashMap<String, String>();
        ObjectNode o = (ObjectNode)jObj.get("addAttr");
        Iterator it = o.fieldNames();
        while (it.hasNext()) {
            String k = (String)it.next();
            addAttr.put(k, o.get(k).asText(""));
        }
        b.additionalRegistrationAttributes(addAttr);
        JsonNode ct = jObj.get("ct");
        if (ct == null) {
            throw new IllegalStateException(String.format("Missing supported content format 'ct' field for registraiton %s/%s", jObj.get("regId").asText(), jObj.get("ep").asText()));
        }
        HashSet<ContentFormat> supportedContentFormat = new HashSet<ContentFormat>();
        for (JsonNode ctCode : ct) {
            supportedContentFormat.add(ContentFormat.fromCode((int)ctCode.asInt()));
        }
        b.supportedContentFormats(supportedContentFormat);
        JsonNode so = jObj.get("suppObjs");
        if (so == null) {
            throw new IllegalStateException(String.format("Missing supported object 'so' field for registraiton %s/%s", jObj.get("regId").asText(), jObj.get("ep").asText()));
        }
        HashMap<Integer, LwM2m.Version> supportedObject = new HashMap<Integer, LwM2m.Version>();
        Iterator it2 = so.fieldNames();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            supportedObject.put(Integer.parseInt(key), new LwM2m.Version(so.get(key).asText()));
        }
        b.supportedObjects(supportedObject);
        JsonNode ai = jObj.get("objInstances");
        if (ai == null) {
            throw new IllegalStateException(String.format("Missing available instances 'ai' field for registraiton %s/%s", jObj.get("regId").asText(), jObj.get("ep").asText()));
        }
        HashSet<LwM2mPath> availableInstances = new HashSet<LwM2mPath>();
        for (JsonNode aiPath : ai) {
            availableInstances.add(new LwM2mPath(aiPath.asText()));
        }
        b.availableInstances(availableInstances);
        HashMap<String, String> appData = new HashMap<String, String>();
        ObjectNode oap = (ObjectNode)jObj.get("appdata");
        Iterator it3 = oap.fieldNames();
        while (it3.hasNext()) {
            String key = (String)it3.next();
            JsonNode jv = oap.get(key);
            if (jv.isNull()) {
                appData.put(key, null);
                continue;
            }
            appData.put(key, jv.asText());
        }
        b.applicationData(appData);
        return b.build();
    }

    public Registration deserialize(byte[] data) {
        String json = new String(data);
        try {
            return this.deserialize(new ObjectMapper().readTree(json));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Unable to deserialize Registration %s", json), e);
        }
    }
}

