/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.Startable;
import org.eclipse.leshan.core.Stoppable;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.redis.JedisLock;
import org.eclipse.leshan.server.redis.SingleInstanceJedisLock;
import org.eclipse.leshan.server.redis.serialization.LwM2mIdentitySerDes;
import org.eclipse.leshan.server.redis.serialization.LwM2mPeerSerDes;
import org.eclipse.leshan.server.redis.serialization.ObservationSerDes;
import org.eclipse.leshan.server.redis.serialization.RegistrationSerDes;
import org.eclipse.leshan.server.registration.Deregistration;
import org.eclipse.leshan.server.registration.ExpirationListener;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.registration.UpdatedRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.Pool;

public class RedisRegistrationStore
implements RegistrationStore,
Startable,
Stoppable,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisRegistrationStore.class);
    private final String registrationByEndpointPrefix;
    private final String endpointByRegistrationIdPrefix;
    private final String endpointBySocketAddressPrefix;
    private final String endpointByIdentityPrefix;
    private final String endpointLockPrefix;
    private final byte[] observationTokenPrefix;
    private final String observationTokensByRegistrationIdPrefix;
    private final byte[] endpointExpirationKey;
    private final Pool<Jedis> pool;
    private ExpirationListener expirationListener;
    private final ScheduledExecutorService schedExecutor;
    private ScheduledFuture<?> cleanerTask;
    private boolean started = false;
    private final long cleanPeriod;
    private final int cleanLimit;
    private final long gracePeriod;
    private final JedisLock lock;
    private final RegistrationSerDes registrationSerDes;
    private final ObservationSerDes observationSerDes;
    private final LwM2mIdentitySerDes identitySerDes;

    public RedisRegistrationStore(Pool<Jedis> p) {
        this(new Builder(p).generateDefaultValue());
    }

    public RedisRegistrationStore(Builder builder) {
        this.pool = builder.pool;
        this.registrationByEndpointPrefix = builder.registrationByEndpointPrefix;
        this.endpointByRegistrationIdPrefix = builder.endpointByRegistrationIdPrefix;
        this.endpointBySocketAddressPrefix = builder.endpointBySocketAddressPrefix;
        this.endpointByIdentityPrefix = builder.endpointByIdentityPrefix;
        this.endpointLockPrefix = builder.endpointLockPrefix;
        this.observationTokenPrefix = builder.observationTokenPrefix.getBytes(StandardCharsets.UTF_8);
        this.observationTokensByRegistrationIdPrefix = builder.observationTokensByRegistrationIdPrefix;
        this.endpointExpirationKey = builder.endpointExpirationKey.getBytes(StandardCharsets.UTF_8);
        this.cleanPeriod = builder.cleanPeriod;
        this.cleanLimit = builder.cleanLimit;
        this.gracePeriod = builder.gracePeriod;
        this.schedExecutor = builder.schedExecutor;
        this.lock = builder.lock;
        this.registrationSerDes = builder.registrationSerDes;
        this.observationSerDes = builder.observationSerDes;
        this.identitySerDes = builder.identitySerDes;
    }

    private byte[] toKey(byte[] prefix, byte[] key) {
        byte[] result = new byte[prefix.length + key.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(key, 0, result, prefix.length, key.length);
        return result;
    }

    private byte[] toKey(String prefix, String registrationID) {
        return (prefix + registrationID).getBytes();
    }

    private byte[] toLockKey(String endpoint) {
        return this.toKey(this.endpointLockPrefix, endpoint);
    }

    private byte[] toLockKey(byte[] endpoint) {
        return this.toKey(this.endpointLockPrefix.getBytes(StandardCharsets.UTF_8), endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deregistration addRegistration(Registration registration) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] lockKey;
            byte[] lockValue;
            block14: {
                lockValue = null;
                lockKey = this.toLockKey(registration.getEndpoint());
                try {
                    lockValue = this.lock.acquire(j, lockKey);
                    byte[] k = this.toEndpointKey(registration.getEndpoint());
                    byte[] old = j.getSet(k, this.serializeReg(registration));
                    byte[] regid_idx = this.toRegIdKey(registration.getId());
                    j.set(regid_idx, registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
                    byte[] addr_idx = this.toRegAddrKey(registration.getSocketAddress());
                    j.set(addr_idx, registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
                    byte[] identity_idx = this.toRegIdentityKey(registration.getClientTransportData().getIdentity());
                    j.set(identity_idx, registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
                    this.addOrUpdateExpiration(j, registration);
                    if (old == null) break block14;
                    Registration oldRegistration = this.deserializeReg(old);
                    if (!registration.getId().equals(oldRegistration.getId())) {
                        j.del(this.toRegIdKey(oldRegistration.getId()));
                    }
                    if (!oldRegistration.getSocketAddress().equals(registration.getSocketAddress())) {
                        this.removeAddrIndex(j, oldRegistration);
                    }
                    if (!oldRegistration.getClientTransportData().getIdentity().equals(registration.getClientTransportData().getIdentity())) {
                        this.removeIdentityIndex(j, oldRegistration);
                    }
                    Collection<Observation> obsRemoved = this.unsafeRemoveAllObservations(j, oldRegistration.getId());
                    Deregistration deregistration = new Deregistration(oldRegistration, obsRemoved);
                    this.lock.release(j, lockKey, lockValue);
                    return deregistration;
                }
                catch (Throwable throwable) {
                    this.lock.release(j, lockKey, lockValue);
                    throw throwable;
                }
            }
            Deregistration deregistration = null;
            this.lock.release(j, lockKey, lockValue);
            return deregistration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatedRegistration updateRegistration(RegistrationUpdate update) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data;
            byte[] lockKey;
            byte[] lockValue;
            block15: {
                byte[] ep = j.get(this.toRegIdKey(update.getRegistrationId()));
                if (ep == null) {
                    UpdatedRegistration updatedRegistration = null;
                    return updatedRegistration;
                }
                lockValue = null;
                lockKey = this.toLockKey(ep);
                try {
                    lockValue = this.lock.acquire(j, lockKey);
                    data = j.get(this.toEndpointKey(ep));
                    if (data != null) break block15;
                    UpdatedRegistration updatedRegistration = null;
                    this.lock.release(j, lockKey, lockValue);
                    return updatedRegistration;
                }
                catch (Throwable throwable) {
                    this.lock.release(j, lockKey, lockValue);
                    throw throwable;
                }
            }
            Registration r = this.deserializeReg(data);
            Registration updatedRegistration = update.update(r);
            j.set(this.toEndpointKey(updatedRegistration.getEndpoint()), this.serializeReg(updatedRegistration));
            this.addOrUpdateExpiration(j, updatedRegistration);
            byte[] addr_idx = this.toRegAddrKey(updatedRegistration.getSocketAddress());
            j.set(addr_idx, updatedRegistration.getEndpoint().getBytes(StandardCharsets.UTF_8));
            if (!r.getSocketAddress().equals(updatedRegistration.getSocketAddress())) {
                this.removeAddrIndex(j, r);
            }
            byte[] identity_idx = this.toRegIdentityKey(updatedRegistration.getClientTransportData().getIdentity());
            j.set(identity_idx, updatedRegistration.getEndpoint().getBytes(StandardCharsets.UTF_8));
            if (!r.getClientTransportData().getIdentity().equals(updatedRegistration.getClientTransportData().getIdentity())) {
                this.removeIdentityIndex(j, r);
            }
            UpdatedRegistration updatedRegistration2 = new UpdatedRegistration(r, updatedRegistration);
            this.lock.release(j, lockKey, lockValue);
            return updatedRegistration2;
        }
    }

    public Registration getRegistration(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Registration registration = this.getRegistration(j, registrationId);
            return registration;
        }
    }

    public Registration getRegistrationByEndpoint(String endpoint) {
        Validate.notNull((Object)endpoint);
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get(this.toEndpointKey(endpoint));
            if (data == null) {
                Registration registration = null;
                return registration;
            }
            Registration registration = this.deserializeReg(data);
            return registration;
        }
    }

    public Registration getRegistrationByAdress(InetSocketAddress address) {
        Validate.notNull((Object)address);
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] ep = j.get(this.toRegAddrKey(address));
            if (ep == null) {
                Registration registration = null;
                return registration;
            }
            byte[] data = j.get(this.toEndpointKey(ep));
            if (data == null) {
                Registration registration = null;
                return registration;
            }
            Registration registration = this.deserializeReg(data);
            return registration;
        }
    }

    public Registration getRegistrationByIdentity(LwM2mIdentity identity) {
        Validate.notNull((Object)identity);
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] ep = j.get(this.toRegIdentityKey(identity));
            if (ep == null) {
                Registration registration = null;
                return registration;
            }
            byte[] data = j.get(this.toEndpointKey(ep));
            if (data == null) {
                Registration registration = null;
                return registration;
            }
            Registration registration = this.deserializeReg(data);
            return registration;
        }
    }

    public Iterator<Registration> getAllRegistrations() {
        return new RedisIterator(this.pool, new ScanParams().match(this.registrationByEndpointPrefix + "*").count(Integer.valueOf(100)));
    }

    public Deregistration removeRegistration(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Deregistration deregistration = this.removeRegistration(j, registrationId, false);
            return deregistration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deregistration removeRegistration(Jedis j, String registrationId, boolean removeOnlyIfNotAlive) {
        byte[] ep = j.get(this.toRegIdKey(registrationId));
        if (ep == null) {
            return null;
        }
        byte[] lockValue = null;
        byte[] lockKey = this.toLockKey(ep);
        try {
            long nbRemoved;
            lockValue = this.lock.acquire(j, lockKey);
            byte[] data = j.get(this.toEndpointKey(ep));
            if (data == null) {
                Deregistration deregistration = null;
                return deregistration;
            }
            Registration r = this.deserializeReg(data);
            if (!(removeOnlyIfNotAlive && r.isAlive(this.gracePeriod) || (nbRemoved = j.del(this.toRegIdKey(r.getId()))) <= 0L)) {
                j.del(this.toEndpointKey(r.getEndpoint()));
                Collection<Observation> obsRemoved = this.unsafeRemoveAllObservations(j, r.getId());
                this.removeAddrIndex(j, r);
                this.removeIdentityIndex(j, r);
                this.removeExpiration(j, r);
                Deregistration deregistration = new Deregistration(r, obsRemoved);
                return deregistration;
            }
            Deregistration deregistration = null;
            return deregistration;
        }
        finally {
            this.lock.release(j, lockKey, lockValue);
        }
    }

    private void removeAddrIndex(Jedis j, Registration r) {
        this.removeSecondaryIndex(j, this.toRegAddrKey(r.getSocketAddress()), r.getEndpoint());
    }

    private void removeIdentityIndex(Jedis j, Registration r) {
        this.removeSecondaryIndex(j, this.toRegIdentityKey(r.getClientTransportData().getIdentity()), r.getEndpoint());
    }

    private void removeSecondaryIndex(Jedis j, byte[] indexKey, String endpointName) {
        j.watch((byte[][])new byte[][]{indexKey});
        byte[] epFromAddr = j.get(indexKey);
        if (Arrays.equals(epFromAddr, endpointName.getBytes(StandardCharsets.UTF_8))) {
            Transaction transaction = j.multi();
            transaction.del(indexKey);
            transaction.exec();
        } else {
            j.unwatch();
        }
    }

    private void addOrUpdateExpiration(Jedis j, Registration registration) {
        j.zadd(this.endpointExpirationKey, (double)registration.getExpirationTimeStamp(this.gracePeriod), registration.getEndpoint().getBytes(StandardCharsets.UTF_8));
    }

    private void removeExpiration(Jedis j, Registration registration) {
        j.zrem(this.endpointExpirationKey, (byte[][])new byte[][]{registration.getEndpoint().getBytes(StandardCharsets.UTF_8)});
    }

    private byte[] toRegIdKey(String registrationId) {
        return this.toKey(this.endpointByRegistrationIdPrefix, registrationId);
    }

    private byte[] toRegAddrKey(InetSocketAddress addr) {
        return this.toKey(this.endpointBySocketAddressPrefix, addr.getAddress().toString() + ":" + addr.getPort());
    }

    private byte[] toRegIdentityKey(LwM2mIdentity identity) {
        return this.toKey(this.endpointByIdentityPrefix, this.identitySerDes.serialize(identity).toString());
    }

    private byte[] toEndpointKey(String endpoint) {
        return this.toKey(this.registrationByEndpointPrefix, endpoint);
    }

    private byte[] toEndpointKey(byte[] endpoint) {
        return this.toKey(this.registrationByEndpointPrefix.getBytes(StandardCharsets.UTF_8), endpoint);
    }

    private byte[] serializeReg(Registration registration) {
        return this.registrationSerDes.bSerialize(registration);
    }

    private Registration deserializeReg(byte[] data) {
        return this.registrationSerDes.deserialize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Observation> addObservation(String registrationId, Observation observation, boolean addIfAbsent) {
        ArrayList<Observation> removed = new ArrayList<Observation>();
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] ep = j.get(this.toRegIdKey(registrationId));
            if (ep == null) {
                throw new IllegalStateException(String.format("can not add observation %s there is no registration with id %s", observation, registrationId));
            }
            byte[] lockValue = null;
            byte[] lockKey = this.toLockKey(ep);
            try {
                byte[] previousValue;
                lockValue = this.lock.acquire(j, lockKey);
                byte[] key = this.toKey(this.observationTokenPrefix, observation.getId().getBytes());
                byte[] serializeObs = this.serializeObs(observation);
                if (addIfAbsent) {
                    previousValue = j.get(key);
                    if (previousValue == null || previousValue.length == 0) {
                        j.set(key, serializeObs);
                    }
                } else {
                    previousValue = j.getSet(key, serializeObs);
                }
                j.lpush(this.toKey(this.observationTokensByRegistrationIdPrefix, registrationId), (byte[][])new byte[][]{observation.getId().getBytes()});
                if (previousValue != null && previousValue.length != 0) {
                    Observation previousObservation = this.deserializeObs(previousValue);
                    LOG.warn("Token collision ? observation [{}] will be replaced by observation [{}] ", (Object)previousObservation, (Object)observation);
                }
                for (Observation obs : this.unsafeGetObservations(j, registrationId)) {
                    if (!this.areTheSamePaths(observation, obs) || observation.getId().equals((Object)obs.getId())) continue;
                    removed.add(obs);
                    this.unsafeRemoveObservation(j, registrationId, obs.getId());
                }
            }
            finally {
                this.lock.release(j, lockKey, lockValue);
            }
        }
        return removed;
    }

    private boolean areTheSamePaths(Observation observation, Observation obs) {
        if (observation instanceof SingleObservation && obs instanceof SingleObservation) {
            return ((SingleObservation)observation).getPath().equals((Object)((SingleObservation)obs).getPath());
        }
        if (observation instanceof CompositeObservation && obs instanceof CompositeObservation) {
            return ((CompositeObservation)observation).getPaths().equals(((CompositeObservation)obs).getPaths());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observation removeObservation(String registrationId, ObservationIdentifier observationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] lockKey;
            byte[] lockValue;
            block13: {
                byte[] ep = j.get(this.toRegIdKey(registrationId));
                if (ep == null) {
                    Observation observation = null;
                    return observation;
                }
                lockValue = null;
                lockKey = this.toLockKey(ep);
                try {
                    lockValue = this.lock.acquire(j, lockKey);
                    Observation observation = this.unsafeGetObservation(j, observationId);
                    if (observation == null || registrationId != null && !registrationId.equals(observation.getRegistrationId())) break block13;
                    this.unsafeRemoveObservation(j, registrationId, observationId);
                    Observation observation2 = observation;
                    this.lock.release(j, lockKey, lockValue);
                    return observation2;
                }
                catch (Throwable throwable) {
                    this.lock.release(j, lockKey, lockValue);
                    throw throwable;
                }
            }
            Observation observation = null;
            this.lock.release(j, lockKey, lockValue);
            return observation;
        }
    }

    public Observation getObservation(String registrationId, ObservationIdentifier observationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Observation observation = this.unsafeGetObservation(j, observationId);
            if (observation != null && registrationId.equals(observation.getRegistrationId())) {
                Observation observation2 = observation;
                return observation2;
            }
            Observation observation3 = null;
            return observation3;
        }
    }

    public Observation getObservation(ObservationIdentifier observationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Observation observation = this.unsafeGetObservation(j, observationId);
            return observation;
        }
    }

    public Collection<Observation> getObservations(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Collection<Observation> collection = this.unsafeGetObservations(j, registrationId);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Observation> removeObservations(String registrationId) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            Registration registration = this.getRegistration(j, registrationId);
            if (registration == null) {
                List<Observation> list = Collections.emptyList();
                return list;
            }
            String endpoint = registration.getEndpoint();
            byte[] lockValue = null;
            byte[] lockKey = this.toKey(this.endpointLockPrefix, endpoint);
            try {
                lockValue = this.lock.acquire(j, lockKey);
                Collection<Observation> collection = this.unsafeRemoveAllObservations(j, registrationId);
                this.lock.release(j, lockKey, lockValue);
                return collection;
            }
            catch (Throwable throwable) {
                this.lock.release(j, lockKey, lockValue);
                throw throwable;
            }
        }
    }

    private Registration getRegistration(Jedis j, String registrationId) {
        byte[] ep = j.get(this.toRegIdKey(registrationId));
        if (ep == null) {
            return null;
        }
        byte[] data = j.get(this.toEndpointKey(ep));
        if (data == null) {
            return null;
        }
        return this.deserializeReg(data);
    }

    private Collection<Observation> unsafeGetObservations(Jedis j, String registrationId) {
        ArrayList<Observation> result = new ArrayList<Observation>();
        for (byte[] token : j.lrange(this.toKey(this.observationTokensByRegistrationIdPrefix, registrationId), 0L, -1L)) {
            byte[] obs = j.get(this.toKey(this.observationTokenPrefix, token));
            if (obs == null) continue;
            result.add(this.deserializeObs(obs));
        }
        return result;
    }

    private Observation unsafeGetObservation(Jedis j, ObservationIdentifier observationId) {
        byte[] obs = j.get(this.toKey(this.observationTokenPrefix, observationId.getBytes()));
        if (obs == null) {
            return null;
        }
        return this.deserializeObs(obs);
    }

    private void unsafeRemoveObservation(Jedis j, String registrationId, ObservationIdentifier observationId) {
        if (j.del(this.toKey(this.observationTokenPrefix, observationId.getBytes())) > 0L) {
            j.lrem(this.toKey(this.observationTokensByRegistrationIdPrefix, registrationId), 0L, observationId.getBytes());
        }
    }

    private Collection<Observation> unsafeRemoveAllObservations(Jedis j, String registrationId) {
        ArrayList<Observation> removed = new ArrayList<Observation>();
        byte[] regIdKey = this.toKey(this.observationTokensByRegistrationIdPrefix, registrationId);
        for (byte[] token : j.lrange(regIdKey, 0L, -1L)) {
            byte[] obs = j.get(this.toKey(this.observationTokenPrefix, token));
            if (obs != null) {
                removed.add(this.deserializeObs(obs));
            }
            j.del(this.toKey(this.observationTokenPrefix, token));
        }
        j.del(regIdKey);
        return removed;
    }

    private byte[] serializeObs(Observation obs) {
        return this.observationSerDes.serialize(obs);
    }

    private Observation deserializeObs(byte[] data) {
        return this.observationSerDes.deserialize(data);
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.cleanerTask = this.schedExecutor.scheduleAtFixedRate(new Cleaner(), this.cleanPeriod, this.cleanPeriod, TimeUnit.SECONDS);
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (this.cleanerTask != null) {
                this.cleanerTask.cancel(false);
                this.cleanerTask = null;
            }
        }
    }

    public synchronized void destroy() {
        this.started = false;
        this.schedExecutor.shutdownNow();
        try {
            this.schedExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Destroying RedisRegistrationStore was interrupted.", (Throwable)e);
        }
    }

    public void setExpirationListener(ExpirationListener listener) {
        this.expirationListener = listener;
    }

    public static class Builder {
        private final Pool<Jedis> pool;
        private String prefix;
        private String registrationByEndpointPrefix;
        private String endpointByRegistrationIdPrefix;
        private String endpointBySocketAddressPrefix;
        private String endpointByIdentityPrefix;
        private String endpointLockPrefix;
        private String observationTokenPrefix;
        private String observationTokensByRegistrationIdPrefix;
        private String endpointExpirationKey;
        private long cleanPeriod;
        private int cleanLimit;
        private long gracePeriod;
        private ScheduledExecutorService schedExecutor;
        private JedisLock lock;
        private RegistrationSerDes registrationSerDes;
        private ObservationSerDes observationSerDes;
        private LwM2mIdentitySerDes identitySerDes;
        private LwM2mPeerSerDes peerSerDes;

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setRegistrationByEndpointPrefix(String registrationByEndpointPrefix) {
            this.registrationByEndpointPrefix = registrationByEndpointPrefix;
            return this;
        }

        public Builder setEndpointByRegistrationIdPrefix(String endpointByRegistrationIdPrefix) {
            this.endpointByRegistrationIdPrefix = endpointByRegistrationIdPrefix;
            return this;
        }

        public Builder setEndpointBySocketAddressPrefix(String endpointBySocketAddressPrefix) {
            this.endpointBySocketAddressPrefix = endpointBySocketAddressPrefix;
            return this;
        }

        public Builder setEndpointByIdentityPrefix(String endpointByIdentityPrefix) {
            this.endpointByIdentityPrefix = endpointByIdentityPrefix;
            return this;
        }

        public Builder setEndpointLockPrefix(String endpointLockPrefix) {
            this.endpointLockPrefix = endpointLockPrefix;
            return this;
        }

        public Builder setObservationTokenPrefix(String observationTokenPrefix) {
            this.observationTokenPrefix = observationTokenPrefix;
            return this;
        }

        public Builder setObservationTokensByRegistrationIdPrefix(String observationTokensByRegistrationIdPrefix) {
            this.observationTokensByRegistrationIdPrefix = observationTokensByRegistrationIdPrefix;
            return this;
        }

        public Builder setEndpointExpirationKey(String endpointExpirationKey) {
            this.endpointExpirationKey = endpointExpirationKey;
            return this;
        }

        public Builder setCleanPeriod(long cleanPeriod) {
            this.cleanPeriod = cleanPeriod;
            return this;
        }

        public Builder setCleanLimit(int cleanLimit) {
            this.cleanLimit = cleanLimit;
            return this;
        }

        public Builder setGracePeriod(long gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        public Builder setSchedExecutor(ScheduledExecutorService schedExecutor) {
            this.schedExecutor = schedExecutor;
            return this;
        }

        public Builder setLock(JedisLock lock) {
            this.lock = lock;
            return this;
        }

        public Builder setRegistrationSerDes(RegistrationSerDes registrationSerDes) {
            this.registrationSerDes = registrationSerDes;
            return this;
        }

        public Builder setIdentitySerDes(LwM2mIdentitySerDes identitySerDes) {
            this.identitySerDes = identitySerDes;
            return this;
        }

        public Builder setPeerSerDes(LwM2mPeerSerDes peerSerDes) {
            this.peerSerDes = peerSerDes;
            return this;
        }

        public Builder setObservationSerDes(ObservationSerDes observationSerDes) {
            this.observationSerDes = observationSerDes;
            return this;
        }

        public Builder(Pool<Jedis> pool) {
            this.pool = pool;
            this.prefix = "REGSTORE#";
            this.registrationByEndpointPrefix = "REG#EP#";
            this.endpointByRegistrationIdPrefix = "EP#REGID#";
            this.endpointBySocketAddressPrefix = "EP#ADDR#";
            this.endpointByIdentityPrefix = "EP#IDENTITY#";
            this.endpointLockPrefix = "LOCK#EP#";
            this.observationTokenPrefix = "OBS#TKN#";
            this.observationTokensByRegistrationIdPrefix = "TKNS#REGID#";
            this.endpointExpirationKey = "EXP#EP";
            this.cleanPeriod = 60L;
            this.cleanLimit = 500;
            this.gracePeriod = 0L;
        }

        protected Builder generateDefaultValue() {
            if (this.schedExecutor == null) {
                this.schedExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(String.format("RedisRegistrationStore Cleaner (%ds)", this.cleanPeriod)));
            }
            if (this.lock == null) {
                this.lock = new SingleInstanceJedisLock();
            }
            if (this.registrationSerDes == null) {
                if (this.peerSerDes == null) {
                    this.peerSerDes = new LwM2mPeerSerDes();
                }
                this.registrationSerDes = new RegistrationSerDes(this.peerSerDes);
            }
            if (this.identitySerDes == null) {
                this.identitySerDes = new LwM2mIdentitySerDes();
            }
            if (this.observationSerDes == null) {
                this.observationSerDes = new ObservationSerDes();
            }
            return this;
        }

        public RedisRegistrationStore build() throws IllegalArgumentException {
            if (this.registrationByEndpointPrefix == null || this.registrationByEndpointPrefix.isEmpty()) {
                throw new IllegalArgumentException("registrationByEndpointPrefix should not be empty");
            }
            if (this.endpointByRegistrationIdPrefix == null || this.endpointByRegistrationIdPrefix.isEmpty()) {
                throw new IllegalArgumentException("endpointByRegistrationIdPrefix should not be empty");
            }
            if (this.endpointBySocketAddressPrefix == null || this.endpointBySocketAddressPrefix.isEmpty()) {
                throw new IllegalArgumentException("endpointBySocketAddressPrefix should not be empty");
            }
            if (this.endpointByIdentityPrefix == null || this.endpointByIdentityPrefix.isEmpty()) {
                throw new IllegalArgumentException("endpointByIdentityPrefix should not be empty");
            }
            if (this.endpointLockPrefix == null || this.endpointLockPrefix.isEmpty()) {
                throw new IllegalArgumentException("endpointLockPrefix should not be empty");
            }
            if (this.observationTokenPrefix == null || this.observationTokenPrefix.isEmpty()) {
                throw new IllegalArgumentException("observationTokenPrefix should not be empty");
            }
            if (this.observationTokensByRegistrationIdPrefix == null || this.observationTokensByRegistrationIdPrefix.isEmpty()) {
                throw new IllegalArgumentException("observationTokensByRegistrationIdPrefix should not be empty");
            }
            if (this.endpointExpirationKey == null || this.endpointExpirationKey.isEmpty()) {
                throw new IllegalArgumentException("endpointExpirationKey should not be empty");
            }
            String[] prefixes = new String[]{this.registrationByEndpointPrefix, this.endpointByRegistrationIdPrefix, this.endpointBySocketAddressPrefix, this.endpointByIdentityPrefix, this.endpointLockPrefix, this.observationTokenPrefix, this.observationTokensByRegistrationIdPrefix, this.endpointExpirationKey};
            HashSet<String> uniquePrefixes = new HashSet<String>();
            for (String prefix : prefixes) {
                if (uniquePrefixes.add(prefix)) continue;
                throw new IllegalArgumentException(String.format("prefix name %s is taken already", prefix));
            }
            if (this.prefix != null) {
                this.registrationByEndpointPrefix = this.prefix + this.registrationByEndpointPrefix;
                this.endpointByRegistrationIdPrefix = this.prefix + this.endpointByRegistrationIdPrefix;
                this.endpointBySocketAddressPrefix = this.prefix + this.endpointBySocketAddressPrefix;
                this.endpointByIdentityPrefix = this.prefix + this.endpointByIdentityPrefix;
                this.endpointLockPrefix = this.prefix + this.endpointLockPrefix;
                this.observationTokenPrefix = this.prefix + this.observationTokenPrefix;
                this.observationTokensByRegistrationIdPrefix = this.prefix + this.observationTokensByRegistrationIdPrefix;
                this.endpointExpirationKey = this.prefix + this.endpointExpirationKey;
            }
            this.generateDefaultValue();
            return new RedisRegistrationStore(this);
        }
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            try (Jedis j = (Jedis)RedisRegistrationStore.this.pool.getResource();){
                List endpointsExpired = j.zrangeByScore(RedisRegistrationStore.this.endpointExpirationKey, Double.NEGATIVE_INFINITY, (double)System.currentTimeMillis(), 0, RedisRegistrationStore.this.cleanLimit);
                for (byte[] endpoint : endpointsExpired) {
                    Deregistration dereg;
                    Registration r;
                    byte[] regBytes = j.get(RedisRegistrationStore.this.toEndpointKey(endpoint));
                    if (regBytes == null || (r = RedisRegistrationStore.this.deserializeReg(regBytes)).isAlive(RedisRegistrationStore.this.gracePeriod) || (dereg = RedisRegistrationStore.this.removeRegistration(j, r.getId(), true)) == null) continue;
                    RedisRegistrationStore.this.expirationListener.registrationExpired(dereg.getRegistration(), dereg.getObservations());
                }
            }
            catch (RuntimeException e) {
                LOG.warn("Unexpected Exception while registration cleaning", (Throwable)e);
            }
        }
    }

    protected class RedisIterator
    implements Iterator<Registration> {
        private final Pool<Jedis> pool;
        private final ScanParams scanParams;
        private String cursor;
        private List<Registration> scanResult;

        public RedisIterator(Pool<Jedis> p, ScanParams scanParams) {
            this.pool = p;
            this.scanParams = scanParams;
            this.scanNext("0");
        }

        private void scanNext(String cursor) {
            try (Jedis j = (Jedis)this.pool.getResource();){
                ScanResult sr;
                do {
                    sr = j.scan(cursor.getBytes(), this.scanParams);
                    this.scanResult = new ArrayList<Registration>();
                    if (sr.getResult() == null || sr.getResult().isEmpty()) continue;
                    for (byte[] value : j.mget((byte[][])sr.getResult().toArray((T[])new byte[0][]))) {
                        this.scanResult.add(RedisRegistrationStore.this.deserializeReg(value));
                    }
                } while (!"0".equals(cursor = sr.getCursor()) && this.scanResult.isEmpty());
                this.cursor = cursor;
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.scanResult.isEmpty()) {
                return true;
            }
            if ("0".equals(this.cursor)) {
                return false;
            }
            this.scanNext(this.cursor);
            return !this.scanResult.isEmpty();
        }

        @Override
        public Registration next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.scanResult.remove(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

