/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.server.redis.serialization.SecurityInfoSerDes;
import org.eclipse.leshan.server.security.EditableSecurityStore;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStoreListener;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.Pool;

public class RedisSecurityStore
implements EditableSecurityStore {
    private final String securityInfoByEndpointPrefix;
    private final String endpointByPskIdKey;
    private final Pool<Jedis> pool;
    private final List<SecurityStoreListener> listeners = new CopyOnWriteArrayList<SecurityStoreListener>();

    public RedisSecurityStore(Pool<Jedis> pool) {
        this(new Builder(pool));
    }

    protected RedisSecurityStore(Builder builder) {
        this.pool = builder.pool;
        this.securityInfoByEndpointPrefix = builder.securityInfoByEndpointPrefix;
        this.endpointByPskIdKey = builder.endpointByPskIdKey;
    }

    public SecurityInfo getByEndpoint(String endpoint) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get((this.securityInfoByEndpointPrefix + endpoint).getBytes());
            if (data == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            SecurityInfo securityInfo = this.deserialize(data);
            return securityInfo;
        }
    }

    public SecurityInfo getByIdentity(String identity) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            String ep = j.hget(this.endpointByPskIdKey, identity);
            if (ep == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            byte[] data = j.get((this.securityInfoByEndpointPrefix + ep).getBytes());
            if (data == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            SecurityInfo securityInfo = this.deserialize(data);
            return securityInfo;
        }
    }

    public SecurityInfo getByOscoreIdentity(OscoreIdentity pskIdentity) {
        return null;
    }

    public Collection<SecurityInfo> getAll() {
        try (Jedis j = (Jedis)this.pool.getResource();){
            ScanResult res;
            ScanParams params = new ScanParams().match(this.securityInfoByEndpointPrefix + "*").count(Integer.valueOf(100));
            LinkedList<SecurityInfo> list = new LinkedList<SecurityInfo>();
            String cursor = "0";
            do {
                res = j.scan(cursor.getBytes(), params);
                for (byte[] key : res.getResult()) {
                    byte[] element = j.get(key);
                    list.add(this.deserialize(element));
                }
            } while (!"0".equals(cursor = res.getCursor()));
            LinkedList<SecurityInfo> linkedList = list;
            return linkedList;
        }
    }

    public SecurityInfo add(SecurityInfo info) throws NonUniqueSecurityInfoException {
        byte[] data = this.serialize(info);
        try (Jedis j = (Jedis)this.pool.getResource();){
            String previousIdentity;
            byte[] previousData;
            if (info.getPskIdentity() != null) {
                String oldEndpoint = j.hget(this.endpointByPskIdKey, info.getPskIdentity());
                if (oldEndpoint != null && !oldEndpoint.equals(info.getEndpoint())) {
                    throw new NonUniqueSecurityInfoException("PSK Identity " + info.getPskIdentity() + " is already used");
                }
                j.hset(this.endpointByPskIdKey.getBytes(), info.getPskIdentity().getBytes(), info.getEndpoint().getBytes());
            }
            SecurityInfo previous = (previousData = j.getSet((this.securityInfoByEndpointPrefix + info.getEndpoint()).getBytes(), data)) == null ? null : this.deserialize(previousData);
            String string = previousIdentity = previous == null ? null : previous.getPskIdentity();
            if (previousIdentity != null && !previousIdentity.equals(info.getPskIdentity())) {
                j.hdel(this.endpointByPskIdKey, new String[]{previousIdentity});
            }
            SecurityInfo securityInfo = previous;
            return securityInfo;
        }
    }

    public SecurityInfo remove(String endpoint, boolean infosAreCompromised) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get((this.securityInfoByEndpointPrefix + endpoint).getBytes());
            if (data != null) {
                SecurityInfo info = this.deserialize(data);
                if (info.getPskIdentity() != null) {
                    j.hdel(this.endpointByPskIdKey.getBytes(), (byte[][])new byte[][]{info.getPskIdentity().getBytes()});
                }
                j.del((this.securityInfoByEndpointPrefix + endpoint).getBytes());
                for (SecurityStoreListener listener : this.listeners) {
                    listener.securityInfoRemoved(infosAreCompromised, new SecurityInfo[]{info});
                }
                SecurityInfo securityInfo = info;
                return securityInfo;
            }
        }
        return null;
    }

    private byte[] serialize(SecurityInfo secInfo) {
        return SecurityInfoSerDes.serialize(secInfo);
    }

    private SecurityInfo deserialize(byte[] data) {
        return SecurityInfoSerDes.deserialize(data);
    }

    public void addListener(SecurityStoreListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SecurityStoreListener listener) {
        this.listeners.remove(listener);
    }

    public static class Builder {
        private final Pool<Jedis> pool;
        private String securityInfoByEndpointPrefix;
        private String endpointByPskIdKey;
        private String prefix;

        public Builder setSecurityInfoByEndpointPrefix(String securityInfoByEndpointPrefix) {
            this.securityInfoByEndpointPrefix = securityInfoByEndpointPrefix;
            return this;
        }

        public Builder setEndpointByPskIdKey(String endpointByPskIdKey) {
            this.endpointByPskIdKey = endpointByPskIdKey;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder(Pool<Jedis> pool) {
            this.pool = pool;
            this.prefix = "SECSTORE#";
            this.securityInfoByEndpointPrefix = "SEC#EP#";
            this.endpointByPskIdKey = "EP#PSKID";
        }

        public RedisSecurityStore build() throws IllegalArgumentException {
            if (this.securityInfoByEndpointPrefix == null || this.securityInfoByEndpointPrefix.isEmpty()) {
                throw new IllegalArgumentException("securityInfoByEndpointPrefix should not be empty");
            }
            if (this.endpointByPskIdKey == null || this.endpointByPskIdKey.isEmpty()) {
                throw new IllegalArgumentException("endpointByPskIdKey should not be empty");
            }
            if (this.securityInfoByEndpointPrefix.equals(this.endpointByPskIdKey)) {
                throw new IllegalArgumentException("securityInfoByEndpointPrefix should not be equal to endpointByPskIdKey");
            }
            if (this.prefix != null) {
                this.securityInfoByEndpointPrefix = this.prefix + this.securityInfoByEndpointPrefix;
                this.endpointByPskIdKey = this.prefix + this.endpointByPskIdKey;
            }
            return new RedisSecurityStore(this);
        }
    }
}

